@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.survey_results')}}</title>
@endsection
@section('content')

<style>
    .table.dataTable th, .table.dataTable td {
        white-space: nowrap;
    }
</style>

    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.survey_results')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.survey_results')}}</li>
                </ol>
            </div>
        
        <!-- End Page Header -->
        <div class="btn btn-list">
            <a href="#"  data-bs-toggle="modal" data-bs-target="#importsurveysmodel">
                <button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{__('home.import_surveys_Excel')}}
                </button>
            </a>
        </div>
        </div>
        
        <!-- Row-->
        
        
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.survey_statistics')}}</h6>
                            <br>
                        </div>
                        
                            <div class="row d-flex justify-content-between">
        						<div class="col-sm-6 col-md-6 col-xl-2">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-success-transparent rounded-circle text-success">
        									    <i class="far fa-grin-stars"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.Perfect')}}</p>
        									<h3 class="mb-0">{{$perfect_count}}</h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-2">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-primary-transparent rounded-circle text-primary">
        									    <i class="far fa-laugh-beam"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.Good')}}</p>
        									<h3 class="mb-0">{{$good_count}}</h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-2">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-info-transparent rounded-circle text-info">
        										<i class="far fa-smile"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.Average')}}</p>
        									<h3 class="mb-0">{{$average_count}}</h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-2">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-secondary-transparent rounded-circle text-secondary">
        										<i class="far fa-meh"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.Poor')}}</p>
        									<h3 class="mb-0">{{$poor_count}}</h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-2">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-danger-transparent rounded-circle text-danger">
        										<i class="far fa-frown"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.Very Bad')}}</p>
        									<h3 class="mb-0">{{$very_bad_count}}</h3>
        								</div>
        							</div>
        						</div>
        					</div>
					
                        </div>
                    </div>
                </div>
            </div>

        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.survey_results')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <!--<th><input type="checkbox" id="checkAll"/></th>-->
                                    {{--<th>{{trans('home.id')}}</th>--}}
                                    @if($survey->survay_type != 'company')<th>{{trans('home.name')}}</th>@endif
                                    @php
                                        $q = [];
                                    @endphp
                                    @foreach($survey->surveyQuestions as $result)
                                        <th>{{ $result->{'question_'.$lang} }}</th>
                                        @php
                                            $q[]= $result->id;
                                        @endphp
                                    @endforeach
                                </tr>
                            </thead>
                            <tbody>
                                @if($survey->survay_type == 'company')
                                    @foreach($company_q_ids as $user_id)
                                        <tr id="{{$survey->singleSurvayResult($survey->id,null,$training_id)[0]->id}}">
                                            {{--<td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$result->id}}" /> </td>--}}
                                                {{--<td><a href='javascript::avoid(0)'>{{$survey->singleSurvayResult($survey->id,null,$training_id)[0]->id}}</a></td>--}}
                                            @foreach($survey->singleSurvayResult($survey->id,null,$training_id)->sortBy('survay_question_id') as $result)
                                                <td><a href="javascript::avoid(0)">{{ $result->survayQuestion->question_type == 'rate' ? trans('home.'. $result->answer) : $result->answer ?? '' }}</a></td>
                                            @endforeach
                                        </tr>
                                    @endforeach
                                @else
                                    @foreach($user_ids as $user_id)
                                        <tr id="{{$survey->singleSurvayResult($survey->id,$user_id,$training_id)[0]->user_id}}">
                                            {{--<td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$result->id}}" /> </td>--}}
                                                {{--<td><a href='javascript::avoid(0)'>{{$survey->singleSurvayResult($survey->id,$user_id,$training_id)[0]->id}}</a></td>--}}
                                            <td><a href='javascript::avoid(0)'>{{App\Models\User::find($survey->singleSurvayResult($survey->id,$user_id,$training_id)[0]->user_id)->f_name}}</a></td>
                                            @foreach($survey->singleSurvayResult($survey->id,$user_id,$training_id)->sortBy('survay_question_id') as $i => $result)
                                                <td><a href="javascript::avoid(0)">{{ $result->survayQuestion->question_type == 'rate' ? trans('home.'. $result->answer) : $result->answer ?? '' }}</a></td>
                                            @endforeach
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
					</div>
                    </div>

                </div>
            </div>
        </div>
        
        <div class="modal fade bd-example-modal-lg" id="importsurveysmodel" tabindex="-1" role="dialog" aria-labelledby="importtrainingsmodelTitle" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" style="border-radius: 35px;">
                    <div class="modal-header">
                         <!--<img src="{{url('resources/assets/back/img/surveys_excel.png')}}" class="col-12">-->
                    </div>
                    <form method="post" action="{{ route('surveys.import.excel') }}" enctype="multipart/form-data">
                          <div class="modal-body ">
                                <div class="m-auto col-8">
                                        @csrf
                                        <div class="input-group mb-1 d-flex justify-content-first">
                                            <div class="input-group-prepend"> 
                                                <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                            </div>
                                            <div class="custom-file col-12">
                                                <input type="file" class="custom-file-input" name="excelFile"  accept=".csv,.xlsx">
                                                <label class="custom-file-label"
                                                    for="inputGroupFile01">{{ trans('home.choose_excel_file') }}</label>
                                            </div>
                                           
                                        </div>
                                </div>
                          </div>
                          <div class="modal-footer justify-content-center ">
                               <button class="btn ripple btn-primary " type="submit"><i
                                            class="fas fa-plus-circle"></i>
                                            {{ trans('home.importExcel') }}</button>
                                <button id="closeModalButton" type="button" class="btn btn-secondary " data-bs-dismiss="modal">Close</button>
                          </div>
                    </form>
                </div>
              
              </div>
            </div>
            
        <!-- End Row -->
    </div>
@endsection
@section('script')
<script>
    ///////check All data table//////
        var lang = "{{app()->getLocale()}}";
        var perm = "{{auth()->user()->can('survey_export_buttons')}}"; 
            if(perm){ 
                if(lang == "ar"){
                    var table = $('#exportexample').DataTable( {
                		lengthChange: false,
                		dom: 'Bfrtip',
                		"bPaginate" : true,
                		"pageLength": 50,
                		buttons: [ 'copy', 'excel', 'colvis','pageLength' ],
                		language: {
                            url: '//cdn.datatables.net/plug-ins/1.13.3/i18n/ar.json',
                        },
                	} );
                }else{
                    var table = $('#exportexample').DataTable( {
                		lengthChange: false,
                		dom: 'Bfrtip',
                		"pageLength": 50,
                		buttons: [ 'copy', 'excel', 'colvis','pageLength' ],
                	} );
                }
            }  else {
                if(lang == "ar"){
                    var table = $('#exportexample').DataTable( {
                		lengthChange: false,
                		dom: 'Bfrtip',
                		"bPaginate" : true,
                		"pageLength": 50,
                		buttons: [ 'copy','colvis','pageLength' ],
                		language: {
                            url: '//cdn.datatables.net/plug-ins/1.13.3/i18n/ar.json',
                        },
                	} );
                }else{
                    var table = $('#exportexample').DataTable( {
                		lengthChange: false,
                		dom: 'Bfrtip',
                		"pageLength": 50,
                		buttons: [ 'copy','colvis','pageLength' ],
                	} );
                }
             } 
        
        }else{
            if(lang == "ar"){
                var table = $('#exportexample').DataTable( {
            		lengthChange: false,
            		dom: 'Bfrtip',
            		"pageLength": 50,
            		buttons: [  ],
            		language: {
                        url: '//cdn.datatables.net/plug-ins/1.13.3/i18n/ar.json',
                    },
            	} );
            }else{
                var table = $('#exportexample').DataTable( {
            		lengthChange: false,
            		dom: 'Bfrtip',
            		"pageLength": 50,
            		buttons: [ ],
            	} );
            }
        }
</script>
@endsection