@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit_survey')}}</title>
@endsection
@section('content')

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.surveys')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/surveys')}}">{{trans('home.surveys')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_survey')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->


        {!! Form::open(['method'=>'PATCH','url' => 'admin/surveys/'.$survey->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
            <!-- Row-->
            <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        
                        <div class="card-body">
                            <div>
                                <h6 class="card-title mb-1">{{trans('home.surveys')}}</h6>
                                <hr>
                            </div>
                            <div class="row">
                                
                                <div class="form-group col-md-5">
                                    <label class="">{{trans('home.name_en')}}</label>
                                    <input class="form-control" name="name_en" type="text" placeholder="{{trans('home.name_en')}}" value="{{old('name_en',$survey->name_en)}}" required>
                                </div>

                                <div class="form-group col-md-5">
                                    <label class="">{{trans('home.name_ar')}}</label>
                                    <input class="form-control" name="name_ar" type="text" placeholder="{{trans('home.name_ar')}}" value="{{old('name_ar',$survey->name_ar)}}" required>
                                </div>
                                
                                <div class="form-group col-md-2">
                                    <label for="parent">{{trans('home.survay_type')}}</label>
                                    <select class="form-control select2" name="survay_type">
                                        <option value="student" @selected(old('survay_type',$survey->survay_type) == 'student')>{{trans('home.student')}}</option>
                                        <option value="instructor" @selected(old('survay_type',$survey->survay_type) == 'instructor')>{{trans('home.instructor')}}</option>
                                        <option value="company" @selected(old('survay_type',$survey->survay_type) == 'company')>{{trans('home.company')}}</option>
                                    </select>
                                </div>
                                @can('status_or_publish_field')
                                <div class="form-group col-md-12">
                                    <p class="mt-4 mb-2">{{trans('home.publish')}}</p>
                                    <label class="custom-switch">
                                        <input type="checkbox" name="status" value="1" class="custom-switch-input" @if($survey->status == 1) checked @endif >
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">{{trans('home.click_to_publish_content')}}</span>
                                    </label>
                                </div>
                                @endcan
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Row -->
            
            <!-- Row-->
            <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        
                        <div class="card-body">
                            <div>
                                <h6 class="card-title mb-1">{{trans('home.survey_questions')}}</h6>
                                <hr>
                            </div>

                            <div class="question_wrapper">
                                @if(count($surveyQuestions) > 0)
                                    @foreach($surveyQuestions as $key=>$question)
                                        <div class="row">
                                            <div class="form-group col-md-3"> 
                                                <label for="question_en">{{trans('home.question_en')}}</label>
                                                <input type="text" class="form-control" placeholder="{{trans('home.question_en')}}" value="{{old('question_en',$question->question_en)}}" disabled>
                                            </div>
                                            
                                            <div class="form-group col-md-3"> 
                                                <label for="question_ar">{{trans('home.question_ar')}}</label>
                                                <input type="text"  class="form-control" placeholder="{{trans('home.question_ar')}}"  value="{{old('question_ar',$question->question_ar)}}" disabled>
                                            </div>
                                            
                                            <div class="form-group col-md-3">
                                                <label for="question_type">{{trans('home.question_type')}}</label>
                                                <select class="form-control select2">
                                                    <option value="notes" @selected(old('question_type',$question->question_type) == 'notes')>{{trans('home.notes')}}</option>
                                                    <option value="question" @selected(old('question_type',$question->question_type) == 'question')>{{trans('home.question')}}</option>
                                                    <option value="rate" @selected(old('question_type',$question->question_type) == 'rate')>{{trans('home.rate')}}</option>
                                                    <option value="file" @selected(old('question_type',$question->question_type) == 'file')>{{trans('home.file')}}</option>
                                                    <option value="link" @selected(old('question_type',$question->question_type) == 'link')>{{trans('home.link')}}</option>
                                                </select>
                                            </div>
                                            
                                            <div class="form-group col-md-2">
                                                <button type="button" style="margin-top: 28px;" class="btn" data-bs-toggle="modal" data-bs-target="#question_{{$key}}"><i class="fas fa-edit"></i></button>
                                                <button type="button" style="margin-top: 28px;" class="btn rmv-question" data-question_id="{{$question->id}}" id="type-error"><i class="fas fa-trash-alt"></i></button>
                                            </div>
                                        </div>  
                                    @endforeach
                                @else
                                    <div class="row">
                                        <div class="form-group col-md-3"> 
                                            <label for="question_en">{{trans('home.question_en')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.question_en')}}" name="question_en[]">
                                        </div>
                                        
                                         <div class="form-group col-md-3"> 
                                            <label for="question_ar">{{trans('home.question_ar')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.question_ar')}}" name="question_ar[]">
                                        </div>
    
                                        <div class="form-group col-md-5">
                                        <label for="question_type">{{trans('home.question_type')}}</label>
                                        <select class="form-control select2" name="question_type[]">
                                            <option value="notes" @selected(old('question_type') == 'notes')>{{trans('home.notes')}}</option>
                                            <option value="question" @selected(old('question_type') == 'question')>{{trans('home.question')}}</option>
                                            <option value="rate" @selected(old('question_type') == 'rate')>{{trans('home.rate')}}</option>
                                            <option value="file" @selected(old('question_type') == 'file')>{{trans('home.file')}}</option>
                                            <option value="link" @selected(old('question_type') == 'link')>{{trans('home.link')}}</option>
                                        </select>
                                    </div>
                                    </div>  
                                @endif
                                
                            </div>       
                            <a href="javascript:void(0);" class="add_question btn" title="Add field"><i class="fas fa-plus-square"></i></a>								
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Row -->
            
            <!-- Row-->
            <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                    <a href="{{url('/admin/surveys')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Row -->    
        {!! Form::close() !!}
        
                        
 
         <!-- Modal -->
        @foreach($surveyQuestions as $key=>$question)
            <div class="modal fade text-left" id="question_{{$key}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h3 class="modal-title" id="myModalLabel34">{{trans('home.edit_survey_question')}}</h3>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="{{route('updateSurveyQuestion')}}" method="post">
                            @csrf
                            <div class="modal-body">
                                <div class="row">
                                    <div class="form-group col-md-3"> 
                                        <label for="question_en">{{trans('home.question_en')}}</label>
                                        <input type="text"  class="form-control" placeholder="{{trans('home.question_en')}}" name="question_en" value="{{old('question_en',$question->question_en)}}">
                                    </div>
                                    
                                    <div class="form-group col-md-3"> 
                                        <label for="question_ar">{{trans('home.question_ar')}}</label>
                                        <input type="text"  class="form-control" placeholder="{{trans('home.question_ar')}}" name="question_ar" value="{{old('question_ar',$question->question_ar)}}">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="question_type">{{trans('home.question_type')}}</label>
                                        <select class="form-control select2" name="question_type">
                                            <option value="notes" @selected(old('question_type',$question->question_type) == 'notes')>{{trans('home.notes')}}</option>
                                            <option value="question" @selected(old('question_type',$question->question_type) == 'question')>{{trans('home.question')}}</option>
                                            <option value="rate" @selected(old('question_type',$question->question_type) == 'rate')>{{trans('home.rate')}}</option>
                                            <option value="file" @selected(old('question_type',$question->question_type) == 'file')>{{trans('home.file')}}</option>
                                            <option value="link" @selected(old('question_type',$question->question_type) == 'link')>{{trans('home.link')}}</option>
                                        </select>
                                    </div>

                                    <input type="hidden" name="question_id" value="{{$question->id}}"/>

                                    <div class="form-group col-md-12">
                                        <button type="submit" class="btn btn-success">{{trans('home.save')}} </button>
                                    </div>
                                </div>                             
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        @endforeach
        
    </div>
@endsection

@section('script')
    <script>
        // $('.rangeslider1').ionRangeSlider();


        $(document).ready(function(){
            var maxField = 100; //Input fields increment limitation
            var addButton = $('.add_question'); //Add button selector
            var wrapper = $('.question_wrapper'); //Input field wrapper
            var fieldHTML ='<div class="row"><hr><div class="form-group col-md-3"> <label for="question_en">{{trans('home.question_en')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.question_en')}}" name="question_en[]"> </div>';
            fieldHTML +='<div class="form-group col-md-3"><label for="question_ar">{{trans('home.question_ar')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.question_ar')}}" name="question_ar[]"> </div>';
            fieldHTML +='<div class="form-group col-md-5"> <label for="question_type">{{trans('home.question_type')}}</label> <select class="form-control select2" name="question_type[]"> <option value="notes">{{trans('home.notes')}}</option> <option value="question">{{trans('home.question')}}</option> <option value="rate">{{trans('home.rate')}}</option> <option value="file">{{trans('home.file')}}</option> <option value="link">{{trans('home.link')}}</option> </select> </div>';
            fieldHTML +='<div class="form-group col-md-1"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

            var x = 1; //Initial field counter is 1

            //Once add button is clicked
            $(addButton).click(function(){
                //Check maximum number of input fields
                if(x < maxField){
                    x++; //Increment field counter
                    $(wrapper).append(fieldHTML); //Add field html
                }
                // $('.rangeslider1').ionRangeSlider();
            });

            //Once remove button is clicked
            $(wrapper).on('click', '.remove_button', function(e){
                e.preventDefault();
                $(this).parent().parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });
        });
  
        $(document).ready(function(){
            $('.rmv-question').click(function () {
                var question_id = $(this).data('question_id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"{{route('removeSurveyQuestion',app()->getLocale())}}",
                    method:'POST',
                    data: {question_id:question_id},
                    success:function(data) {
                        location.reload();
                    }
                });
            });
            
        });
  
    </script>
@endsection

