@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.delete_trainings_of_students')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.students')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{route('students.index')}}">{{trans('home.students')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.delete_trainings_of_students')}}</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
        <!-- End Page Header -->
            {!! Form::open(['route' => 'un_assign_student.delete', 'data-toggle'=>'validator']) !!}
               
                @csrf
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.training')}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.training')}}</label>
                                <select class="form-control select2 country @error('training') is-invalid @enderror" name="training[]" multiple required>
                                    <option value="">{{ __('home.choose_training') }}</option>
                                    @foreach($trainings as $training)
                                        <option value="{{$training->id}}">{{$training->{'name_'.$lang} }}</option>
                                    @endforeach
                                </select>
                                @error('country_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        @error('students')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                            <div class="table-responsive">
                                <table class="table" id="exportexample">
                                    <thead>
                                        <tr>
                                            <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                            <th>{{ trans('home.id') }}</th>
                                            <th >{{ trans('home.ssn') }}</th>
                                            <th >{{ trans('home.name') }}</th>
                                            <th >{{ trans('home.email') }}</th>
                                            <th >{{ trans('home.status') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($users as $student)
                                            <tr id="{{ $student->id }}">
                                                <td> <input type="checkbox" name="students[]" class="tableChecked" value="{{ $student->id }}" /> </td>
                                                <td><a  href="{{ route('students.edit', $student->id) }}">{{ $student->id }}</a>  </td>
                                                <td><a  href="{{ route('students.edit', $student->id) }}">{{ $student->student_info?$student->student_info->ssn:'' }}</a>  </td>
                                                <td><a  href="{{ route('students.edit', $student->id) }}">{{ $student->f_name.' '.$student->l_name }}</a> </td>
                                                <td><a  href="{{ route('students.edit', $student->id) }}">{{ $student->email}}</a> </td>
                                                <td><a  href="{{ route('students.edit', $student->id) }}">{{ $student->status==1? __('home.active') : __('home.inactive') }}</a> </td>
                                            </tr>
                                        @endforeach
    
                                    </tbody>
                                </table>
                            </div>
                    </div>
                </div>
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="form-group col-md-12">
                            <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                            <a href="{{route('students.index')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                        </div>
                    </div>
                </div>
                    
            {!! Form::close() !!}
        </div>
    </div>
</div>

@endsection

@section('script')
    <script>
        $('.country').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getRegions')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    region.html(html);
                }
            });
        });

        $('.region').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getAreas')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    area.html(html);
                }
            });
        });
    </script>
@endsection