@extends('layouts.admin')
@section('meta')
    <title>{{ trans('home.students') }}</title>
@endsection
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.students') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.students') }}</li>
                </ol>
            </div>

            @can('students_operations')
                <div class="btn btn-list">
                    @can('students_add_buttons')
                        <a href="{{ route('students.create') }}"><button class="btn m-2 ripple btn-primary"><i
                                    class="fas fa-plus-circle"></i> {{ trans('home.add') }}</button></a>
                    @endcan
                    @can('students_delete_buttons')
                    <a id="btn_active"><button class="btn m-2 ripple btn-dark"><i class="fas fa-eye"></i>
                            {{ trans('home.publish/unpublish') }}</button></a>
                    <a id="btn_delete"><button class="btn m-2 ripple btn-danger"><i class="fas fa-trash"></i>
                            {{ trans('home.delete') }}</button></a>
                    @endcan
                </div>
            @endcan
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
       <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden"> 
                    <div class="card-body">
                        
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.students') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>
                        <div class="d-flex justify-content-left m-3">
                            <input style="width:15px; margin-left:5px" type="checkbox" name="checkbox" class="tableChecked" value="Select All" id="checkAll"/>
                            <label style="font-size:20px; padding-top:10px" for="checkAll">{{trans('home.select_all')}}</label>
                        </div>
                      {!! $dataTable->table(['class' => 'table dataTable  table-bordered w-100']) !!}

                    </div>
                </div>
            </div>
        </div>
          <!-- End Row -->
        <div class="modal fade bd-example-modal-xl" id="importstudentsmodel" tabindex="-1" role="dialog" aria-labelledby="importstudentsmodelTitle" aria-hidden="true">
          <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content" style="border-radius: 35px;">
              <div class="modal-header row">
                    <img class="col-12 p-2"  src="{{url('resources/assets/back/img/students_1.png')}}">
                 <img  class="col-12" src="{{url('resources/assets/back/img/students_2.png')}}">
              </div>
             <form method="post" action="{{ route('student.import.excel') }}" enctype="multipart/form-data">
                    @csrf
              <div class="modal-body ">
                    <div class="m-auto">
                                <div class="row">
                                    {{-- <label>{{trans('home.Exel')}}</label> --}}
                                    <div class="input-group mb-1 d-flex justify-content-first">
                                        <div class="custom-file m-auto col-6">
                                            <div class="input-group-prepend"> 
                                                <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                            </div>
                                            <input type="file" class="custom-file-input" name="excelFile"  accept=".csv,.xlsx">
                                            <label class="custom-file-label"
                                                for="inputGroupFile01">{{ trans('home.choose_excel_file') }}</label>
                                        </div>
                                        
                                    </div>
                                        
                                    @error('excelFile')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                    </div>
              </div>
              <div class="modal-footer justify-content-center ">
                  <button class="btn ripple btn-primary " type="submit"><i
                                        class="fas fa-plus-circle"></i>
                                        {{ trans('home.importExcel') }}</button>
                <button id="closeModalButton" type="button" class="btn btn-secondary " data-bs-dismiss="modal">Close</button>
              </div>
            </form>
            </div>
          
          </div>
        </div>
            

        <!-- Row-->
        <!-- End Row -->
    </div>
@endsection

@section('script')
    <script src="{{ Helper::jsFilesPath('bootstrap.min.js')}}"></script>
    <script>
        // Select the close button
        var closeModalButton = document.getElementById("closeModalButton");
    
        // Add click event listener to the close button
        closeModalButton.addEventListener("click", function() {
            document.getElementById("importstudentsmodel").classList.remove("show");
            document.querySelector(".modal-backdrop").remove();
            document.getElementById("importstudentsmodel").setAttribute("aria-hidden", "true");
        });
    </script>
    <script>
        $('.msg_check').html('<input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/>');
    </script>
    <script>
        function viewModel2(id){
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: '{{route('viewtrainings2.show')}}',
                    method: 'POST',
                    data: {
                        std_id: id,
                    },
                    success: function (response) {
                        $('#view_trainingModal').empty();
                        $('.main-content').append(response.view);
                        $('#view_trainingModal_'+id).modal('show');
                    }
                });
        }
    </script>
    
    {!! $dataTable->scripts() !!}

@endsection
