@extends('layouts.admin')
<title>{{ trans('home.student_requests') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.student_requests') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.student_requests') }}</li>
                </ol>
            </div>
            @can('students_requests_operations')
                <div class="btn btn-list">
                    @can('students_requests_accept_button')
                        <a class="mr-2" href="javascript:void(0)" id="accept_request" ><button class="btn ripple btn-primary"><i
                                    class="fas fa-plus-circle"></i> {{ trans('home.accept_request') }}</button></a>
                    @endcan
                    @can('students_requests_delete_button')
                        <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                                {{ trans('home.delete') }}</button></a>
                    @endcan
                </div>
            @endcan
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.students') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>
                        <div class="form-group col-md-6">
                            <label class="">{{trans('home.trainings')}}</label>
                            <div class="row">
                                    <div class="col-8">    
                                        <select id="training_id" class="form-control select2  " name="training_id" required>
                                    <option value="">{{ __('home.choose_training') }}</option>
                                    @foreach($trainings as $training)
                                        <option value="{{$training->id}}">
                                            {{ $training->code . ' - ' . $training->{'name_'.$lang} }}
                                        </option>
                                    @endforeach
                                </select>
                                    </div>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                        <th>{{ trans('home.id') }}</th>
                                        <th >{{ trans('home.ssn') }}</th>
                                        <th >{{ trans('home.name') }}</th>
                                        <th >{{ trans('home.email') }}</th>
                                        <th >{{ trans('home.phone') }}</th>
                                        <th >{{ trans('home.course') }}</th>
                                        <th >{{ trans('home.date') }}</th>
                                        <th >{{ trans('home.seen') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($student_requests as $student_request)
                                        <tr id="{{ $student_request->id }}">
                                            <td> <input type="checkbox" name="checkbox" class="tableChecked" value="{{ $student_request->id }}" /> </td>
                                            <td> <a href="javascript:void(0);" class="show_request" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-request_id="{{$student_request->id}}">
                                                {{ $student_request->id }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_request" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-request_id="{{$student_request->id}}">
                                                {{ $student_request->student_info? $student_request->student_info->ssn:'' }}</a>  </td>
                                            <td><a  href="javascript:void(0);" class="show_request" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-request_id="{{$student_request->id}}">
                                                {{ $student_request->user->name() }}</a> </td>
                                            <td><a  href="javascript:void(0);" class="show_request" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-request_id="{{$student_request->id}}">
                                                {{ $student_request->user->email}}</a> </td>
                                            <td><a  href="javascript:void(0);" class="show_request" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-request_id="{{$student_request->id}}">
                                                {{ $student_request->student_info? $student_request->student_info->mobile:''}}</a> </td>
                                            <td><a href="javascript:void(0);" class="show_request" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-request_id="{{$student_request->id}}">
                                                {{ $student_request->course->{'name_'.$lang} }}</a> </td>
                                            <td><a href="javascript:void(0);" class="show_request" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-request_id="{{$student_request->id}}">
                                                {{\Carbon\Carbon::parse($student_request->created_at)->format("d / m / Y")  }}</a> </td>
                                            <td><h5> <a  href="javascript:void(0);" class="show_request " id="status_{{$student_request->id}}" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-request_id="{{$student_request->id}}">
                                                @if($student_request->seen==1)
                                                    <span class="badge badge-info">{{__('home.seen')}}</span>
                                                @else
                                                    <span class="badge badge-danger">{{__('home.not_seen')}}</span>
                                                @endif
                                                </a>
                                                </h5>
                                            </td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function(){
            $('#accept_request').click(function(){
                var training_id = $('#training_id').val();
                var id = [];
                $('.tableChecked:checked').each(function(i){
                    id[i] = $(this).val();
                });
                if(id.length === 0) //tell you if the array is empty
                {
                    alert("Please Select atleast one checkbox");
                }
                if(id.length !=0 && training_id == 0) //tell you if the array is empty
                {
                    alert("Please Select training");
                }
                else
                {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url:"<?php echo route('student_requests.accept') ?>",
                        type:'POST',
                        data:{id:id,training_id:training_id},
                        success:function(data)
                        {
                            for(var i=0; i<id.length; i++)
                            {
                                $('tr#'+id[i]+'').css('background-color', '#ccc');
                                $('tr#'+id[i]+'').fadeOut('slow');
                                $('input:checkbox').removeAttr('checked');
                            }
                        }
                    });
                }
            });
        });
    </script>
    <script>
        $(document).ready(function(){
            $('.show_request').click(function () {
            var request_id = $(this).data('request_id');
            var modalId = '#student_request_modal_' + request_id;
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            var path = "student_requests//edit"
            var fieldHTML ='<span class="badge badge-info">{{__('home.seen')}}</span>';
                
            $.ajax({
                url: "student_requests/"+request_id+"/edit",
                method: 'Get',
                data: {request_id: request_id},
                success: function (data) {
                    $('#status_'+request_id).html(fieldHTML);
                    $('body').append(data.view);
                    $(modalId).modal('show');
                    
                },
            });
        });
        });
    </script>
@endsection