<div id="" class="row DivIdToPrint">
	<div class="col-lg-12">
		<div class="card custom-card">
			<div class="card-body">
				<div>
					<h6 class="card-title mb-1">{{trans('home.report_statistics')}}</h6>
					<br>
					<p class="text-muted card-sub-title">{{trans('home.date_from')}} &nbsp; {{$dateFrom}} &nbsp;   {{trans('home.date_to')}} &nbsp;  {{$dateTo}}</p>
				</div>
				
				<div class="row d-flex justify-content-between">
				   @if($courseId == 'all')
    					<div class="col-sm-6 col-md-6 col-xl-2">
    					    <a href="#exportexample_wrapper" class="filter_type" data-filter="courses">
        						<div class="card custom-card">
        							<div class="card-body text-center">
        								<div class="icon-service bg-success-transparent rounded-circle text-success">
        								    <i class="far fa-file-video"></i>
        								</div>
        								<p class="mb-1 text-muted">{{trans('home.courses')}}</p>
        								<h3 class="mb-0">{{$courses}}</h3>
        							</div>
        						</div>
    						</a>
    					</div>
					@endif
					<div class="col-sm-6 col-md-6 col-xl-2">
					    <a href="#exportexample_wrapper" class="filter_type" data-filter="centers">
    						<div class="card custom-card">
    							<div class="card-body text-center">
    								<div class="icon-service bg-success-transparent rounded-circle text-success">
    								    <i class="fas fa-university"></i>
    								</div>
    								<p class="mb-1 text-muted">{{trans('home.centers')}}</p>
    								<h3 class="mb-0">{{$centers}}</h3>
    							</div>
    						</div>
						</a>
					</div>
					<div class="col-sm-6 col-md-6 col-xl-2">
						<a href="#exportexample_wrapper" class="filter_type" data-filter="instructors">
						    <div class="card custom-card">
        						<div class="card-body text-center">
        							<div class="icon-service bg-primary-transparent rounded-circle text-primary">
        							    <i class="fas fa-user-tie"></i>
        							</div>
        							<p class="mb-1 text-muted">{{trans('home.instructors')}}</p>
        							<h3 class="mb-0">{{$instructors}}</h3>
        						</div>
        					</div> 
						</a>
					</div>
					<div class="col-sm-6 col-md-6 col-xl-2">
					    <a href="#exportexample_wrapper" class="filter_type" data-filter="trainings">
    						<div class="card custom-card">
    							<div class="card-body text-center">
    								<div class="icon-service bg-info-transparent rounded-circle text-info">
    									<i class="fas fa-chalkboard-teacher fa-sm"></i>
    								</div>
    								<p class="mb-1 text-muted">{{trans('home.trainings')}}</p>
    								<h3 class="mb-0">{{$trainings}}</h3>
    							</div>
    						</div>
    					</a>
					</div>
					<div class="col-sm-6 col-md-6 col-xl-2">
					    <a href="#exportexample_wrapper" class="filter_type" data-filter="students">
    						<div class="card custom-card">
    							<div class="card-body text-center">
    								<div class="icon-service bg-danger-transparent rounded-circle text-danger">
    									<i class="fab fa-slideshare"></i>
    								</div>
    								<p class="mb-1 text-muted">{{trans('home.students')}}</p>
    								<h3 class="mb-0">{{$students}}</h3>
    							</div>
    						</div>
    					</a>
					</div>
				</div>
				
			</div>
		</div>
	</div>
</div>


<script>
    $('.filter_type').on('click',function(){
        var courseId = $('#course option:selected').val();
        var filter = $(this).data('filter');

        var dateFrom = $('.date_from').val();
        var dateTo = $('.date_to').val();
        if(courseId){
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
        
                $.ajax({
                    url:" {{url('admin/course-report-result')}}",
                    method:'POST',
                    data:{courseId:courseId,filter:filter,dateFrom:dateFrom,dateTo:dateTo},
                    success:function(html)
                    {
                        $('.searchResult').html(html.html);
                        $('#datatable').DataTable();
                    }
                });
        }else{
            alert("{{trans('home.Please Select Center')}}");
        }
     
    });
</script>