<!---DataTables css-->
    <link href="{{URL::To('resources/assets/back/plugins/datatable/dataTables.bootstrap4.min.css')}}" rel="stylesheet" />
    <link href="{{URL::To('resources/assets/back/plugins/datatable/responsivebootstrap4.min.css')}}" rel="stylesheet" />
    <link href="{{URL::To('resources/assets/back/plugins/datatable/fileexport/buttons.bootstrap4.min.css')}}" rel="stylesheet" />


<div id="" class="row DivIdToPrint">
	<div class="col-lg-12">
		<div class="card custom-card">
			<div class="card-body">
				<div>
					<h6 class="card-title mb-1">{{trans('home.report_results')}}</h6>
					<br>
					<p class="text-muted card-sub-title">{{trans('home.date_from')}} &nbsp; {{$dateFrom}} &nbsp;   {{trans('home.date_to')}} &nbsp;  {{$dateTo}}</p>
				</div>
				<div class="table-responsive">
				    
				     @if($centers != null)
    					@if(count($centers)>0)
    						<table class="table table-hover mg-b-0" id="exportexample">
    							<thead>
    								<tr>
    									<th>#</th>
    									<th>{{trans('home.name')}}</th>
    									<th>{{trans('home.n_instructors')}}</th>
    									<th>{{trans('home.n_students')}}</th>
    									<th>{{trans('home.n_trainings')}}</th>
    									<th>{{trans('home.n_courses')}}</th>
    									<th>{{trans('home.partner_start_date')}}</th>
    									<th>{{trans('home.region')}}</th>
    								</tr>
    							</thead>
    							<tbody>
    								@foreach ($centers as $key=>$center)
    									<tr>
    										<td>{{$center->id}}</td>
    										<td>{{$center->{'name_'.$lang} }}</td>
    										<td>{{$center->instructors_count() }}</td>
    										<td>{{$center->students_count() }}</td>
    										<td>{{$center->trainings_count() }}</td>
    										<td>{{$center->courses_count() }}</td>
    										<td>{{$center->partner_start_date }}</td>
    										<td>{{$center->region->{'name_'.$lang} }}</td>
    									</tr>
    								@endforeach
    							</tbody>
    						</table>
    					@else
                            <div class="text-center">
                                <h3>{{trans('home.no_data_found')}}</h3>
                            </div>
                        @endif
                    @endif
				    
				    @if($halls != null)
    					@if(count($halls)>0)
    						<table class="table table-hover mg-b-0" id="exportexample">
    							<thead>
    								<tr>
    									<th>#</th>
    									<th>{{trans('home.name')}}</th>
    									<th>{{trans('home.region')}}</th>
    									<th>{{trans('home.building_name')}}</th>
    									<th>{{trans('home.floor')}}</th>
    									<th>{{trans('home.address')}}</th>
    									<th>{{trans('home.capacity')}}</th>
    								</tr>
    							</thead>
    							<tbody>
    								@foreach ($halls as $key=>$hall)
    									<tr>
    										<td>{{$key+1}}</td>
    										<td>{{$hall->{'name_'.$lang} }}</td>
    										<td>{{$hall->region->{'name_'.$lang} }}</td>
    										<td>{{$hall->building_name}}</td>
    										<td>{{$hall->floor}}</td>
    										<td>{{$hall->{'address_'.$lang} }}</td>
    										<td>{{$hall->capacity}}</td>
    									</tr>
    								@endforeach
    							</tbody>
    						</table>
    					@else
                            <div class="text-center">
                                <h3>{{trans('home.no_data_found')}}</h3>
                            </div>
                        @endif
                    @endif
				    
				    
				    @if($center_regions != null)
    					@if(count($center_regions)>0)
    						<table class="table table-hover mg-b-0" id="exportexample">
    							<thead>
    								<tr>
    									<th>#</th>
    									<th>{{trans('home.name')}}</th>
    									<th>{{trans('home.region')}}</th>
    									<th>{{trans('home.status')}}</th>
    								</tr>
    							</thead>
    							<tbody>
    								@foreach ($center_regions as $key=>$center_region)
    									<tr>
    										<td>{{$key+1}}</td>
    										<td>{{$center_region->{'name_'.$lang} ?? '' }}</td>
    										<td>{{$center_region->area->{'name_'.$lang} ?? '' }}</td>
    										<td>{{$center_region->status}}</td>
    									</tr>
    								@endforeach
    							</tbody>
    						</table>
    					@else
                            <div class="text-center">
                                <h3>{{trans('home.no_data_found')}}</h3>
                            </div>
                        @endif
                    @endif
				    
				    
				    @if($instructors != null)
    					@if(count($instructors)>0)
    						<table class="table table-hover mg-b-0" id="exportexample">
    							<thead>
    								<tr>
    									<th>#</th>
    									<th>{{trans('home.ssn')}}</th>
    									<th>{{trans('home.name')}}</th>
    									<th>{{trans('home.job_title')}}</th>
    									<th>{{trans('home.phone')}}</th>
    								</tr>
    							</thead>
    							<tbody>
    								@foreach ($instructors as $key=>$instructor)
    									<tr>
    										<td>{{$key+1}}</td>
    										<td>{{$instructor->instructor_info->ssn}}</td>
    										<td>{{$instructor->name()}}</td>
    										<td>{{$instructor->instructor_info->job_title}}</td>
    										<td>{{$instructor->instructor_info->mobile}}</td>
    									</tr>
    								@endforeach
    							</tbody>
    						</table>
    					@else
                            <div class="text-center">
                                <h3>{{trans('home.no_data_found')}}</h3>
                            </div>
                        @endif
                    @endif
                    
                    
				    @if($trainings != null)
    					@if(count($trainings)>0)
    						<table class="table table-hover mg-b-0" id="exportexample">
    							<thead>
    								<tr>
    									<th>#</th>
    									<th>{{trans('home.code')}}</th>
    									<th>{{trans('home.name')}}</th>
    									<th>{{trans('home.instructor')}}</th>
    									<th>{{trans('home.region')}}</th>
    									<th>{{trans('home.hall')}}</th>
    									<th>{{trans('home.date_from')}}</th>
    									<th>{{trans('home.date_to')}}</th>
    									<th>{{trans('home.time_from')}}</th>
    									<th>{{trans('home.time_to')}}</th>
    									<th>{{trans('home.n_students')}}</th>
    									<th>{{trans('home.training_status')}}</th>
    								</tr>
    							</thead>
    							<tbody>
    								@foreach ($trainings as $key=>$training)
    									<tr>
    										<td>{{$key+1}}</td>
    										<td>{{$training->code}}</td>
    										<td>{{$training->{'name_'.$lang} ?? '' }}</td>
    										@php
    										    $ins = App\Models\TrainingCourse::where('training_id',$training->id)->first();
    										    if($ins) {
                                                     $user = App\Models\User::find($ins->instructor_id);
                                                     if($user){
                                                        $ins_name = $user->name();
                                                     } else {
                                                         $ins_name = '...';
                                                     }
                                                 } else {
                                                     $ins_name = '...';
                                                 }
    										@endphp
    										<td>{{$ins_name}}</td>
    										<td>{{$training->region->{"name_$lang"} ?? '' }}</td>
    										<td>{{$training->trainings_schaduals->hall->{'name_'.$lang} ?? ''}}</td>
    										<td>{{isset($training->trainings_schaduals->start_date) ? \Carbon\Carbon::parse($training->trainings_schaduals->start_date)->format("Y-m-d") : ''}}</td>
    										<td>{{isset($training->trainings_schaduals->end_date) ? \Carbon\Carbon::parse($training->trainings_schaduals->end_date)->format("Y-m-d") : '' }}</td>
    										<td>{{$training->time_from}}</td>
    										<td>{{$training->time_to}}</td>
    										<td>{{count($training->students)}}</td>
        										@php
        										    if($training->training_status == '-1') {
                                                        $status = '<h4 class="d-flex justify-content-center mt-4 badge badge-pill badge-danger">'. trans('home.no_date_found') .'</h4>';
                                                     } else if($training->training_status == '0') {
                                                         $status = '<h2 class="d-flex justify-content-center mt-4 badge badge-pill badge-primary">'. trans('home.not_started') .'</h2>';
                                                     }
                                                     else if($training->training_status == '1') {
                                                         $status = '<h4 class="d-flex justify-content-center mt-4 badge badge-pill badge-success">'. trans('home.started') .'</h4>';
                                                     }
                                                     else if($training->training_status == '2') {
                                                         $status = '<h4 class="d-flex justify-content-center mt-4 badge badge-pill badge-warning">'. trans('home.finished') .'</h4>';
                                                     }
        										@endphp
    										<td>{!! $status !!}</td>
    									</tr>
    								@endforeach
    							</tbody>
    						</table>
    					@else
                            <div class="text-center">
                                <h3>{{trans('home.no_data_found')}}</h3>
                            </div>
                        @endif	
                    @endif
                    
                    
				    @if($courses != null)
    					@if(count($courses)>0)
    						<table class="table table-hover mg-b-0" id="exportexample">
    							<thead>
    								<tr>
    									<th>#</th>
    									<th>{{trans('home.code')}}</th>
    									<th>{{trans('home.name')}}</th>
    									<th>{{trans('home.status')}}</th>
    								</tr>
    							</thead>
    							<tbody>
    								@foreach ($courses as $key=>$course)
    									<tr>
    										<td>{{$key+1}}</td>
    										<td>{{$course->code}}</td>
    										<td>{{$course->{"name_$lang"} }}</td>
    										<td>{{$course->status}}</td>
    									</tr>
    								@endforeach
    							</tbody>
    						</table>
    					@else
                            <div class="text-center">
                                <h3>{{trans('home.no_data_found')}}</h3>
                            </div>
                        @endif	
                    @endif
                    
				    @if($students != null)
    					@if(count($students)>0)
    						<table class="table table-hover mg-b-0" id="exportexample">
    							<thead>
    								<tr>
    									<th>#</th>
    									<th>{{trans('home.ssn')}}</th>
    									<th>{{trans('home.name')}}</th>
    									<th>{{trans('home.phone')}}</th>
    									<th>{{trans('home.course')}}</th>
    									<th>{{trans('home.region')}}</th>
    								</tr>
    							</thead>
    							<tbody>
    								@foreach ($students as $key=>$student)
    									<tr>
    										<td>{{$key+1}}</td>
    										<td>{{$student->student_info->ssn ?? ''}}</td>
    										<td>{{$student->name()}}</td>
    										<td>{{$student->student_info->mobile ?? ''}}</td>
    										@php
    										    $t = App\Models\Student::where('user_id',$student->id)->first();
                                                if($t){
                                                    $t = App\Models\Training::find($t->training_id);
                                                    $training_row = $t->{'name_'.$lang};
                                                } else {
                                                    $training_row =  '...';
                                                }
    										@endphp
    										<td>{{$training_row}}</td>
    
    
    										<td>{{$student->student_info->address->region->{"name_$lang"} ?? '' }}</td>
    									</tr>
    								@endforeach
    							</tbody>
    						</table>
    					@else
                            <div class="text-center">
                                <h3>{{trans('home.no_data_found')}}</h3>
                            </div>
                        @endif	
                    @endif
                    
                    @if($students_regions != null)
    					@if(count($students_regions)>0)
    						<table class="table table-hover mg-b-0" id="exportexample">
    							<thead>
    								<tr>
    									<th>#</th>
    									<th>{{trans('home.name')}}</th>
    									<th>{{trans('home.region')}}</th>
    									<th>{{trans('home.status')}}</th>
    								</tr>
    							</thead>
    							<tbody>
    								@foreach ($students_regions as $key=>$student_region)
    									<tr>
    										<td>{{$key+1}}</td>
    										<td>{{$student_region->{'name_'.$lang} ?? '' }}</td>
    										<td>{{$student_region->area->{'name_'.$lang} ?? '' }}</td>
    										<td>{{$student_region->status}}</td>
    									</tr>
    								@endforeach
    							</tbody>
    						</table>
    					@else
                            <div class="text-center">
                                <h3>{{trans('home.no_data_found')}}</h3>
                            </div>
                        @endif
                    @endif
				</div>
			</div>
		</div>
	</div>
</div>


    <!-- Data Table js -->
    <script src="{{ URL::To('resources/assets/back/plugins/datatable/jquery.dataTables.min.js')}}"></script>
    <script src="{{ URL::To('resources/assets/back/plugins/datatable/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{ URL::To('resources/assets/back/js/table-data.js')}}"></script>
    <script src="{{ URL::To('resources/assets/back/plugins/datatable/dataTables.responsive.min.js')}}"></script>
    <script src="{{ URL::To('resources/assets/back/plugins/datatable/fileexport/dataTables.buttons.min.js')}}"></script>
    <script src="{{ URL::To('resources/assets/back/plugins/datatable/fileexport/buttons.bootstrap4.min.js')}}"></script>
    <script src="{{ URL::To('resources/assets/back/plugins/datatable/fileexport/jszip.min.js')}}"></script>
    <script src="{{ URL::To('resources/assets/back/plugins/datatable/fileexport/pdfmake.min.js')}}"></script>
    <script src="{{ URL::To('resources/assets/back/plugins/datatable/fileexport/vfs_fonts.js')}}"></script>
    <script src="{{ URL::To('resources/assets/back/plugins/datatable/fileexport/buttons.html5.min.js')}}"></script>
    <script src="{{ URL::To('resources/assets/back/plugins/datatable/fileexport/buttons.print.min.js')}}"></script>
    <script src="{{ URL::To('resources/assets/back/plugins/datatable/fileexport/buttons.colVis.min.js')}}"></script>
    <script src="{{ URL::to('resources/assets/back/js/new-tinymce/tinymce.min.js') }}"></script>
    
    <script>
        if(lang == "ar"){
            var table = $('#exportexample').DataTable( {
        		lengthChange: false,
        		searching: true,         // Enable searching/filtering
                ordering: true,
        		dom: 'Bfrtip',
        		"bPaginate" : true,
        		buttons: [ 'copy', 'excel', 'colvis','pageLength' ],
        		language: {
                    url: '//cdn.datatables.net/plug-ins/1.13.3/i18n/ar.json',
                },
        	} );
        }else{
            var table = $('#exportexample').DataTable( {
        		lengthChange: false,
        		searching: true,         // Enable searching/filtering
                ordering: true,
        		dom: 'Bfrtip',
        		buttons: [ 'copy', 'excel', 'colvis','pageLength' ],
        	} );
        }
    </script>
