@extends('layouts.admin')
<title>{{ __('home.my_training_request') }} </title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.my_training_request') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.my_training_request') }}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        @if(Session::has('accepted_request'))
                            <div class="alert alert-success">
                                {{ session()->pull('accepted_request') }}
                                {{ session()->pull('accepted_code') }}
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        @endif
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.my_training_request') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>
                        <div class="table-responsive">
                            <table class="table" @if(auth()->user()->type != 'partner') id="exportexample" @endif>
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                        <th>{{ trans('home.id') }}</th>
                                        <th>{{ trans('home.created_at') }}</th>
                                        @if(auth()->user()->type != 'partner')<th class="wd-20p">{{ trans('home.center') }}</th> @endif
                                        <th >{{ trans('home.training') }}</th>
                                        <th >{{ trans('home.field') }}</th>
                                        <th >{{ trans('home.instructor') }}</th>
                                        <th >{{ trans('home.hall') }}</th>
                                        <th >{{ trans('home.region') }}</th>
                                        <th >{{ trans('home.area') }}</th>
                                        <th >{{ trans('home.map_url') }}</th>
                                        <th >{{ trans('home.time_from') }}</th>
                                        <th >{{ trans('home.time_to') }}</th>
                                        <th >{{ trans('home.start_date') }}</th>
                                        <th >{{ trans('home.end_date') }}</th>
                                        <th >{{ trans('home.request_type') }}</th>
                                        <th >{{ trans('home.request_status') }}</th>
                                        <th >{{ trans('home.exception_file') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($partner_requests as $partner_request)
                                        <tr id="{{ $partner_request->id }}">
                                            <td> <input type="checkbox" name="checkbox" class="tableChecked" value="{{ $partner_request->id }}" /> </td>
                                            <td><a href="javascript::void(0)" class="show_detials" data-toggle="modal" data-my_request_id="{{$partner_request->id}}">{{ $partner_request->id}}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-my_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->created_at }}</a>  </td>
                                            @if(auth()->user()->type != 'partner')
                                                <td><a href="javascript::void(0)" class="show_detials" data-toggle="modal" data-my_request_id="{{$partner_request->id}}">{{ $partner_request->center->{'name_'.$lang} }}</a>  </td>
                                            @endif
                                            <td><a href="javascript::void(0)" class="show_detials" data-toggle="modal" data-my_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->{'name_'.$lang} ?? '...' }}</a>  </td>
                                            <td><a href="javascript::void(0)" class="show_detials" data-toggle="modal" data-my_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->field->{'name_'.$lang} ?? '...' }}</a>  </td>
                                            <td><a href="javascript::void(0)" class="show_detials" data-toggle="modal" data-my_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->instructor->f_name ?? '....' }}</a>  </td>
                                            <td><a href="javascript::void(0)" class="show_detials" data-toggle="modal" data-my_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->hall->{'name_'.$lang} ?? '....' }}</a>  </td>
                                            <td><a href="javascript::void(0)" class="show_detials" data-toggle="modal" data-my_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->hall->region->{'name_'.$lang} ?? '....' }}</a>  </td>
                                            <td><a href="javascript::void(0)" class="show_detials" data-toggle="modal" data-my_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->hall->area->{'name_'.$lang} ?? '....' }}</a>  </td>
                                            <td><a href="javascript::void(0)" class="show_detials" data-toggle="modal" data-my_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->hall->map_url ?? '....' }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal"  data-my_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->time_from }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-my_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->time_to }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-my_request_id="{{$partner_request->id}}">
                                                {{ \Carbon\Carbon::parse($partner_request->start_date)->format("Y-m-d") }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-my_request_id="{{$partner_request->id}}">
                                                {{ \Carbon\Carbon::parse($partner_request->end_date)->format("Y-m-d") }}</a>  </td>
                                            <td>
                                                @if($partner_request->request_type== 'new')
                                                    <span class="badge badge-danger">{{__('home.new_request')}} <i class="fas fa-plus"></i></span>
                                                @elseif($partner_request->request_type== 'edit')
                                                    <span class="badge badge-info">{{__('home.edit_request')}} <i class="fas fa-edit"></i></span>
                                                @elseif($partner_request->request_type== 'exception')
                                                    <span class="badge badge-warning">{{__('home.exception_request')}} <i class="fas fa-edit"></i></span>
                                               @endif
                                             </td>
                                            <td>
                                                {{--<a  href="javascript::void(0)"  data-toggle="modal" data-my_request_id="{{$partner_request->id}}">--}}
                                                    @if($partner_request->status== 'delivered')
                                                        <span class="badge badge-info">{{__('home.request_delivered')}} <i class="fas fa-check"></i></span>
                                                    @elseif($partner_request->status== 'processing')
                                                        <span class="badge badge-dark">{{__('home.processing')}} <i class="fas fa-spinner" style="color: #fafafa;"></i></span>
                                                    @elseif($partner_request->status== 'accepted')
                                                        <span class="badge badge-success">{{__('home.request_accepted')}} <i class="fas fa-check-double"></i></span><br><span class="mt-1 badge badge-danger">{{ trans('home.code') . ': ' }} <span class="d-inline-block">{{$partner_request->training_code}}</span></span>
                                                    @elseif($partner_request->status== 'edited')
                                                        <span class="badge badge-primary">{{__('home.request_edited')}} <i class="fas fa-edit"></i></span><br><span class="mt-1 badge badge-danger">{{ trans('home.code') . ': ' }} <span class="d-inline-block">{{$partner_request->training_code}}</span></span>
                                                    @endif
                                                {{--</a> --}}
                                            </td>
                                            <td>
                                                @if($partner_request->exception_file)
                                                    <a href="{{url('uploads/partner_trainin_request/files/'.$partner_request->exception_file)}}" download="{{url('uploads/partner_trainin_request/files/'.$partner_request->exception_file)}}">
                                                          <i class="fas fa-download"></i>
                                                          {{$partner_request->exception_file}}
                                                    </a>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
					    </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')

    <script>
        $(document).on('click', '.show_detials', function() {
            var my_request_id = $(this).data('my_request_id');
            var modalId = '#my_request_modal_' + my_request_id;
            // var fieldHTML ='<span class="badge badge-info">{{__('home.seen')}}</span>';
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                 url:"{{ route('my_training_request_details') }}",
                method: 'Post',
                data: {
                    my_request_id:my_request_id},
                success: function (data) {
                    $('body').append(data.view);
                    // $('#status_'+my_request_id).html(fieldHTML);
                    $(modalId).modal('show');
                },
            });
        });
    </script>
    
@endsection