@extends('layouts.admin')
<title>{{ trans('home.partners') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.partners') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.partners') }}</li>
                </ol>
            </div>

            <div class="btn btn-list">
                <a href="{{ route('assign_partner_to_center') }}"><button class="btn ripple btn-info"><i
                         <i class="fas fa-times-circle"></i> {{ trans('home.assign_partner_to_center') }}</button></a>
                <a class="mr-2" href="{{ route('partners.create') }}"><button class="btn ripple btn-primary"><i
                            class="fas fa-plus-circle"></i> {{ trans('home.add_partner') }}</button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                        {{ trans('home.publish/unpublish') }}</button></a>
                <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                        {{ trans('home.delete') }}</button></a>
            </div>
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.partners') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                        <th>{{ trans('home.id') }}</th>
                                        <th class="wd-20p">{{ trans('home.name') }}</th>
                                        <th class="wd-25p">{{ trans('home.n_centers') }}</th>
                                        <th class="wd-25p">{{ trans('home.status') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($partners as $user)
                                        <tr id="{{ $user->id }}">
                                            <td> <input type="checkbox" name="checkbox" class="tableChecked" value="{{ $user->id }}" /> </td>
                                            <td><a href="{{ route('partners.edit', $user->id) }}">{{ $user->id }}</a>  </td>
                                            <td><a href="{{ route('partners.edit', $user->id) }}">{{ $user->name() }}</a>  </td>
                                            <td><a href="{{ route('partners.edit', $user->id) }}">{{ count($user->partner) }}</a>  </td>
                                            <td><a  href="{{ route('partners.edit', $user->id) }}">{{ $user->status==1? __('home.active') : __('home.inactive') }}</a> </td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
