@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_partner')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.partners')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{route('partners.index')}}">{{trans('home.partners')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_partner')}}</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
        <!-- End Page Header -->
            {!! Form::open(['route' => 'partners.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
               
                @csrf
                <!--account_data-->
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.account_data')}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.f_name')}}</label>
                                <input class="form-control @error('f_name') is-invalid @enderror" name="f_name" type="text" placeholder="{{trans('home.f_name')}}" required value="{{ old('f_name') }}" >
                                @error('f_name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
    
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.email')}}</label>
                                <input    class="form-control @error('email') is-invalid @enderror" name="email" type="email" placeholder="{{ trans('home.email') }}" value="{{ old('email') }}"  >
                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.password')}}</label>
                                <input class="form-control area1 @error('password') is-invalid @enderror" name="password" type="password" placeholder="{{trans('home.password')}}"value="{{ old('password') }}">
                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="col-md-3">
                                <label>{{trans('home.image')}}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input  @error('image') is-invalid @enderror" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                    </div>
                                </div>
                                @error('image')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.mobile')}}</label>
                                <input class="form-control area1 @error('mobile') is-invalid @enderror" name="mobile" type="tel" placeholder="{{trans('home.mobile')}}"value="{{ old('mobile') }}">
                                @error('mobile')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.publish')}}</label>
                                <select class="form-control select2 " name="status" id="">
                                    <option value="1" selected>{{ __('home.active') }}</option>
                                    <option value="0">{{ __('home.inactive') }}</option>
                                </select>
                            </div>
                    </div>
                    </div>
                </div>
               
                 <!--training-->
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.training')}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                           <div class="form-group col-md-12">
                                <label class="">{{trans('home.center')}}</label>
                                <select class="form-control select2  @error('center_id') is-invalid @enderror" name="center_id" id="">
                                    <option value="">{{ __('home.choose_country') }}</option>
                                    @foreach($centers as $center)
                                        <option value="{{$center->id}}">{{$center->{'name_'.$lang} }}</option>
                                    @endforeach
                                </select>
                                @error('center_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="form-group col-md-12">
                            <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                            <a href="{{route('students.index')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                        </div>
                    </div>
                </div>
                    
            {!! Form::close() !!}
        </div>
    </div>
</div>

@endsection
