@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_news_item')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.newsItems')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/news-items')}}">{{trans('home.newsItems')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_news_item')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    {!! Form::open(['route' => 'news-items.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title ">{{trans('home.add_news_item')}}</h6>
                            <hr>
                        </div>
                        <div class="row">

                            <div class="form-group col-md-3">
                                <label for="name_en">{{trans('home.name_en')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.name_en')}}" name="name_en" required>
                            </div>

                            <div class="form-group col-md-3">
                                <label for="name_ar">{{trans('home.name_ar')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.name_ar')}}" name="name_ar">
                            </div>
                            
                            <div class="form-group col-md-4">
                                <label for="call_back_url">{{trans('home.call_back_url')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.call_back_url')}}" name="call_back_url">
                            </div>

                            <div class="form-group col-md-2">
                                <label for="parent">{{trans('home.newsCategory')}}</label>
                                <select class="form-control select2" name="newscategory_id">
                                    @foreach($newsCategories as $newsCategory)
                                        <option value="{{$newsCategory->id}}">{{(app()->getLocale()=='en')? $newsCategory->title_en:$newsCategory->title_ar}}</option>
                                    @endforeach    
                                </select>
                            </div>
                            
                            {{--<div class="form-group col-md-2">
                                <label for="parent">{{trans('home.NewsCourseCategory')}}</label>
                                <select class="form-control select2" name="course_category_id">
                                    @foreach($newsCourseCategories as $newsCourseCategory)
                                        <option value="{{$newsCourseCategory->id}}">{{(app()->getLocale()=='en')? $newsCourseCategory->name_en:$newsCourseCategory->name_ar}}</option>
                                    @endforeach    
                                </select>
                            </div>--}}
                            
                            <div class="form-group col-md-3"> 
                                <label for="type">{{trans('home.writers')}}</label>
                                <select class="form-control select2 type" name="writer_id">
                                    @foreach ($writers as $writer)
                                        <option value ="{{$writer->id}}">{{$writer->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-3">
                                <label>{{trans('home.image')}}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="alt_img">{{trans('home.alt_img')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.alt_img')}}" name="alt_img">
                            </div>

                            <div class="form-group col-md-2">
                                <label for="code">{{trans('home.date')}}</label>
                                <div class="input-group">
                                    <input type='text' class="form-control" name="date" placeholder="{{trans('home.date')}}" id="datepicker"  required readonly/>
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-6 ">
                                <label for="text_en">{{trans('home.text_en')}}</label>
                                <textarea class="form-control area1" name="text_en" placeholder="{{trans('home.text_en')}}" ></textarea>
                            </div>

                            <div class="form-group col-md-6 "> 
                                <label for="text_ar">{{trans('home.text_ar')}}</label>
                                <textarea class="form-control area1" name="text_ar" placeholder="{{trans('home.text_ar')}}" ></textarea>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <p class="mt-4 mb-2">{{trans('home.status')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input"/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish')}}</span>
                                </label>
                            </div>

                            <div class="form-group col-md-4">
                                <p class="mt-4 mb-2">{{trans('home.home')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="home" value="1" class="custom-switch-input"/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish_in_home')}}</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title ">{{trans('home.seo_block')}}</h6>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="redirect_url">{{trans('home.redirect_url')}}</label>
                            <input type="text" class="form-control" value="{{ old('redirect_url') }}" placeholder="{{trans('home.redirect_url')}}" name="redirect_url">
                        </div>
                        <div class="row">
                            <div class="form-group col-md-12">
                                <hr>
                                <span class="badge badge-success">{{trans('home.en')}}</span>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="link_en">{{trans('home.slug')}}</label>
                                <input type="text" class="form-control" placeholder="{{trans('home.slug')}}" name="link_en">
                            </div>
                            
                            <div class="form-group col-md-5">
                                <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                <textarea class="form-control" name="meta_title_en" placeholder="{{trans('home.meta_title')}}"></textarea>
                            </div>
                            
                            <div class="form-group col-md-5">
                                <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                <textarea class="form-control" name="meta_desc_en" placeholder="{{trans('home.meta_desc')}}"></textarea>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <hr>
                                <span class="badge badge-success">{{trans('home.ar')}}</span>
                            </div>

                            <div class="form-group col-md-2">
                                <label for="link_ar">{{trans('home.slug')}}</label>
                                <input type="text" class="form-control" placeholder="{{trans('home.slug')}}" name="link_ar">
                            </div>
                            
                            <div class="form-group col-md-5">
                                <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                <textarea class="form-control" name="meta_title_ar" placeholder="{{trans('home.meta_title')}}"></textarea>
                            </div>
                            
                            <div class="form-group col-md-5">
                                <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                <textarea class="form-control" name="meta_desc_ar" placeholder="{{trans('home.meta_desc')}}"></textarea>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <p class="mt-4 mb-2">{{trans('home.meta_robots')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="meta_robots" value="1" class="custom-switch-input">
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_index')}}</span>
                                </label>
                            </div>
                        </div>                            
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="image-note"></i> {{trans('home.save')}} </button>
                                <a href="{{url('/admin/news-items')}}"><button type="button" class="btn btn-danger mr-1"><i class="image-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>                            
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    {!! Form::close() !!}
</div>

@endsection


@section('script')
    <script>
        $( "#datepicker" ).datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd'
        });
        
        $(document).ready(function(){
            var maxField = 100; //Input fields increment limitation
            var addButton = $('.add_button'); //Add button selector
            var wrapper = $('.field_wrapper'); //Input field wrapper
            var fieldHTML ='<div class="row"><hr><div class="form-group col-md-6"><label for="question">{{trans('home.question')}}</label><input type="text"  class="form-control" placeholder="{{trans('home.question')}}" name="question[]"></div>';
            fieldHTML +='<div class="form-group col-md-5"><label for="answer">{{trans('home.answer')}}</label><textarea class="form-control" placeholder="{{trans('home.answer')}}" name="answer[]"></textarea></div>';
            fieldHTML +='<div class="form-group col-md-1"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

            var x = 1; //Initial field counter is 1

            //Once add button is clicked
            $(addButton).click(function(){
                //Check maximum number of input fields
                if(x < maxField){
                    x++; //Increment field counter
                    $(wrapper).append(fieldHTML); //Add field html
                }
            });

            //Once remove button is clicked
            $(wrapper).on('click', '.remove_button', function(e){
                e.preventDefault();
                $(this).parent().parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });
        });
    </script>
@endsection