@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit_lesson')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.lessons')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{route('lessons.index')}}">{{trans('home.lessons')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_lesson')}}</li>
            </ol>
        </div>
    </div>
        @if (session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session()->pull('success') }} <button type="button" class="btn-close" data-bs-dismiss="alert"
                    aria-label="Close"></button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="card-title">{{ trans('home.edit') }}</h4>
                            <a data-bs-toggle="modal" data-bs-target="#attachments" href="javascript:void(0)"
                                class="btn btn-info mr-1 px-5">
                                <i class="dripicons-bookmarks"></i>
                                {{ trans('home.attachments') }}</a>
                        </div>
                    </div>
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open([
                                    'method' => 'PATCH',
                                    'url' => 'admin/lessons/' . $lesson->id,
                                    'data-toggle' => 'validator',
                                    'files' => 'true',
                                ]) !!}


                                    <div class="row">

                                        <div class="col-md-3 mb-3">
                                            <label for="name_en">{{ trans('home.name_en') }}</label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ trans('home.name_en') }}" value="{{ $lesson->name_en }}"
                                                name="name_en" required>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="name_ar">{{ trans('home.name_ar') }}</label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ trans('home.name_ar') }}" value="{{ $lesson->name_ar }}"
                                                name="name_ar" required>
                                        </div>

                                        <div class="col-md-2 mb-3">
                                            <label for="course">{{ trans('home.course') }}</label>
                                            <input type="text" class="form-control" disabled
                                                placeholder="{{ trans('home.course') }}"
                                                value="{{ $lesson->course->{'name_' . $lang} }}">
                                        </div>

                                        {{--<div class="col-md-2 mb-3">
                                            <label for="type">{{ trans('home.type') }}</label>
                                            <input type="text" class="form-control" disabled
                                                value="{{ $lesson?->course?->trainings()?->first()?->type?->name_en }}"
                                                placeholder="{{ trans('home.type') }}" name="type">
                                        </div>--}}
                                        <div class="col-md-2 mb-3">
                                            <label for="order">{{ trans('home.order') }}</label>
                                            <input type="number" class="form-control" 
                                                value="{{ $lesson->order }}"
                                                placeholder="{{ trans('home.order') }}" name="order">
                                        </div>


                                        <div class="col-md-3 mb-3">
                                            <label for="duration">{{ trans('home.duration') }}</label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ trans('home.duration') }}" name="duration"
                                                value="{{ $lesson->duration }}" required>
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="chapter_id">{{ trans('home.chapter') }}</label>
                                            <select class="form-control" required id="chapter_id" name="chapter_id">
                                                @foreach ($chapters as $chapter)
                                                    <option value="{{ $chapter->id }}"
                                                        {{ $chapter->id == $lesson->chapter_id ? 'selected' : '' }}>
                                                        {{ $chapter->{'name_' . $lang} }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @if ($lesson?->course?->trainings()?->first()?->type_id == 1)
                                            <div class="col-md-6 mb-3" id="content_link">
                                                <label for="content_link">{{ trans('home.content_link_en') }}</label>
                                                <input type="text" class="form-control" value="{{ $lesson->content_link_en }}"
                                                    placeholder="{{ trans('home.content_link_en') }}" name="content_link_en"
                                                    required>
                                            </div>
                                            <div class="col-md-6 mb-3" id="meeting_Link_ar">
                                                <label for="meeting_Link_ar">{{ trans('home.meeting_Link_ar') }}</label>
                                                <input type="text" class="form-control" value="{{ $lesson->meeting_Link_ar }}"
                                                    placeholder="{{ trans('home.meeting_Link_ar') }}" name="meeting_Link_ar"
                                                    required>
                                            </div>
                                        @elseif ($lesson?->course?->trainings()?->first()?->type_id == 2)
                                            <div class="col-md-3 mb-3 " id="meeting_date">
                                                <label for="meeting_date">{{ trans('home.meeting_date') }}</label>
                                                <input type="date" class="form-control"
                                                    value="{{ \Carbon\Carbon::parse($lesson->date)->format('Y-m-d') }}"
                                                    placeholder="{{ trans('home.meeting_date') }}" name="meeting_date">
                                            </div>
                                            <div class="col-md-2 mb-3 " id="meeting_time">
                                                <label for="meeting_time">{{ trans('home.meeting_time') }}</label>
                                                <input type="time" class="form-control" value="{{ $lesson->time }}"
                                                    placeholder="{{ trans('home.meeting_time') }}" name="meeting_time">
                                            </div>
                                            <div class="col-md-6">
                                                <label
                                                    for="content_link">{{ trans('home.address') . ' ' . __('home.en') }}</label>
                                                <input type="text" class="form-control"
                                                    value="{{ $lesson->content_link_en }}"
                                                    placeholder="{{ trans('home.address') }}" name="content_link_en">
                                            </div>
                                            <div class="col-md-6"><label
                                                    for="content_link">{{ trans('home.address') . ' ' . __('home.ar') }}</label>
                                                <input type="text" class="form-control"
                                                    value="{{ $lesson->content_link_ar }}"
                                                    placeholder="{{ trans('home.address') }}" name="content_link_ar">
                                            </div>
                                        @elseif($lesson?->course?->trainings()?->first()?->type_id == 3)
                                            <div class="col-md-6">
                                                <label for="content_link">{{ trans('home.content_link_en') }}</label>
                                                <input type="text" class="form-control"
                                                    value="{{ $lesson->content_link_en }}"
                                                    placeholder="{{ trans('home.content_link_en') }}" name="content_link_en">
                                            </div>
                                            <div class="col-md-6">
                                                <label for="content_link">{{ trans('home.meeting_Link_ar') }}</label>
                                                <input type="text" class="form-control"
                                                    value="{{ $lesson->meeting_Link_ar }}"
                                                    placeholder="{{ trans('home.meeting_Link_ar') }}" name="meeting_Link_ar">
                                            </div>
                                        @endif



                                        <div class="col-md-12 row mt-2">
                                            <div class="col-md-6 mb-3 ">
                                                <label for="text_en">{{ trans('home.text_en') }}</label>
                                                <textarea class="form-control ckeditor-classic" placeholder="{{ trans('home.text_en') }}" name="text_en">{{ $lesson->text_en }}</textarea>
                                            </div>
                                            <div class="col-md-6 mb-3 ">
                                                <label for="text_ar">{{ trans('home.text_ar') }}</label>
                                                <textarea class="form-control ckeditor-classic" placeholder="{{ trans('home.text_ar') }}" name="text_ar">{{ $lesson->text_ar }}</textarea>
                                            </div>
                                        </div>

                                        <h4 class="card-title mt-3 mb-3">{{ trans('home.seo_block') }}</h4>
                                        <div class="form-group col-md-6">
                                            <span class="badge-soft-primary">{{ trans('home.en') }}</span>
                                            <div class="col-md-12 mb-3">
                                                <label for="link_en">{{ trans('home.slug') }}</label>
                                                <input type="text" class="form-control" value="{{ $lesson->link_en }}"
                                                    placeholder="{{ trans('home.slug') . ' ' . __('home.en') }}"
                                                    name="link_en">
                                            </div>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <span class="badge-soft-primary">{{ trans('home.ar') }}</span>
                                            <div class="col-md-12 mb-3">
                                                <label for="link_ar">{{ trans('home.slug') }}</label>
                                                <input type="text" class="form-control" value="{{ $lesson->link_ar }}"
                                                    placeholder="{{ trans('home.slug') . ' ' . __('home.ar') }}"
                                                    name="link_ar">
                                            </div>
                                        </div>


                                    </div>

                                    <div class="row">
                                        <div class="form-group col-4">
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch"
                                                    switch="success" {{ $lesson->status ? 'checked' : '' }} />
                                                <label for="switch" data-on-label="{{ trans('home.yes') }}"
                                                    data-off-label="{{ trans('home.no') }}"></label>
                                                <label class="form-check-label mx-3" for="switch">
                                                    {{ trans('home.publish') }}</label>
                                            </div>
                                        </div>
                                        <div class="form-group col-4">
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="free" id="free"
                                                    switch="success" {{ $lesson->free ? 'checked' : '' }} />
                                                <label for="free" data-on-label="{{ trans('home.yes') }}"
                                                    data-off-label="{{ trans('home.no') }}"></label>
                                                <label class="form-check-label mx-3" for="free">
                                                    {{ trans('home.free') }}</label>
                                            </div>
                                        </div>
                                        <div class="mt-4">
                                            <button type="submit"
                                                class="btn btn-primary w-md">{{ trans('home.save') }}</button>
                                            <a href="{{ url('/admin/courses') }}"><button type="button"
                                                    class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                                    {{ trans('home.cancel') }}</button></a>
                                        </div>
                                    </div>


                                {!! Form::close() !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Row -->
        </div>
    </div>
    {{-- -------------------------------------------------------- All Attachments --}}
    <div class="modal fade text-left" id="attachments" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34"
        aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="myModalLabel34">{{ trans('home.attachments') }}</h3>

                    <a type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <h5 class="modal-title" id="myModalLabel34">X</h5>
                    </a>
                </div>
                <div class="modal-body">
                    <div class="row justify-content-end">
                        <a data-bs-toggle="modal" data-bs-target="#add_attachment" href="javascript:void(0)"
                            class="btn btn-info m-1 px-5 col-md-2">
                            <i class="dripicons-plus"></i>
                            {{ trans('home.add') }}</a>
                    </div>
                    <table class="table text-center" id="datatable">
                        <thead>
                            <tr>
                                <th>{{ trans('home.id') }}</th>
                                <th>{{ trans('home.name') . ' ' . __('home.en') }}</th>
                                <th>{{ trans('home.name') . ' ' . __('home.ar') }}</th>
                                <th>{{ trans('home.view') }}</th>
                                <th>{{ __('home.edit') }}</th>
                                <th>{{ __('home.delete') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($lesson->attachments as $attachment)
                                <tr>
                                    <td>{{ $attachment->id }}</td>
                                    <td>{{ $attachment->name_en }}</td>
                                    <td>{{ $attachment->name_ar }}</td>

                                    <td>
                                        <a type="button" class="btn btn-secondary waves-effect waves-light  col-8"
                                            href="{{ Helper::uploadedAttachmentPath($attachment->path) }}"
                                            target="_blank">{{ __('home.view') }}</a>
                                    </td>
                                    <td>
                                        <a type="button" data-attach_id="{{ $attachment->id }}"
                                            class="btn btn-info waves-effect waves-light  col-8 edit_attach">{{ __('home.edit') }}</a>
                                    </td>
                                    <td>
                                        <form action="{{ route('attachments.destroy', $attachment) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger waves-effect waves-light col-6"
                                                data-id="{{ $attachment->id }}">{{ __('home.delete') }}</button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach()
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    {{-- ------------------------------------------------------- Add new  Attachments --}}
    <div class="modal fade text-left sub-modal" id="add_attachment" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel34" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="myModalLabel34">{{ __('home.New') . ' ' . trans('home.attachments') }}
                    </h3>

                    <a type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <h5 class="modal-title" id="myModalLabel34">X</h5>
                    </a>
                </div>
                <div class="modal-body">
                    {!! Form::open([
                        'method' => 'POST',
                        'url' => 'admin/attachments',
                        'data-toggle' => 'validator',
                        'files' => 'true',
                    ]) !!}
                    <div class="row">

                        <input type="hidden" name="lesson_id" value="{{ $lesson->id }}">
                        <div class="col-md-6 mb-3">
                            <label for="name_en">{{ trans('home.name_en') }}</label>
                            <input type="text" class="form-control" placeholder="{{ trans('home.name_en') }}"
                                name="name_en" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="name_ar">{{ trans('home.name_ar') }}</label>
                            <input type="text" class="form-control" placeholder="{{ trans('home.name_ar') }}"
                                name="name_ar" required>
                        </div>
                        <div class="col-md-12 mb-3 mt-3">
                            <label for="formFile" class="form-label">{{ trans('home.choose_image') }}</label>
                            <input class="form-control" type="file" id="formFile" name="attachment">
                        </div>

                    </div>
                    <div class="row mt-4 justify-content-end">
                        <button type="submit" class="btn btn-primary w-md col-auto">{{ trans('home.save') }}</button>
                        <a class="close col-auto" data-bs-dismiss="modal" aria-label="Close"><button type="button"
                                class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                {{ trans('home.cancel') }}</button></a>
                    </div>
                    {!! Form::close() !!}


                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        $(document).on('click', '.edit_attach', function() {
            var attach_id = $(this).data('attach_id');
            console.log(attach_id);

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "/admin/attachments/" + attach_id + "/edit",
                method: 'GET',
                success: function(data) {
                    $('body').append(data.html);
                    $('#edit_attachment_'+attach_id).modal('show');
                }
            });
        });
    </script>
@endsection
