@extends('layouts.admin')
<title>{{ trans('home.instructors') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.instructors') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.instructors') }}</li>
                </ol>
            </div>

            <div class="btn btn-list">

               {{-- <a href="{{ route('un_assign_instructor') }}"><button class="btn ripple btn-warning">
                   <i class="fas fa-times-circle"></i> {{ trans('home.delete_trainings_of_instructors') }}</button></a>
                <a class="mr-2" href="{{ route('assign_instructor') }}" id="assign_instructors" ><button class="btn ripple btn-info"><i
                            class="fas fa-plus-circle"></i> {{ trans('home.assign_instructors') }}</button></a> --}}
                <a class="mr-2" href="{{ route('instructors.create') }}"><button class="btn ripple btn-primary"><i
                            class="fas fa-plus-circle"></i> {{ trans('home.add') }}</button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                        {{ trans('home.publish/unpublish') }}</button></a>
                <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                        {{ trans('home.delete') }}</button></a>
            </div>
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.instructors') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>

                        {{-- <div class="d-flex justify-content-between">--}}
                        <!--    <form method="post" action="{{ url('course-import-excel') }}" enctype="multipart/form-data">-->
                        <!--    @csrf-->
                        <!--    <div class="col-md-4">-->
                        <!--        {{-- <label>{{trans('home.Exel')}}</label> --}}-->
                        <!--        <div class="input-group mb-1">-->
                        <!--            <div class="input-group-prepend"> -->
                        <!--                <span class="input-group-text"> {{ trans('home.upload') }}</span>-->
                        <!--            </div>-->
                        <!--            <div class="custom-file">-->
                        <!--                <input type="file" class="custom-file-input" name="excelFile" required>-->
                        <!--                <label class="custom-file-label"-->
                        <!--                    for="inputGroupFile01">{{ trans('home.choose_excel_file') }}</label>-->
                        <!--            </div>-->
                        <!--        </div>-->
                        <!--        @error('excelFile')-->
                        <!--            <div class="alert alert-danger">{{ $message }}</div>-->
                        <!--        @enderror-->
                        <!--    </div>-->
                        <!--    <button class="btn ripple btn-primary col-md-2" type="submit"><i-->
                        <!--            class="fas fa-plus-circle"></i>-->
                        <!--        {{ trans('home.importExcel') }}</button>-->
                        <!--</form>-->
                        {{--</div> --}}

                        <div class="table-responsive">
                            <table class="table" id="">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                        <th>{{ trans('home.id') }}</th>
                                        <th >{{ trans('home.ssn') }}</th>
                                        <th >{{ trans('home.name') }}</th>
                                        <th >{{ trans('home.email') }}</th>
                                        <th >{{ trans('home.phone') }}</th>
                                        <th >{{ trans('home.image') }}</th>
                                        <th >{{ trans('home.n_training') }}</th>
                                        <th >{{ trans('home.status') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($instructors as $instructor)
                                        <tr id="{{ $instructor->user->id }}">
                                            <td> <input type="checkbox" name="checkbox" class="tableChecked" value="{{ $instructor->user->id }}" /> </td>
                                            <td><a href="{{ route('instructors.edit', $instructor->id) }}">{{ $instructor->user->id }}</a>  </td>
                                            <td><a href="{{ route('instructors.edit', $instructor->id) }}">{{ $instructor->user->instructor_info->ssn }}</a>  </td>
                                            <td><a  href="{{ route('instructors.edit', $instructor->id) }}">{{ $instructor->user->f_name.' '.$instructor->user->l_name }}</a> </td>
                                            <td><a  href="{{ route('instructors.edit', $instructor->id) }}">{{ $instructor->user->email}}</a> </td>
                                            <td><a  href="{{ route('instructors.edit', $instructor->id) }}">{{ $instructor->user->instructor_info->mobile}}</a> </td>
                                            <td>
                                                <a href="{{ route('instructors.edit', $instructor->id) }}">
                                                    @if($instructor->user->image)
                                                        <img src={{url('uploads/users/source/'.$instructor->user->image)}} width="100">
                                                    @endif
                                                </a>
                                            </td>
                                            <td><a  href="{{ route('instructors.edit', $instructor->id) }}">{{ $instructor->count}}</a> </td>
                                            <td><a  href="{{ route('instructors.edit', $instructor->id) }}">{{ $instructor->user->status==1? __('home.active') : __('home.inactive') }}</a> </td>
                                           
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
