@extends('layouts.admin')
@section('content')

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            
            <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.welcome') . ' ' . auth()->user()->name() }}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.index')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Row-->
     {{--<div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card">
                <div class="card-body">
                    <div>
                        <h2 class="card-title mb-1"> {{trans('home.general_statistcs_of')}}</h2>
                        <!--<h6 class="card-title mb-1">{{$configration->app_name}} {{trans('home.statistcs')}}</h6>-->
                        <!--<p class="text-muted card-sub-title">{{trans('home.general_statistcs_of')}} {{$configration->app_name}}</p>-->
                    </div>
                </div>
            </div>
        </div>
    </div>--}}
    <div class="row">
        
            <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{route('users.index')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service  rounded-circle ">
							    <i class="fas fa-users"></i>
							</div>
							<p class="headCardHome">{{trans('home.Total Users')}}</p>
							<h3 class="headCardNum">{{$users}}</h3>
						</div>
					</div>
				</a>
			</div>
			
		    <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{LaravelLocalization::localizeUrl('admin/teachers')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service  rounded-circle ">
							   <i class="fas fa-chalkboard-teacher"></i>
							</div>
							<p class="headCardHome">{{trans('home.instructors')}}</p>
							<h3 class="headCardNum">{{$teachers}}</h3>
						</div>
					</div>
				</a>
			</div>
			
		    <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{LaravelLocalization::localizeUrl('admin/teachers')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service  rounded-circle ">
							    <i class="fas fa-user-graduate"></i>
							</div>
							<p class="headCardHome">{{trans('home.students')}}</p>
							<h3 class="headCardNum">{{$teachers}}</h3>
						</div>
					</div>
				</a>
			</div>
			
			
		    <div class="col-sm-6 col-md-4 col-xl-3">
				<a href="{{LaravelLocalization::localizeUrl('admin/categories')}}" class="filter_type" data-filter="instructors">
				    <div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service  rounded-circle ">
							    <i class="fas fa-university"></i>
							</div>
							<p class="headCardHome">{{trans('home.Total Categories')}}</p>
							<h3 class="headCardNum">{{$categories}}</h3>
						</div>
					</div> 
				</a>
			</div>
			
		    <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{LaravelLocalization::localizeUrl('admin/blog-items')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service  rounded-circle ">
							    <i class="fas fa-newspaper"></i>
							</div>
							<p class="headCardHome">{{trans('home.Total blogs')}}</p>
							<h3 class="headCardNum">{{$blogs}}</h3>
						</div>
					</div>
				</a>
			</div>
			
				
		   <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{LaravelLocalization::localizeUrl('admin/news-items')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service  rounded-circle ">
								<i class="far fa-newspaper"></i>
							</div>
							<p class="headCardHome">{{trans('home.Total News')}}</p>
							<h3 class="headCardNum">{{$news}}</h3>
						</div>
					</div>
				</a>
			</div>

		
		   <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{LaravelLocalization::localizeUrl('admin/webinars')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service  rounded-circle ">
								<i class="fas fa-calendar-week"></i>
							</div>
							<p class="headCardHome">{{trans('home.Total Webinars')}}</p>
							<h3 class="headCardNum">{{$webinars}}</h3>
						</div>
					</div>
				</a>
			</div>
		
			
		   <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{LaravelLocalization::localizeUrl('admin/companies-requests')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service  rounded-circle ">
								<i class="fas fa-building"></i>
							</div>
							<p class="headCardHome">{{trans('home.companies_requests')}}</p>
							<h3 class="headCardNum">{{$company_requests}}</h3>
						</div>
					</div>
				</a>
			</div>
		   <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{LaravelLocalization::localizeUrl('admin/course-subscribers-requests')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service  rounded-circle ">
								<i class="fas fa-medal"></i>
							</div>
							<p class="headCardHome">{{trans('home.courses_subscribers_requests')}}</p>
							<h3 class="headCardNum">{{$course_subscribers_requests}}</h3>
						</div>
					</div>
				</a>
			</div>
		
		<!--instructors-->

		    
		    <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="javascript:void;">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service  rounded-circle ">
								<i class="fas fa-dollar-sign"></i>
							</div>
							<p class="headCardHome">{{trans('home.Total Orders Price')}}</p>
							<h3 class="headCardNum">{{$orders->sum('total_price')}}</h3>
						</div>
					</div>
				</a>
			</div>
    </div>

</div>
@endsection
