@extends('layouts.admin')

@section('meta')
<title>{{trans('home.center_halls')}}</title>
@endsection

@section('content')
    <div class="container-fluid">
        @php auth()->user()->type == 'partner' ? $title = trans('home.center_partner_hall') : $title = trans('home.center_halls') @endphp
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ $title }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
                </ol>
            </div>
            
            
            
            @can('halls_operations')
            <div class="btn btn-list">
                @can('halls_add_buttons')
                    <a href="{{ route('center_halls.create') }}"><button class="btn ripple btn-primary"><i
                                class="fas fa-plus-circle"></i> {{ trans('home.add') }}</button></a>
                @endcan
                @can('halls_delete_buttons')
                    <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                            {{ trans('home.publish/unpublish') }}</button></a>
                    <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                            {{ trans('home.delete') }}</button></a>
                @endcan
            </div>
            @endcan
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ $title }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>

                        <div class="d-flex justify-content-left m-3">
                            <input style="width:15px; margin-left:5px" type="checkbox" name="checkbox" class="tableChecked" value="Select All" id="checkAll"/>
                            <label style="font-size:20px; padding-top:10px" for="checkAll">{{trans('home.select_all')}}</label>
                        </div>
                        {!! $dataTable->table(['class' => 'table table-bordered w-100']) !!}
                        
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection

@section('script')
    {!! $dataTable->scripts() !!}
@endsection
