@extends('layouts.admin')
<title>{{ trans('home.center_halls') }}</title>
@section('content')
    <div class="container-fluid">
        @php auth()->user()->type == 'partner' ? $title = trans('home.center_partner_hall') : $title = trans('home.center_halls') @endphp
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ $title }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
                </ol>
            </div>
            <div class="btn btn-list">
                <a href="{{ route('center_halls.create') }}"><button class="btn ripple btn-primary"><i
                            class="fas fa-plus-circle"></i> {{ trans('home.add') }}</button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                        {{ trans('home.publish/unpublish') }}</button></a>
                <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                        {{ trans('home.delete') }}</button></a>
            </div>
            @can('operations')
            <div class="btn btn-list">
                <a href="{{ route('center_halls.create') }}"><button class="btn ripple btn-primary"><i
                            class="fas fa-plus-circle"></i> {{ trans('home.add') }}</button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                        {{ trans('home.publish/unpublish') }}</button></a>
                <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                        {{ trans('home.delete') }}</button></a>
            </div>
            @endcan
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ $title }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" id="checkAll" /></th>
                                        <th>{{ trans('home.id') }}</th>
                                        <th class="wd-20p">{{ trans('home.name') }}</th>
                                        <th class="wd-25p">{{ trans('home.center') }}</th>
                                        <th class="wd-5p">{{ trans('home.capacity') }}</th>
                                        <th class="wd-10p">{{ trans('home.type') }}</th>
                                        <th class="wd-25p">{{ trans('home.address') }}</th>
                                        <th class="wd-25p">{{ trans('home.logo') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($halls as $hall)
                                        <tr id="{{ $hall->id }}">
                                            <td> <input type="checkbox" name="checkbox" class="tableChecked"
                                                    value="{{ $hall->id }}" /> </td>
                                            <td><a
                                                    href="{{ route('center_halls.edit', $hall->id) }}">{{ $hall->id }}</a>
                                            </td>
                                            <td><a
                                                    href="{{ route('center_halls.edit', $hall->id) }}">{{ app()->getLocale() == 'en' ? $hall->name_en : $hall->name_ar }}</a>
                                            </td>
                                            <td><a
                                                    href="{{ route('center_halls.edit', $hall->id) }}">{{ app()->getLocale() == 'en' ? $hall->center->name_en : $hall->center->name_ar }}</a>
                                            </td>
                                            <td><a
                                                    href="{{ route('center_halls.edit', $hall->id) }}">{{ $hall->capacity }}</a>
                                            </td>
                                            <td><a
                                                    href="{{ route('center_halls.edit', $hall->id) }}">{{ $hall->type }}</a>
                                            </td>
                                            <td><a
                                                    href="{{ route('center_halls.edit', $hall->id) }}">{{ app()->getLocale() == 'en' ? $hall->address_en : $hall->address_ar }}</a>
                                            </td>
                                            <td><a href="{{ route('center_halls.edit', $hall->id) }}">
                                                <img    style="height:80px;"
                                                        src="{{ url("uploads/center_halls/$hall->logo") }}"
                                                        alt=""></a></td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
