@extends('layouts.admin')
@section('meta')
    <title>{{ trans('home.edit_center_hall') }}</title>
@endsection
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.center_halls') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ url('center_halls') }}">{{ trans('home.center_halls') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.edit_center_hall') }}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        {!! Form::open([
            'method' => 'PATCH',
            'url' => route('center_halls.update' , $hall->id),
            'data-toggle' => 'validator',
            'files' => 'true',
        ]) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.edit_center_hall') }}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.hall_name_en')}}</label>
                                <input class="form-control  @error('name_en') is-invalid @enderror" name="name_en" type="text" value="{{ old('name_en',$hall->name_en) }}" placeholder="{{trans('home.hall_name_en')}}">
                                 @error('name_en')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.hall_name_ar')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control  @error('name_ar') is-invalid @enderror" name="name_ar" type="text" value="{{ old('name_ar',$hall->name_ar) }}" required placeholder="{{trans('home.hall_name_ar')}}">
                                 @error('name_ar')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            
                            <div class="col-md-4">
                                @error('logo') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label>{{ trans('home.logo') }}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="logo">
                                        <label class="custom-file-label"
                                            for="inputGroupFile01">{{ trans('home.choose_logo') }}</label>
                                    </div>
                                </div>
                                @if($hall->logo)
                                    <img style="height: 150px; margin-top:15px"
                                        src="{{ url("uploads/center_halls/$hall->logo") }}" alt="">
                                @endif
                            </div>
                            
                             <div class="form-group col-md-3">
                                @error('building_name') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.building_name')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control" name="building_name" value="{{ old('building_name',$hall->building_name) }}" required type="text" placeholder="{{trans('home.building_name')}}">
                            </div>
                            <div class="form-group col-md-3">
                                @error('floor') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.floor')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control" name="floor" value="{{ old('floor',$hall->floor) }}" required type="text" placeholder="{{trans('home.floor')}}">
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.center')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2  @error('center_id') is-invalid @enderror" required name="center_id" id="">
                                    <option value="">{{ __('home.choose_center') }}</option>
                                    @foreach ($centers as $center)
                                        <option value ="{{$center->id}}" @selected(old('center_id',$hall->center_id)== $center->id)>{{(app()->getLocale()=='en')? $center->name_en:$center->name_ar}}</option>
                                    @endforeach
                                </select>
                                 @error('center_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.type')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2  @error('type') is-invalid @enderror" required name="type" id="">
                                    <option value="">{{ __('home.choose_type') }}</option>
                                    <option value="practical" @selected(old('type',$hall->type)== 'practical')>{{ __('home.practical') }}</option>
                                    <option value="theoretical" @selected(old('type',$hall->type)== 'theoretical')>{{ __('home.theoretical') }}</option>
                                </select>
                                 @error('type')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-2">
                                @error('disabled_suitable') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.disabled_suitable')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2  @error('disabled_suitable') is-invalid @enderror" name="disabled_suitable" id="" required>
                                    
                                    <option value="">{{ __('home.choose_type') }}</option>
                                    <option value="1" @selected(old('disabled_suitable',$hall->disabled_suitable)== 1)>{{ __('home.yes') }}</option>
                                    <option value="0" @selected(old('disabled_suitable',$hall->disabled_suitable)== 0)>{{ __('home.no') }}</option>
                                </select>
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.capacity')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control @error('capacity') is-invalid @enderror" name="capacity" value="{{ old('capacity',$hall->capacity) }}" required type="number" min="0" placeholder="{{trans('home.capacity')}}">
                                 @error('capacity')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                @error('country_id') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.country')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2 country" name="country_id" id="" required>
                                    <option value="">{{ __('home.choose_country') }}</option>
                                    @foreach($countries as $country)
                                        <option value="{{$country->id}}" {{($country->id == $hall->country_id)?'selected':''}}>{{(app()->getLocale() == 'en')?$country->name_en:$country->name_ar}}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="form-group col-md-3">
                                @error('area_id') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.area')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2 area" name="area_id" id="" required>
                                    <option value="">{{ __('home.choose_area') }}</option>
                                    @foreach($areas as $area)
                                        <option value="{{$area->id}}" {{($area->id == $hall->area_id)?'selected':''}}>{{(app()->getLocale() == 'en')?$area->name_en:$area->name_ar}}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="form-group col-md-3">
                                @error('region_id') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.region')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2 region" name="region_id" id="" required>
                                    <option value="">{{ __('home.choose_region') }}</option>
                                    @foreach($regions as $region)
                                        <option value="{{$region->id}}" {{($region->id == $hall->region_id)?'selected':''}}>{{(app()->getLocale() == 'en')?$region->name_en:$region->name_ar}}</option>
                                    @endforeach
                                </select>
                            </div>
                            

                            <div class="form-group col-md-3">
                                @error('address_en') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.address_en')}}</label>
                                <input class="form-control @error('address_en') is-invalid @enderror" name="address_en" value="{{ old('address_en',$hall->address_en) }}" type="text" placeholder="{{trans('home.address_en')}}">
                                  @error('address_en')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.address_ar')}}</label>
                                <input class="form-control   @error('address_ar') is-invalid @enderror" name="address_ar" value="{{ old('address_ar',$hall->address_ar) }}" type="text" placeholder="{{trans('home.address_ar')}}">
                                 @error('address_ar')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.map_url')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <textarea class="form-control  @error('map_url') is-invalid @enderror" name="map_url" type="text" required placeholder="{{trans('home.map_url')}}">{{ old('map_url',$hall->map_url) }}</textarea>
                                 @error('map_url')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                    {{ trans('home.save') }} </button>
                                <a href="{{ route('center_halls.index') }}"><button type="button"
                                        class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                        {{ trans('home.cancel') }}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        {!! Form::close() !!}
    </div>
@endsection

@section('script')
    <script>
        $('.country').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getAreas')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    area.html(html);
                }
            });
        });

        $('.area').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getRegions')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    region.html(html);
                }
            });
        });
    </script>
    <script>
        $("#datepicker").datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd'
        });
    </script>
@endsection
