@extends('layouts.admin')
<title>{{trans('home.edit_galleryImage')}}</title>
@section('content')

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.galleryImages')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/gallery-images')}}">{{trans('home.galleryImages')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_galleryImage')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    {!! Form::open(['method'=>'PATCH','url' => 'admin/gallery-images/'.$galleryImage->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.edit_galleryImage')}}</h6>
                            <hr>
                        </div>
                        <div class="row">

                            <div class="form-group col-md-8">
                                <label class="">{{trans('home.image')}}</label>
                                <input class="form-control" name="img" type="file" >
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label for="type">{{trans('home.type')}}</label>
                                <select class="form-control select2" name="type">
                                    <option value="general" {{($gallery->type == 'general')?'selected':''}}>{{trans('home.general')}}</option>  
                                    <option value="after_and_before" {{($gallery->type == 'after_and_before')?'selected':''}}>{{trans('home.after_and_before')}}</option>
                                    <option value="patient" {{($gallery->type == 'patient')?'selected':''}}>{{trans('home.patient')}}</option>
                                </select>
                            </div>

                            <div class="form-group col-md-1">
                                <fieldset class="form-group">
                                    <label for="order">{{trans('home.order')}}</label>
                                    <input type="number" min="1"  class="form-control" placeholder="{{trans('home.order')}}" name="order" value="{{$galleryImage->order}}" >
                                </fieldset>
                            </div>
                        
                            @if($galleryImage->img)
                                <div class="form-group col-md-12">
                                    <img src="{{url('uploads/galleryImages/source/'.$galleryImage->img)}}"  width="150px" height="150px"/>
                                </div>
                            @endif
                            
                            <div class="form-group col-md-6">
                                <label for="text_en">{{trans('home.text_en')}}</label>
                                <textarea class="form-control " name="text_en" placeholder="{{trans('home.text_en')}}" maxlength="50">{{$galleryImage->text_en}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="text_ar">{{trans('home.text_ar')}}</label>
                                <textarea class="form-control " name="text_ar" placeholder="{{trans('home.text_ar')}}" maxlength="50">{{$galleryImage->text_ar}}</textarea>
                            </div>
                          
                            <div class="form-group col-md-12">
                                <p class="mt-4 mb-2">{{trans('home.publish')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input" {{($galleryImage->status == 1)? 'checked':''}}/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish')}}</span>
                                </label>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
        
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                <a href="{{url('/admin/gallery-images')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    {!! Form::close() !!}
</div>

@endsection
