@extends('layouts.admin')
@section('meta')
    <title>{{ trans('home.edit_exame') }}</title>
@endsection
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.exames') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('exames.index') }}">{{ trans('home.exames') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.edit_exame') }}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        {!! Form::open([
            'method' => 'PATCH',
            'url' => route('exames.update',$exame->id),
            'data-toggle' => 'validator',
            'files' => 'true',
        ]) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.edit_course') }}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            
                         <div class="form-group col-md-4">
                            <label class="">{{trans('home.name_en')}}</label>
                            <input class="form-control @error('name_en') is-invalid @enderror" name="name_en" type="text" placeholder="{{trans('home.name_en')}}" required value="{{$exame->name_en}}" >
                            @error('name_en')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.name_ar')}}</label>
                            <input class="form-control @error('name_ar') is-invalid @enderror" name="name_ar" type="text" placeholder="{{ trans('home.name_ar') }}" value="{{$exame->name_ar }}">
                            @error('name_ar')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group col-md-4">
                            <label for="course">{{trans('home.course')}}</label>
                            <select class="form-control select2 @error('course') is-invalid @enderror" name="course">
                                @foreach($courses as $course)
                                    <option value="{{$course->id}}" @if($exame->course->id==$course->id) selected @endif>{{$course->{'name_'.$lang} }}</option>
                                @endforeach    
                            </select>
                            @error('course')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                        </div>
                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.duration')}}</label>
                            <input class="form-control @error('duration') is-invalid @enderror" name="duration" type="text" placeholder="{{ trans('home.duration') }}" value="{{ $exame->duration }}">
                            @error('duration')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.average_rate')}}</label>
                            <input class="form-control @error('average_rate') is-invalid @enderror" name="average_rate" type="number" step="0.01" placeholder="{{ trans('home.average_rate') }}" value="{{ $exame->average_rate }}">
                            @error('average_rate')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        @can('status_or_publish_field')
                        <div class="form-group col-md-12">
                            <label class="custom-switch">
                                <input type="checkbox" name="status" @if($exame->status==1) checked @endif value="1" checked class="custom-switch-input"/>
                                <span class="custom-switch-indicator"></span>
                                <span class="custom-switch-description">{{trans('home.publish')}}</span>
                            </label>
                        </div>
                        @endcan
                            
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>{{ trans('home.save') }} </button>
                                <a href="{{ route('exames.index') }}">
                                    <button type="button"class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                        {{ trans('home.cancel') }}</button>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        {!! Form::close() !!}
    </div>
@endsection

