@extends('layouts.admin')
<title>{{ trans('home.exame_results') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
      
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.exame_results') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">
                        <a href="{{route('exame_results')}}">
                        {{ trans('home.exame_results') }}
                        </a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">{{$training->{'name_'.$lang} }}</li>
                </ol>
            </div>
        </div>
     
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.exame_results') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>
                        
                        
                        <div class="text-center m-auto col-sm-12">
                            <h4>{{__('home.exame_results_for') }}</h4>
                            <h2 class="mt-3">{{$training->{'name_'.$lang} }}</h2>
                            @if($training->exame)
                            <h2 class="mt-3">{{__('home.success_rate').' : '.$training->exame->success_rate .' %' }}</h2>
                            @endif
                        </div>
                        
                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                    <th>{{trans('home.user')}}</th>
                                    <th>{{trans('home.ssn')}}</th>
                                    <th>{{trans('home.email')}}</th>
                                    <th>{{trans('home.exame')}}</th>
                                    <th>{{trans('home.rate')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($training->exame)
                                    @foreach($training->exame->exame_results_admin as $result)
                                        <tr id="{{$training->id}}">
                                            <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$training->id}}" /> </td>
                                            <td><a>{{$result->user->name()}}</a></td>
                                            <td><a>{{$result->user->student_info->ssn }}</a></td>
                                            <td><a>{{$result->user->email }}</a></td>
                                            <td><a>{{$training->exame?$training->exame->exame_details->{'name_'.$lang}:'' }}</a></td>
                                            @if($result->result >= $training->exame->success_rate)
                                                <td>
                                                    {{$result->result.' %'}}
                                                  <i class="fa fa-check fa-lg" style="color: #63E6BE;"></i>
                                                </td>
                                            @else
                                                <td>{{$result->result.' %'}} 
                                                    <i class="fas fa-times fa-lg" style="color: #ff0000;"></i>
                                                </td>
                                            
                                            @endif
                                            
                                             {{--
                                            <!--<td class="text-center">-->
                                            <!--    <div>-->
                                            <!--        <a href="{{ route('exame_results_details', $training->id) }}"-->
                                            <!--            class="text-info" href="{{ route('students_per_training', ['training_id'=>$training->id]) }}">-->
                                            <!--            <i class="fas fa-eye"></i>-->
                                            <!--        </a>-->
                                            <!--    </div>-->
                                            <!--    <div>{{ count($training->exame?$training->exame->exame_results_admin->where('result','>=',$training->exame->success_rate):[]) }}</div>-->
                                            <!--</td>-->
                                            --}}
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection