@extends('layouts.admin')
<title>{{ trans('home.exame_results') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
      
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.exame_results') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.exame_results') }}</li>
                </ol>
            </div>
        </div>
      

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.exame_results') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>
                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                    <th>{{trans('home.code')}}</th>
                                    <th>{{trans('home.training')}}</th>
                                    <th>{{trans('home.exame')}}</th>
                                    <th>{{trans('home.n_success_students')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($trainings as $training)
                                    <tr id="{{$training->id}}">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$training->id}}" /> </td>
                                        <td><a href="{{ route('exame_results_details', $training->id) }}">{{$training->code}}</a></td>
                                        <td><a href="{{ route('exame_results_details', $training->id) }}">{{$training->{'name_'.$lang} }}</a></td>
                                        <td><a href="{{ route('exame_results_details', $training->id) }}">{{$training->exame?$training->exame->exame_details->{'name_'.$lang}:'' }}</a></td>
                                        
                                        <td class="text-center">
                                            <div>
                                                <a href="{{ route('exame_results_details', $training->id) }}"
                                                    class="text-info" href="{{ route('students_per_training', ['training_id'=>$training->id]) }}">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </div>
                                            <div>{{ count($training->exame?$training->exame->exame_results_admin->where('result','>=',$training->exame->success_rate):[]) }}</div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection