@extends('layouts.admin')
<title>{{ trans('home.questions') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.questions') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.questions') }}</li>
                </ol>
            </div>
            @can('questions_opertions')
                <div class="btn btn-list">
                    @can('questions_add_button')
                        <a href="{{ route('questions.create') }}"><button class="btn ripple btn-primary"><i
                                    class="fas fa-plus-circle"></i> {{ trans('home.add') }}</button></a>
                    @endcan
                    @can('questions_delete_button')
                        <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                                {{ trans('home.delete') }}</button></a>
                    @endcan
                </div>
            @endcan
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.questions') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                        <th>{{ trans('home.id') }}</th>
                                        <th class="wd-20p">{{ trans('home.question_en') }}</th>
                                        <th class="wd-25p">{{ trans('home.question_ar') }}</th>
                                        <th class="wd-20p">{{ trans('home.exame_name') }}</th>
                                        <th class="wd-20p">{{ trans('home.course') }}</th>
                                        <th class="wd-25p">{{ trans('home.n_answers') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($exames_questions as $question)
                                        <tr id="{{$question->id }}">
                                            <td> <input type="checkbox" name="checkbox" class="tableChecked" value="{{$question->id }}" /> </td>
                                            <td><a href="{{ route('questions.edit',$question->id) }}">{{$question->id }}</a>  </td>
                                            <td><a href="{{ route('questions.edit',$question->id) }}">{{$question->question_en ?? '' }}</a>  </td>
                                            <td><a href="{{ route('questions.edit',$question->id) }}">{{$question->question_ar ?? '' }}</a>  </td>
                                            <td><a href="{{ route('questions.edit',$question->id) }}">{{$question->exame->{'name_'.$lang} ?? '' }}</a>  </td>
                                            <td><a href="{{ route('questions.edit',$question->id) }}">{{$question->exame->course->{'name_'.$lang} ?? '' }}</a>  </td>
                                            <td><a href="{{ route('questions.edit',$question->id) }}">{{count($question->answers) }}</a>  </td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
