@extends('layouts.admin')
@section('meta')
    <title>{{ trans('home.edit_question') }}</title>
@endsection
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.questions') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('questions.index') }}">{{ trans('home.questions') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.edit_question') }}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        {!! Form::open([
            'method' => 'PATCH',
            'url' => route('questions.update',$question->id),
            'data-toggle' => 'validator',
            'files' => 'true',
        ]) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.edit_question') }}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            
                         <div class="form-group col-md-4">
                            <label class="">{{trans('home.question_en')}}</label>
                            <input class="form-control @error('question_en') is-invalid @enderror" name="question_en" type="text" placeholder="{{trans('home.question_en')}}" required value="{{$question->question_en}}" >
                            @error('question_en')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.question_ar')}}</label>
                            <input class="form-control @error('question_ar') is-invalid @enderror" name="question_ar" type="text" placeholder="{{ trans('home.question_ar') }}" value="{{$question->question_ar }}">
                            @error('question_ar')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="exame">{{trans('home.exame')}}</label>
                            <select class="form-control select2 @error('exame') is-invalid @enderror" name="exame">
                                @foreach($exames as $exame)
                                    <option value="{{$exame->id}}" @if($question->exame->id==$exame->id) selected @endif>{{$exame->{'name_'.$lang} }}</option>
                                @endforeach    
                            </select>
                            @error('exame')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                        </div>
                        @can('status_or_publish_field')
                        <div class="form-group col-md-12">
                            <label class="custom-switch">
                                <input type="checkbox" name="status" @if($question->status==1) checked @endif value="1" checked class="custom-switch-input"/>
                                <span class="custom-switch-indicator"></span>
                                <span class="custom-switch-description">{{trans('home.publish')}}</span>
                            </label>
                        </div>
                        @endcan
                            
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
        <!-- Row-->
            <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div>
                                <h6 class="card-title mb-1">{{trans('home.answers')}}</h6>
                                <hr>
                            </div>

                            <div class="field_wrapper">
                                @if(count($answers) > 0)
                                    @foreach($answers as $key=>$answer)
                                        <div class="row" id="answer_{{$answer->id}}">
                                            <div class="form-group col-md-3"> 
                                                <label for="answer_en">{{trans('home.answer_en')}}</label>
                                                <input type="text"  class="form-control" placeholder="{{trans('home.answer_en')}}" value="{{$answer->answer_en}}" disabled>
                                            </div>
        
                                            <div class="form-group col-md-3"> 
                                                <label for="answer_ar">{{trans('home.answer_ar')}}</label>
                                                <input type="text"  class="form-control" placeholder="{{trans('home.answer_ar')}}" value="{{$answer->answer_ar}}" disabled>
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label for="parent">{{trans('home.is_correct')}}</label>
                                                <select class="form-control select2" disabled>
                                                    <option value="1" {{($answer->is_correct == 1)?'selected':''}}>{{trans('home.true')}}</option>
                                                    <option value="0" {{($answer->is_correct == 0)?'selected':''}}>{{trans('home.false')}}</option>
                                                </select>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <button type="button" style="margin-top: 28px;"  
                                                class="btn editanswer" 
                                                    data-toggle="modal" data-target="#edit_answerModal_{{$answer->id}}" data-answer_id="{{$answer->id}}">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <button type="button" style="margin-top: 28px;" class="btn rmv" data-answer_id="{{$answer->id}}" id="type-error"><i class="fas fa-trash-alt"></i></button>
                                            </div>
                                        </div> 
                                    @endforeach
                                @else
                                    <div class="row">
                                        <div class="form-group col-md-4"> 
                                            <label for="answer_en">{{trans('home.answer_en')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.answer_en')}}" name="answer_en[]">
                                        </div>
                                        
                                        <div class="form-group col-md-4"> 
                                            <label for="answer_ar">{{trans('home.answer_ar')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.answer_ar')}}" name="answer_ar[]">
                                        </div>
    
                                        <div class="form-group col-md-3">
                                            <label for="parent">{{trans('home.is_corrcet')}}</label>
                                            <select class="form-control select2" name="is_correct[]">
                                                <option value="1">{{trans('home.true')}}</option>
                                                <option value="0" selected>{{trans('home.false')}}</option>
                                            </select>
                                        </div>
                                    </div>  
                                @endif
                            </div>       
                            <a href="javascript:void(0);" class="add_button btn" title="Add field"><i class="fas fa-plus-square"></i></a>								
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Row -->  
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>{{ trans('home.save') }} </button>
                                <a href="{{ route('exames.index') }}">
                                    <button type="button"class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                        {{ trans('home.cancel') }}</button>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        {!! Form::close() !!}
    </div>
    <div class="test">
        
    </div>
@endsection

@section('script')
<script>
    $(document).ready(function(){
        var maxField = 100; //Input fields increment limitation
        var addButton = $('.add_button'); //Add button selector
        var wrapper = $('.field_wrapper'); //Input field wrapper
        var fieldHTML ='<div class="row"><hr><div class="form-group col-md-4"> <label for="answer_en">{{trans('home.answer_en')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.answer_en')}}" name="answer_en[]"> </div>';
        fieldHTML +='<div class="form-group col-md-4"> <label for="answer_ar">{{trans('home.answer_ar')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.answer_ar')}}" name="answer_ar[]"> </div>';
        fieldHTML +='<div class="form-group col-md-3"> <label for="is_correct">{{trans('home.is_correct')}}</label> <select class="form-control select2" name="is_correct[]"> <option value="1">{{trans('home.true')}}</option> <option value="0" selected>{{trans('home.false')}}</option> </select> </div>';
        fieldHTML +='<div class="form-group col-md-1"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

        var x = 1; //Initial field counter is 1

        //Once add button is clicked
        $(addButton).click(function(){
            //Check maximum number of input fields
            if(x < maxField){
                x++; //Increment field counter
                $(wrapper).append(fieldHTML); //Add field html
            }
            $('.select2').select2({
                'placeholder' : 'choose',
            });
        });
        
        

        //Once remove button is clicked
        $(wrapper).on('click', '.remove_button', function(e){
            e.preventDefault();
            $(this).parent().parent('div').remove(); //Remove field html
            x--; //Decrement field counter
        });
    });
    
     $(document).ready(function(){
            $('.rmv').click(function () {
                var answer_id = $(this).data('answer_id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"{{route('delete_answer_question')}}",
                    method:'POST',
                    data: {answer_id:answer_id},
                    success:function(data) {
                        $('#answer_'+ answer_id).fadeOut('slow');
                    }
                });
            });
        });
</script>
<script>
    $('.editanswer').click(function () {
        
        var answer_id = $(this).data('answer_id');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: '{{route('editanswer.show')}}',
            method: 'POST',
            data: {
                answer_id: answer_id,
            },
            success: function (response) {
                $('#edit_answerModal').empty();
                $('.main-content ').append(response.view);
                $('#edit_answerModal_'+answer_id).modal('show');
            }
        });
    });

</script>
@endsection

