@extends('layouts.admin')
<title>{{trans('home.reports').' | '.trans('home.crm')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm')}}</h2>
               
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="{{url('admin/crm/reports')}}">{{trans('home.reports')}}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">  {{__('home.'.$type)}}  </li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <form>
                <div class="card custom-card">
                    <div class='card-body row mx-0 mt-4'>
                        
                    <div class="form-group col-lg-4 col-md-6 mb-3">
                        <label for="parent">{{trans('home.responsible_employee')}}</label>
                        <select class="form-control select2" name="responsible_employee" 
                        {{--onchange="this.form.submit()" --}}
                        >
                            <option value="" selected disabled>{{ trans('home.responsible_employee') }}</option>
                            @foreach($crm_employees as $crm_employee)
                                <option value="{{ $crm_employee->id }}"
                                {{ request('responsible_employee') == $crm_employee->id ? 'selected' : '' }}>
                                {{ $crm_employee->name() }}</option>
                            @endforeach    
                        </select>
                    </div>
                    <div class="form-group col-lg-4 col-md-6 mb-3">
                        <label for="date">{{trans('home.date')}}</label>
                         <input type="date" class="form-control" name="date" 
                         {{--onchange="this.form.submit()" --}}
                         value="{{ request('date') }}" >
                    </div>
                    <div class="mt-4">
                        <button class="btn btn-primary mr-1" type="submit">{{trans('home.filter')}}</label>
                    </div>
                    </div>
                </div>
            </form>
            <!-- target -->
            @if(isset($target_numbers['required']))
                <div class="col-sm-6 col-md-auto col-xl-auto">
					<div class="card custom-card">
						<div class="card-body text-center">
							<p class="mb-1 text-muted">{{__('home.budget_yearly')}}</p>
							<h3 class="m-4">
							    حقق 
							    <span class="bg-secondary text-white rounded px-2 mx-2">
							        {{$target_numbers['achieved']}}
							    </span>
    							 من
    							 {{$target_numbers['required'] }}
							 </h3>
						</div>
					</div>
    			</div>
			@endif
            <!-- new_clients -->
            <div class="col-sm-6 col-md-4 col-xl-4">
                <a href="{{ url('admin/crm/clients/?status_id=19') . '&' . http_build_query(request()->except('type')) }}">
					<div class="card custom-card">
						<div class="card-body text-center">
						    <div class='textI'>
						        <div class='cardText'>
        							<h2 class=""> {{$new_clients}} </h2>
        							<p class=""> {{trans('home.new_clients')}} </p>
						        </div>
						        <div class='cardIcon'>
						            <i class="fal fa-smile-plus"></i>
						        </div>
						    </div>
						    <div class='sinceCard'>
						        <span class=' text-success '>  <!-- text-danger for down  -->
						            
						            <!--<i class="fal fa-arrow-down"></i>-->
						            <i class="fal fa-arrow-up"></i>
						            3
						        </span>
						        <small class='text-dark'> الشهر السابق </small>
						    </div>
						</div>
					</div>
				</a>
			</div>
			 <!-- clients_with_multiple_statuses -->
            <div class="col-sm-6 col-md-4 col-xl-4">
                <a href="{{ url('admin/crm/reports/details?type=status_changed') . '&' . http_build_query(request()->except('type')) }}">
					<div class="card custom-card">
						<div class="card-body text-center">
						 
							
							<div class='textI'>
						        <div class='cardText'>
        							<h2 class=""> {{$clients_with_multiple_statuses}} </h2>
        							<p class=""> {{trans('home.status_changed')}} </p>
						        </div>
						        <div class='cardIcon'>
						            <i class="fal fa-users"></i>
						        </div>
						    </div>
						    <div class='sinceCard'>
						        <span class=' text-danger'>  <!-- text-success for up  -->
						           
						            <!--<i class="fal fa-arrow-down"></i>-->
						            <i class="fal fa-arrow-up"></i>
						             5
						        </span>
						        <small class='text-dark'> الشهر السابق </small>
						    </div>
						    
						</div>
					</div>
				</a>
			</div>
			 <!-- call -->
            <div class="col-sm-6 col-md-4 col-xl-4">
                <a href="{{ url('admin/crm/reports/details?type=n_calls') . '&' . http_build_query(request()->except('type')) }}">
					<div class="card custom-card">
						<div class="card-body text-center">
						 
							
							<div class='textI'>
						        <div class='cardText'>
        							<h2 class=""> {{$n_calls->count()}} </h2>
        							<p class=""> {{trans('home.n_calls')}} </p>
						        </div>
						        <div class='cardIcon'>
						            <i class="fal fa-phone-alt"></i>
						        </div>
						    </div>
						    <div class='sinceCard'>
						        <span class=' text-success'>  <!-- text-danger for up  -->
						           
						            <!--<i class="fal fa-arrow-down"></i>-->
						            <i class="fal fa-arrow-up"></i>
						             5
						        </span>
						        <small class='text-dark'> الشهر السابق </small>
						    </div>
						    
						</div>
					</div>
				</a>
			</div>
			 <!-- n_meeting -->
            <div class="col-sm-6 col-md-4 col-xl-4">
                <a href="{{ url('admin/crm/reports/details?type=n_meeting') . '&' . http_build_query(request()->except('type')) }}">
					<div class="card custom-card">
						<div class="card-body text-center">
						 
							
							<div class='textI'>
						        <div class='cardText'>
        							<h2 class=""> {{$n_meeting}} </h2>
        							<p class=""> {{trans('home.n_meeting')}} </p>
						        </div>
						        <div class='cardIcon'>
						            <i class="fal fa-users-class"></i>
						        </div>
						    </div>
						    <div class='sinceCard'>
						        <span class=' text-success'>  <!-- text-danger for up  -->
						           
						            <!--<i class="fal fa-arrow-down"></i>-->
						            <i class="fal fa-arrow-up"></i>
						             5
						        </span>
						        <small class='text-dark'> الشهر السابق </small>
						    </div>
						    
						    
						</div>
					</div>
				</a>
			</div>
			 <!-- $n_whatsapp -->
            <div class="col-sm-6 col-md-4 col-xl-4">
                <a href="{{ url('admin/crm/reports/details?type=n_whatsapp') . '&' . http_build_query(request()->except('type')) }}">
					<div class="card custom-card">
						<div class="card-body text-center">
					 
							
							<div class='textI'>
						        <div class='cardText'>
        							<h2 class="">  {{$n_whatsapp}} </h2>
        							<p class=""> {{trans('home.n_whatsapp')}} </p>
						        </div>
						        <div class='cardIcon'>
						            <i class="fab fa-whatsapp"></i>
						        </div>
						    </div>
						    <div class='sinceCard'>
						        <span class=' text-success'>  <!-- text-danger for up  -->
						           
						            <!--<i class="fal fa-arrow-down"></i>-->
						            <i class="fal fa-arrow-up"></i>
						             5
						        </span>
						        <small class='text-dark'> الشهر السابق </small>
						    </div>
							
						</div>
					</div>
				</a>
			</div>
			 <!-- $n_mails -->
            <div class="col-sm-6 col-md-4 col-xl-4">
                <a href="{{ url('admin/crm/reports/details?type=n_mails') . '&' . http_build_query(request()->except('type')) }}">
					<div class="card custom-card">
						<div class="card-body text-center">
						 
							
							<div class='textI'>
						        <div class='cardText'>
        							<h2 class="">  {{$n_mails}} </h2>
        							<p class=""> {{trans('home.n_mails')}} </p>
						        </div>
						        <div class='cardIcon'>
						            <i class="fal fa-envelope-open"></i>
						        </div>
						    </div>
						    <div class='sinceCard'>
						        <span class=' text-success'>  <!-- text-danger for up  -->
						           
						            <!--<i class="fal fa-arrow-down"></i>-->
						            <i class="fal fa-arrow-up"></i>
						             5
						        </span>
						        <small class='text-dark'> الشهر السابق </small>
						    </div>
						    
						</div>
					</div>
				</a>
			</div>
            <div class="col-sm-6 col-md-4 col-xl-4">
                <a href="{{ url('admin/crm/reports/details?type=n_sms') . '&' . http_build_query(request()->except('type')) }}">
					<div class="card custom-card">
						<div class="card-body text-center">
				 
							
							<div class='textI'>
						        <div class='cardText'>
        							<h2 class="">  {{$n_sms}} </h2>
        							<p class=""> {{trans('home.n_sms')}} </p>
						        </div>
						        <div class='cardIcon'>
                                    <i class="fal fa-sms"></i>
						        </div>
						    </div>
						    <div class='sinceCard'>
						        <span class=' text-success'>  <!-- text-danger for up  -->
						           
						            <!--<i class="fal fa-arrow-down"></i>-->
						            <i class="fal fa-arrow-up"></i>
						             5
						        </span>
						        <small class='text-dark'> الشهر السابق </small>
						    </div>
				 
							
						</div>
					</div>
				</a>
			</div>
            <div class="col-sm-6 col-md-4 col-xl-4">
                <a href="{{ url('admin/crm/reports/details?type=answered') . '&' . http_build_query(request()->except('type')) }}">
					<div class="card custom-card">
						<div class="card-body text-center">
					 
							
							<div class='textI'>
						        <div class='cardText'>
        							<h2 class="">  {{$n_calls->where('sent','answered')->count()}} </h2>
        							<p class=""> {{trans('home.n_calls').' '.trans('home.answered')}} </p>
						        </div>
						        <div class='cardIcon'>
                                    <i class="fal fa-phone-volume"></i>
						        </div>
						    </div>
						    <div class='sinceCard'>
						        <span class=' text-success'>  <!-- text-danger for up  -->
						           
						            <!--<i class="fal fa-arrow-down"></i>-->
						            <i class="fal fa-arrow-up"></i>
						             5
						        </span>
						        <small class='text-dark'> الشهر السابق </small>
						    </div>
							
							
						    
						</div>
					</div>
				</a>
			</div>
            <div class="col-sm-6 col-md-4 col-xl-4">
                <a href="{{ url('admin/crm/reports/details?type=not_answered') . '&' . http_build_query(request()->except('type')) }}">
					<div class="card custom-card">
						<div class="card-body text-center">
						 
							
							<div class='textI'>
						        <div class='cardText'>
        							<h2 class="">  {{$n_calls->where('sent','not_answered')->count()}} </h2>
        							<p class=""> {{trans('home.n_calls').' '.trans('home.didnt_answered')}} </p>
						        </div>
						        <div class='cardIcon'>
                                    <i class="fal fa-phone-slash"></i>
						        </div>
						    </div>
						    <div class='sinceCard'>
						        <span class=' text-success'>  <!-- text-danger for up  -->
						           
						            <!--<i class="fal fa-arrow-down"></i>-->
						            <i class="fal fa-arrow-up"></i>
						             5
						        </span>
						        <small class='text-dark'> الشهر السابق </small>
						    </div>
						    
						</div>
					</div>
				</a>
			</div>
			
			 <!-- count every status -->
            <div class="col-12">
				<div class="card custom-card">
					<div class="card-body text-center d-flex gap-5 Align-items-center">
						<h3 class="mb-0">{{__('home.meetings_types')}}</h3>
					    @foreach($n_meetings_types as $n_meetings_type)
    						    <div class="d-flex gap-3 border border-success rounded p-2 align-items-center">
        							<p class="mb-1 text-muted">
                		                <a href="{{ url('admin/crm/reports/details?type=meeting_'.$n_meetings_type->meeting_type) . '&' . http_build_query(request()->except('type')) }}">
                                            {{ __('home.' . $n_meetings_type->meeting_type) }}
                                        </a>

    							    </p>
        							<h3 class="mb-0">{{$n_meetings_type->count}}</h3>
    						    </div>
					    @endforeach
					</div>
				</div>
			</div>
			 <!-- count every status -->
           
			 
			<div class="row">
				<h3 class="mt-4 mb-3">{{__('home.client_status')}}</h3>
			    @foreach($status_counts as $status_count)
					    <div class="col-lg-3 col-sm-6 col-md-4">
                            <a href="{{ url('admin/crm/reports/details?type=status_data&status_id='.$status_count->id) . '&' . http_build_query(request()->except('type')) }}">
    					        <div class='card custom-card'>
    					            <div class='card-body'>
            							<p class="mb-1 text-muted">
            							        
    		                                
        							    </p>
            							<h3 class="mb-0"></h3>
            							
            							<div class='textI'>
            						        <div class='cardText'>
                    							<h2 class=""> {{$status_count->clients_count}} </h2>
                    							<p class=""> {{$status_count->{'name_'.$lang} }} </p>
            						        </div>
            						        <div class='cardIcon'>
            						            <i class="fal fa-user"></i>
            						        </div>
            						    </div>
            						    <div class='sinceCard'>
            						        <span class=' text-success '>  <!-- text-danger for down  -->
            						            
            						            <!--<i class="fal fa-arrow-down"></i>-->
            						            <i class="fal fa-arrow-up"></i>
            						            3
            						        </span>
            						        <small class='text-dark'> الشهر السابق </small>
            						    </div>
    						    
    						    
    					            </div>
    					        </div>
					        </a>
					    </div>
			    @endforeach
			</div>
			 
		 
			
			
        </div>
        <!-- End Row -->
    </div>
@endsection
