@extends('layouts.admin')
<title>{{trans('home.'.$status).' | '.trans('home.crm')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm')}}</h2>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.'.$status)}}</h2>
            </div>
            <div class="row btn btn-list gap-3 mx-3">
                <a href="{{url('admin/crm/reports')}}"><button class="btn ripple btn-primary">
                    {{trans('home.reports')}}</button> 
                </a>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th>{{trans('home.id')}}</th>
                                    <th class="wd-20p">{{trans('home.client')}}</th>
                                    <th class="wd-25p">{{trans('home.meeting_type')}}</th>
                                    <th class="wd-25p">{{trans('home.title')}}</th>
                                    <th class="wd-25p">{{trans('home.detials')}}</th>
                                    <th class="wd-25p">{{trans('home.date')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($meetings as $meeting)
                                    <tr id="{{$meeting->id}}">
                                        <td> {{$meeting->id}}</td>
                                        <td> {{$meeting->clientSms?->client->name}}</td>
                                        <td> {{__('home.'.$meeting->meeting_type)}}</td>
                                        <td> {{$meeting->title}}</td>
                                        <td> {{$meeting->note}}</td>
                                        <td> {{$meeting->date}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
