@extends('layouts.admin')
<title>{{$status.' | '.trans('home.crm')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm')}}</h2>
                <h2 class="main-content-title tx-24 mg-b-5">{{$status}}</h2>
            </div>
            <div class="row btn btn-list gap-3 mx-3">
                <a href="{{url('admin/crm/reports')}}"><button class="btn ripple btn-primary">
                    {{trans('home.reports')}}</button> 
                </a>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th>{{trans('home.id')}}</th>
                                    <th class="wd-20p">{{trans('home.client')}}</th>
                                    <th class="wd-25p">{{trans('home.phone')}}</th>
                                    <th class="wd-25p">{{trans('home.detials')}}</th>
                                    <th class="wd-25p">{{trans('home.answered').' / '.trans('home.didnt_answered')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($calls as $call)
                                    <tr id="{{$call->id}}">
                                        <td> {{$call->id}}</td>
                                        <td> {{$call->client->name}}</td>
                                        <td> {{$call->sent_to}}</td>
                                        <td> {{$call->message}}</td>
                                        <td> {{__('home.'.$call->sent)}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
