@extends('layouts.admin')
<title>{{trans('home.my_tasks')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm')}}</h2>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.my_tasks')}}</h2>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                     <div class="d-flex btn btn-list gap-3 m-3">
                        <a href="javascript:void(0)" class="filter_type" data-type="show_all">
                            <button class="btn ripple btn-primary">{{trans('home.show_all')}}</button>
                        </a>
                        <a href="javascript:void(0)" class="filter_type" data-type="today_task">
                            <button class="btn ripple btn-primary">{{trans('home.today_task')}}</button>
                        </a>
                        <a href="javascript:void(0)" class="filter_type" data-type="delayed_task">
                            <button class="btn ripple btn-primary">{{trans('home.delayed_task')}}</button>
                        </a>
                        <a href="javascript:void(0)" class="filter_type" data-type="next_task">
                            <button class="btn ripple btn-primary">{{trans('home.next_task')}}</button>
                        </a>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th>{{trans('home.task_status')}}</th>
                                    <th>{{trans('home.priority')}}</th>
                                    <th>{{trans('home.date')}}</th>
                                    <th>{{trans('home.time')}}</th>
                                    <th>{{trans('home.task_type')}}</th>
                                    <th>{{trans('home.client')}}</th>
                                    <th>{{trans('home.phone')}}</th>
                                    <th>{{trans('home.whatsapp')}}</th>
                                    <th>{{trans('home.email')}}</th>
                                    <th>{{trans('home.note')}}</th>
                                    <th>{{trans('home.actions')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($my_tasks as $my_task)
                                    <tr id="{{$my_task->id}}" class="{{ implode(' ', $my_task->type)}} task_record">
                                        <td>
                                            <span class=" badge px-3 py-1 rounded
                                            {{$my_task->status === 'current'?'badge-warning ':($my_task->status === 'delayed'?'badge-danger':'badge-success')}}">
                                                {{ __('home.'.$my_task->status) }}
                                            </span>
                                        </td>
                                        <td> {{__('home.'.$my_task->priority)}}</td>
                                        <td> {{$my_task->date}}</td>
                                        <td>{{$my_task->time? \Carbon\Carbon::createFromFormat('H:i', $my_task->time)->format('h:i A') :''}}</td>
                                        <td> {{$my_task->task_type}}</td>
                                        <td> {{$my_task->crm_sms->client?->name}}</td>
                                        <td> {{$my_task->crm_sms->client->phone??$my_task->crm_sms->client?->phone2}}</td>
                                        <td> {{$my_task->crm_sms->client?->whatsapp}}</td>
                                        <td> {{$my_task->crm_sms->client?->email}}</td>
                                        <td> {{$my_task->note}}</td>
                                        <td> 
                                            <a href="{{route('make_task_comlpeted',$my_task->id)}}" style="color: white !important;"
                                                class="{{$my_task->status=="completed"?'d-none':''}} btn btn-sm btn-success text-nowrap" >
                                                 {{ trans('home.mark_as_completed') }}
                                            </a>
                                            <a href="javascript:void(0)" data-task_id="{{$my_task->id}}"
                                                class="{{$my_task->status=="completed"?'d-none':''}} delay_task m-2 btn btn-sm btn-danger text-nowrap" >
                                                 {{ trans('home.mark_as_delayed') }}
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
    <div class="modal fade" id="delay_task_Modal" tabindex="-1" aria-labelledby="paymentModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST" action="{{route('delay_task')}}">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title">{{__('home.mark_as_delayed')}}</h5>
                        <button type="button" class="btn-close me-auto ms-0" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body row">
                        <input type="hidden" name="task_id" id="task_id">
                        <div class="form-group col-6 ">
                            <label for="date" class="col-form-label">@lang('home.date'):</label>
                            <input class="form-control" type="date"  name="date" id="date" min="{{ date('Y-m-d') }}" required></input>
                        </div>
                        <div class="form-group col-6 ">
                            <label for="time" class="col-form-label">@lang('home.time'):</label>
                            <input class="form-control" type="time"  name="time" id="time"  ></input>
                        </div>
                        <div class="form-group col-lg-6 ">
                            <label for="notify_date" class="col-form-label">@lang('home.notify_date'):</label>
                            <input class="form-control" type="date"  name="notify_date" id="notify_date" min="{{ date('Y-m-d') }}" required></input>
                        </div>
                        <div class="form-group col-lg-6 ">
                            <label for="notify_time" class="col-form-label">@lang('home.notify_time'):</label>
                            <input class="form-control" type="time"  name="notify_time" id="notify_time"  ></input>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit"    class="btn btn-primary m-auto">{{ trans('home.update') }}</button>
                        <button type="button" class="btn btn-secondary m-auto" data-bs-dismiss="modal">{{ trans('home.close') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        $('.delay_task').on('click',function () {
            let task_id = $(this).data('task_id');
    
            // Populate modal with data
            $('#task_id').val(task_id);
            // Show modal
            $('#delay_task_Modal').modal('show');
        });
    </script>
    
    <script>
        $('.filter_type').click(function(){
            var type = $(this).data('type');
            $('.filter_type button').removeClass('btn-info').addClass('btn-primary');
            $(this).find('button').removeClass('btn-primary').addClass('btn-info');
            
            if(type == "today_task"){
                $('.task_record').addClass('d-none'); 
                $('.today').removeClass('d-none'); 
            } 
            else if(type == "delayed_task"){
                $('.task_record').addClass('d-none'); 
                $('.delayed').removeClass('d-none'); 
            }
            else if(type == "next_task"){
                $('.task_record').addClass('d-none'); 
                $('.next').removeClass('d-none'); 
            }
            else if(type == "show_all"){
                $('.task_record').removeClass('d-none'); 
            }
        });
    </script>
@endsection
