@extends('layouts.admin')
<title>{{trans('home.my_meetings')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm')}}</h2>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.my_meetings')}}</h2>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                     <div class="d-flex btn btn-list gap-3 m-3">
                        <a href="javascript:void(0)" class="filter_type" data-type="show_all">
                            <button class="btn ripple btn-primary">{{trans('home.show_all')}}</button>
                        </a>
                        <a href="javascript:void(0)" class="filter_type" data-type="today_meetings">
                            <button class="btn ripple btn-primary">{{trans('home.my_meetings')}}</button>
                        </a>
                        </a>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th>{{trans('home.client')}}</th>
                                    <th>{{trans('home.meeting_type')}}</th>
                                    <th>{{trans('home.title')}}</th>
                                    <th>{{trans('home.note')}}</th>
                                    <th>{{trans('home.date')}}</th>
                                    <th>{{trans('home.start_date')}}</th>
                                    <th>{{trans('home.end_date')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($my_meetings as $my_meeting)
                                    <tr id="{{$my_meeting->id}}" class=" @if($my_meeting->parsed_date==$today) today_meetings @endif task_record">
                                        <td> {{$my_meeting->clientSms?->client?->name}}</td>
                                        <td> {{__('home.'.$my_meeting->meeting_type)}}</td>
                                        <td> {{$my_meeting->title}}</td>
                                        <td> {{$my_meeting->note}}</td>
                                        <td> {{$my_meeting->date}}</td>
                                        <td>{{$my_meeting->start_date? \Carbon\Carbon::createFromFormat('H:i', $my_meeting->start_date)->format('h:i A') :''}}</td>
                                        <td>{{$my_meeting->end_date? \Carbon\Carbon::createFromFormat('H:i', $my_meeting->end_date)->format('h:i A') :''}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
@section('script')
    <script>
        $('.delay_task').on('click',function () {
            let task_id = $(this).data('task_id');
    
            // Populate modal with data
            $('#task_id').val(task_id);
            // Show modal
            $('#delay_task_Modal').modal('show');
        });
    </script>
    
    <script>
        $('.filter_type').click(function(){
            var type = $(this).data('type');
            $('.filter_type button').removeClass('btn-info').addClass('btn-primary');
            $(this).find('button').removeClass('btn-primary').addClass('btn-info');
            
            if(type == "today_meetings"){
                $('.task_record').addClass('d-none'); 
                $('.today_meetings').removeClass('d-none'); 
            }
            else{
                $('.task_record').removeClass('d-none'); 
            }
        });
    </script>
@endsection
