@extends('layouts.admin')
<title>{{trans('home.home').' | '.trans('home.crm')}}</title>

@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm')}}</h2>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.home')}}</h2>
            </div>

        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
			<!-- Calls-->
			<div class="col-sm-6 col-md-4 col-xl-3">
			    <a>
					<div class="card custom-card">
						<div class="card-body text-center">
							<p class="headCardHome">عدد المكالمات اليومى</p>
							<h3 class="headCardNum">{{$numbers['call_daily'].' / ' .$user->target?->call_daily}}</h3>
						</div>
					</div>
				</a>
			</div>
			
			<div class="col-sm-6 col-md-4 col-xl-3">
			    <a>
					<div class="card custom-card">
						<div class="card-body text-center">
							<p class="headCardHome">عدد المكالمات الشهرى</p>
							<h3 class="headCardNum">{{$numbers['call_monthly'].' / ' .$user->target?->call_monthly}}</h3>
						</div>
					</div>
				</a>
			</div>
			
			<!-- meetings-->
			
			<div class="col-sm-6 col-md-4 col-xl-3">
			    <a>
					<div class="card custom-card">
						<div class="card-body text-center">
							<p class="headCardHome">عدد الاجتماعات اليومى</p>
							<h3 class="headCardNum">{{$numbers['meeting_daily'].' / ' .$user->target?->meeting_daily}}</h3>
						</div>
					</div>
				</a>
			</div>
			<div class="col-sm-6 col-md-4 col-xl-3">
			    <a>
					<div class="card custom-card">
						<div class="card-body text-center">
							<p class="headCardHome">عدد الاجتماعات الشهرى</p>
							<h3 class="headCardNum">{{$numbers['meeting_monthly'].' / ' .$user->target?->meeting_monthly}}</h3>
						</div>
					</div>
				</a>
			</div>
			<div class="col-sm-6 col-md-4 col-xl-3">
			    <a>
					<div class="card custom-card">
						<div class="card-body text-center">
							<p class="headCardHome"> @lang('home.budget_monthly')</p>
							<h3 class="headCardNum">{{$numbers['budget_monthly'].' / ' .$user->target?->budget_monthly}}</h3>
						</div>
					</div>
				</a>
			</div>
            
			<div class="col-sm-6 col-md-4 col-xl-3">
			    <a>
					<div class="card custom-card">
						<div class="card-body text-center">
							<p class="headCardHome"> @lang('home.budget_yearly')</p>
							<h3 class="headCardNum">{{$numbers['budget_yearly'].' / ' .$user->target?->budget_yearly}}</h3>
						</div>
					</div>
				</a>
			</div>
            
			
        </div>
        <!-- End Row -->
        
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="exportexample_witout_source">
                                <thead>
                                    <tr>
                                        <th class="wd-20p">تاريخ </th>
                                        <th class="wd-20p">عدد المكالمات الشهرى </th>
                                        <th class="wd-20p">عدد الاجتماعات الشهرى </th>
                                        <th class="wd-20p">@lang('home.budget_monthly') </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($monthlyStatistics as $year => $months)
                                        @foreach($months as $month => $statistics)
                                            <tr>
                                                <td>{{ \Carbon\Carbon::createFromFormat('m', $month)->format('m').'/'.$year }}</td>
                                                <td>{{ $statistics['total_calls'] }}</td>
                                                <td>{{ $statistics['total_meetings'] }}</td>
                                                <td>{{ number_format($statistics['total_invoice_value'], 2) }}</td>
                                            </tr>
                                        @endforeach
                                    
                                        <!-- Calculate yearly totals -->
                                        <tr style="background: #ff7620 !important; color:white !important;">
                                            <th>Total for {{ $year }}</th>
                                            <th>{{ collect($months)->sum('total_calls') }}</th>
                                            <th>{{ collect($months)->sum('total_meetings') }}</th>
                                            <th>{{ number_format(collect($months)->sum('total_invoice_value'), 2) }}</th>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
					    </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
        
        
    </div>
@endsection
