@extends('layouts.admin')
<title>{{trans('home.crm_employess')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm_employess')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.crm_employess')}}</li>
                </ol>
            </div>

            <div class="btn btn-list">
                <a href="{{url('admin/crm/crm-employess/create')}}" class="btn ripple btn-primary"><i class="fe fe-plus"></i> {{trans('home.add')}}</a>
                <a href="javascript:void(0)" id="btn_delete_crm_employess" class="btn ripple btn-danger text-white"><i class="fe fe-x"></i> {{trans('home.delete')}}</a>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.users')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" id="checkAll"/></th>
                                        <th>{{trans('home.id')}}</th>
                                        <th>{{trans('home.name')}}</th>
                                        <th>{{trans('home.email')}}</th>
                                        <th>{{trans('home.phone')}}</th>
                                        <th>{{trans('home.type')}}</th>
                                        <th>{{trans('home.target_type')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($users as $user)
                                        <tr id="{{$user->id}}">
                                            <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$user->id}}"/></td>
                                            <td><a href="{{ url('admin/crm/crm-employess/show/'.$user->id) }}">{{$user->id}}</a></td>
                                            <td><a href="{{ url('admin/crm/crm-employess/show/'.$user->id) }}">{{$user->f_name.' '.$user->l_name}}</a></td>
                                            <td><a href="{{ url('admin/crm/crm-employess/show/'.$user->id) }}">{{$user->email}}</a></td>
                                            <td><a href="{{ url('admin/crm/crm-employess/show/'.$user->id) }}">{{$user->phone}}</a></td>
                                            <td><a href="{{ url('admin/crm/crm-employess/show/'.$user->id) }}">{{$user->type}}</a></td>
                                            <td><a href="{{ url('admin/crm/crm-employess/show/'.$user->id) }}">{{$user->target?->name }}</a></td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>    
					    </div>
                    </div>                    
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
@section('script')
    <script>
          $(document).ready(function(){
            $('#btn_delete_crm_employess').click(function(){
                var id = [];
                $('.tableChecked:checked').each(function(i){
                    id[i] = $(this).val();
                });
                if(id.length === 0) //tell you if the array is empty
                {
                    alert("Please Select atleast one checkbox");
                }
                else
                {
                    $.confirm({
                        title: '{{__('home.Are you sure you want to delete that ?')}}',
                        content:'',
                        buttons: {
                            confirm: {
                                text: '{{__('home.delete')}}',
                                btnClass: 'btn-red any-other-class',
                                keys: ['enter', 'shift'],
                                action: function(){
                                     $.ajaxSetup({
                                        headers: {
                                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                        }
                                    });
                                
                                    $.ajax({
                                        url: "{{url('admin/crm/crm-employess')}}" + "/" + id,
                                        type: 'DELETE',
                                        success: function () {
                                           location.reload();
                                        }
                                    }); 
                                }
                            },
                            cancel: {
                                text: '{{__('home.cancel')}}',
                                action: function(){
                                    close();
                                }
                            }
                        }
                    });
                }
            });
        });
    </script>
@endsection