@extends('layouts.admin')
<title>{{trans('home.'.$invoice->client->type).' | '.trans('home.crm')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">
                    <a 
                    @if($invoice->client->type=="company")
                        href="{{url('admin/crm/companies/'.$invoice->client_id)}}"
                    @else
                        href="{{url('admin/crm/clients/'.$invoice->client_id)}}"
                    @endif
                    >
                        {{trans('home.'.$invoice->client->type)}} | {{$invoice->client->name}}
                    </a>
                </h2>
                <h2 class="main-content-title tx-24 mg-b-5">رقم الفاتورة : {{$invoice->invoice_number}}</h2>
            </div>

        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div >
                            <img src="{{ Helper::uploadedImagesPath('settings', $configration->app_logo) }}" alt="logo" height="70px">
                        </div>
                        <div class="table-responsive">
                                
        					<div class="row card-footer text-right print_button justify-content-center">
                                <button type="button" class="btn ripple btn-success mb-1 col-4 " onclick="printElement();"><i class="fe fe-printer mr-1"></i> طباعة الفاتورة</button>
                            </div>
                            <div class="gap_div d-none mb-5">
                                
                            </div>
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th>{{trans('home.id')}}</th>
                                        <th class="wd-20p">رقم المعاملة</th>
                                        <th class="wd-20p">قيمة العملية</th>
                                        @if($invoice->client->type=="company")
                                            <th class="wd-20p">{{trans('home.n_clients')}}</th>
                                            <th class="wd-20p">{{trans('home.n_trainings')}}</th>
                                            <th class="wd-25p">{{trans('home.training_loaction')}}</th>
                                            <th class="wd-25p">{{trans('home.duration_days')}}</th>
                                            <th class="wd-25p">{{trans('home.duration_weeks')}}</th>
                                            <th class="wd-25p">{{trans('home.duration_hours')}}</th>
                                        @else
                                            <th class="wd-20p">{{trans('home.trainings')}}</th>
                                        @endif
                                        <th class="wd-25p">ملف الفاتورة</th>
                                        @can('crm-delete-invoice')
                                            <th class="wd-25p">@lang('home.delete')</th>
                                        @endcan
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($items as $item)
                                        <tr id="item-{{$item->id}}">
                                            <td> {{$item->id}} </td>
                                            <td> {{$item->invoice_code}} </td>
                                            <td> {{$item->amount}} </td>
                                            @if($invoice->client->type=="company")
                                            <td> {{$invoice->n_clients??'-'}} </td>
                                            <td> {{$invoice->n_trainings}} </td>
                                            <td> {{$invoice->training_loaction}} </td>
                                            <td> {{$invoice->duration_days??'-'}} </td>
                                            <td> {{$invoice->duration_weeks??'-'}} </td>
                                            <td> {{$invoice->duration_hours??'-'}} </td>
                                            @else
                                            <td> {{$invoice->crm_company_tranining?->training->{'name_'.$lang} }} </td>
                                            @endif
                                            <td><a class="btn btn-primary" target="_blank" href="{{ Helper::uploadedFilesPath('invoices',$item->invoice_file) }}">
                                                    <i class="fe fe-file"></i>
                                                </a>
                                            </td>
                                            @can('crm-delete-invoice')
                                            <td>
                                                <a class="btn btn-primary btn_delete" data-id="{{ $item->id }}">
                                                    @lang('home.delete')
                                                </a>
                                            </td>
                                            @endcan
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
    					</div>
                    </div>
                </div>
            </div>
            <div id="print_dev" class="d-none col-sm-12 col-xl-12 col-lg-12">
                <div class="card  overflow-hidden">
                    <div>
                        <div>
                            <img src="{{ Helper::uploadedImagesPath('settings', $configration->app_logo) }}" alt="logo" height="70px">
                        </div>
                        <div class="gap_div mb-5 mt-5">
                            <table class="table table-bordered text-center">
                                <tbody>
                                    @if($invoice->client->type=="company")
                                        <tr>
                                            <td>عدد الدورات التدريبية</td>
                                            <td> {{$invoice->n_trainings}}</td>
                                            <td>Number of Trainings</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">اسم الشركة </td>
                                            <td> {{$invoice->client->name}}</td>
                                            <td>Name</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">الجوال  </td>
                                            <td> {{$invoice->client->phone??'-'}}</td>
                                            <td>Phone Number</td>
                                        </tr>
                                        <tr>
                                            <td scope="row"> البريد الالكترونى </td>
                                            <td> {{$invoice->client->email}}</td>
                                            <td>Email</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">رسوم الاشتراك</td>
                                            <td> {{$item->amount}}</td>
                                            <td>رسوم الاشتراك</td>
                                        </tr>
                                    @else
                                        <tr>
                                            <td scope="row">الدورة التدريبية</td>
                                            <td> {{$invoice->crm_company_tranining?->training->{'name_'.$lang} }}</td>
                                            <td>Training</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">اسم المتدرب </td>
                                            <td> {{$invoice->client->name}}</td>
                                            <td>Name</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">الهوية  </td>
                                            <td> {{$invoice->client->ssn}}</td>
                                            <td>ID Number</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">الجوال  </td>
                                            <td> {{$invoice->client->phone??'-'}}</td>
                                            <td>Phone Number</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">المؤهل الدراسى  </td>
                                            <td> {{$invoice->client->qualification??'-'}}</td>
                                            <td>Educational Degree</td>
                                        </tr>
                                        <tr>
                                            <td scope="row"> العمل الحالى </td>
                                            <td> {{$invoice->client->job??'-'}}</td>
                                            <td>Current job</td>
                                        </tr>
                                        <tr>
                                            <td scope="row"> البريد الالكترونى </td>
                                            <td> {{$invoice->client->email}}</td>
                                            <td>Email</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">رسوم الاشتراك</td>
                                            <td> {{$item->amount}}</td>
                                            <td>رسوم الاشتراك</td>
                                        </tr>
                                    @endif
                                    
                                </tbody>
                            </table>
                        </div>
                        <h4 class="text-center mt-3">- المعاملات- </h4>
                        
                        <table class="table text-center">
                            <thead>
                                <tr>
                                    <th class="wd-20p">رقم المعاملة</th>
                                    <th class="wd-20p">قيمة العملية</th>
                                    @if($invoice->client->type=="company")
                                        <th class="wd-20p">{{trans('home.n_clients')}}</th>
                                        <th class="wd-25p">{{trans('home.training_loaction')}}</th>
                                        <th class="wd-25p">{{trans('home.duration_days')}}</th>
                                        <th class="wd-25p">{{trans('home.duration_weeks')}}</th>
                                        <th class="wd-25p">{{trans('home.duration_hours')}}</th>
                                    @else
                                        <th class="wd-20p">{{trans('home.trainings')}}</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($items as $item)
                                    <tr id="item-{{$item->id}}">
                                        <td> {{$item->invoice_code}} </td>
                                        <td> {{$item->amount}} </td>
                                        @if($invoice->client->type=="company")
                                        <td> {{$invoice->n_clients??'-'}} </td>
                                        <td> {{$invoice->training_loaction??'-'}} </td>
                                        <td> {{$invoice->duration_days??'-'}} </td>
                                        <td> {{$invoice->duration_weeks??'-'}} </td>
                                        <td> {{$invoice->duration_hours??'-'}} </td>
                                        @else
                                        <td> {{$invoice->crm_company_tranining?->training->{'name_'.$lang} }} </td>
                                        @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
@section('script')
    <!-- Printing -->
   <script>
        function printElement() {
            const printContent = document.getElementById('print_dev').innerHTML;
        
            const originalContent = document.body.innerHTML;
            document.body.innerHTML = printContent;
        
            // Trigger the print dialog
            window.print();
        
            // Restore the original page content
            document.body.innerHTML = originalContent;
             window.location.reload();
        }
    </script>



   <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
   <script>
        $(document).on('click', '.btn_delete', function(e) {
        e.preventDefault();
        
        var itemId = $(this).data('id'); // Get the item ID from the data attribute
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: "btn btn-success",
                cancelButton: "btn btn-danger"
            },
            buttonsStyling: false
        });
        
        swalWithBootstrapButtons.fire({
            title: "{{ __('home.are you sure') }}",
            text: "{{ __('home.to delete this item?') }}",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "{{ __('home.yes') }}, {{ __('home.delete') }}!",
            cancelButtonText: "{{ __('home.no') }}, {{ __('home.cancel') }}!",
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ route('delete_invoice_item', '') }}/" + itemId,
                    type: 'GET',
                    data: {
                        _token: '{{ csrf_token() }}', // Include CSRF token
                        id: itemId
                    },
                    success: function(response) {
                        swalWithBootstrapButtons.fire({
                            title: "{{ __('home.deleted') }}!",
                            text: "{{ __('home.the item has been deleted') }}.",
                            icon: "success"
                        });
                        // Remove the row of the deleted item or refresh the table
                        $('tr#item-' + itemId).fadeOut('slow');
                        
                    },
                    error: function(response) {
                        swalWithBootstrapButtons.fire({
                            title: "{{ __('home.error') }}!",
                            text: "{{ __('home.something went wrong') }}.",
                            icon: "error"
                        });
                    }
                });
            }
        });
    });
   </script>
@endsection
