@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.details').' | '.$company->name}}</title>
@endsection
@section('style')
    <style>
        .select2-container {
            z-index: 1050 !important; /* Make sure it's higher than the modal (default is 1050) */
        }
        
        .select2-dropdown {
            z-index: 1051 !important; /* Ensure the dropdown appears above the modal */
        }
    </style>
@endsection
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.details').' | '.$company->name}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('admin/crm/companies')}}">{{trans('home.companies')}}</a></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        


        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                
                        <div class="row">
                            
                            <div class="col-lg-12 mb-3">
                                <div class="card custom-card">
                                    <div class='card-body'>
                                        <h3 class="mb-3">
                                            {{$company->name}}
                                        </h3>
                                       
                                        <p>نوع الشركه  : {{__('home.'.$company->company_data?->category)}}</p>
                                        <p>{{trans('home.phone')}} : {{$company->phone}}</p>
                                        @if($company->whatsapp)<p>{{trans('home.whatsapp')}} : {{$company->whatsapp??'-'}}</p>@endif
                                        <p>{{trans('home.come_from')}} :{{$company->source?->{'name_'.$lang} }}</p>
                                        <p>{{trans('home.responsible_employee')}} : {{$company->responsible_employee? $company->responsible_employee?->user?->name() :'-' }}</p>
                                        <p>{{trans('home.responsible_contact_person')}} : {{$company->company_data? $company->company_data->responsible_contact_person:'-'  }}</p>
                                        <p>وظيفة المسؤول : {{$company->company_data? $company->company_data->job:'-'  }}</p>
                                        <div class="d-flex gap-2 justify-content-center">
                                            <a href="{{url('admin/crm/companies/'.$company->id.'/edit')}}" class="btn btn-primary crmEditBtn text-white">
                                                 {{ trans('home.edit') }}
                                            </a>
                                           
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            
                            
                            <div class='col-lg-12'>
                                <ul class="nav nav-tabs d-flex justify-content-center crmTabs mb-3" id="myTab" role="tablist">
                                  <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="contact-tab" data-bs-toggle="tab" data-bs-target="#contact" type="button" role="tab" aria-controls="contact" aria-selected="true">
                                         متدربين الشركة   
                                    </button>
                                  </li>
                                  <li class="nav-item" role="presentation">
                                    <button class="nav-link " id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="false">
                                        @lang('home.financial')
                                        </button>
                                  </li>
                                  <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">
                                        @lang('home.activity')
                                    </button>
                                  </li>
                                
                                </ul>
                                
                                
                                
                                
                                <div class='card custom-card'>
                                <div class='card-body'>
                                    
                                    <div class="tab-content" id="myTabContent">
                                        
                                        <div class="tab-pane fade show active" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                                            
                                            
                                            <a href="{{url('admin/crm/add-company-client/'.$company->id)}}" class="btn btn-primary text-white mb-4">
                                         اضافة متدرب للشركة
                                    </a>
                                    <div class="table-responsive">
                                        <table class="table" id="exportexample">
                                            <thead>
                                                <tr>
                                                    <th><input type="checkbox" id="checkAll"/></th>
                                                    <th>{{trans('home.id')}}</th>
                                                    <th>{{trans('home.name')}}</th>
                                                    <th>{{trans('home.phone')}}</th>
                                                    <th>{{trans('home.ssn')}}</th>
                                                    <th>{{trans('home.email')}}</th>
                                                    <th>{{trans('home.area')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($company->clients as $client)
                                                    <tr id="{{$client->id}}">
                                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$client->id}}" /> </td>
                                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->id}}</a> </td>
                                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->name}}</a> </td>
                                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->phone}}</a> </td>
                                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->ssn}}</a> </td>
                                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->email}}</a> </td>
                                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->area?->{'name_'.$lang} }}</a> </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                					</div>
                                        
                                        
                                    </div>
                                    
                                    <div class="tab-pane fade " id="home" role="tabpanel" aria-labelledby="home-tab">
                                        
                                        <div class="d-flex gap-2 justify-content-center m-2">
                                            <a href="javascript:void(0)" data-bs-toggle="modal" 
                                                    data-bs-target="#add_new_payment_modal" data-client_training_id="{{$company->id}}"  
                                                    class="add_new_payment btn btn-primary text-white col-lg-8">
                                                 {{ trans('home.add_new_payment') }}
                                            </a>
                                        </div>
                                        
                                        <div class="row gap-2 justify-content-center">
                                            @foreach($company->invoices as $invoice)
                                              <a class="btn btn-primary col-10" data-bs-toggle="collapse" href="#collapseExample_{{$invoice->id}}" role="button" aria-expanded="false" aria-controls="collapseExample_{{$invoice->id}}">
                                                {{'رقم الفاتورة' .' : '. $invoice->invoice_number }}
                                                <span>{{__('home.'.$invoice->invoice_status)}}</span>
                                              </a>
                                                <div class="mt-4">
                                                        <div class="collapse" id="collapseExample_{{$invoice->id}}">
                                                          <div class="card card-body">
                                                                <div>
                                                                    <span class="border border-secondary rounded px-2">
                                                                        {{__('home.price').' : '.$invoice->invoice_value.' '.__('home.SAR')}}
                                                                    </span>
                                                                    @if($invoice->discount)
                                                                        <span class="border border-secondary rounded px-2">
                                                                                 {{__('home.discount').' : '}}
                                                                                 <span class="text-decoration-line-through">
                                                                                     {{$invoice->discount}}
                                                                                 </span>
                                                                        </span>
                                                                    @endif
                                                                    <h6 class="m-3">
                                                                        <div class="mt-3">
                                                                            <span class="border border-secondary rounded px-2">
                                                                                {{ __('home.collected') . ' : ' . $invoice->items->sum('amount') . ' ' . __('home.SAR') }}
                                                                            </span>
                                                                        </div>
                                                                    </h6>
                                                                    @if($invoice->invoice_status!="collected")
                                                                        <a href="javascript:void(0)" data-invoice_id="{{$invoice->id}}" data-invoice_number="{{$invoice->invoice_number}}"
                                                                        class="add_invoice_item btn btn-primary text-white col-lg-8">
                                                                             اضافة عملية جديدة
                                                                        </a>
                                                                    @endif
                                                                    <table class="table">
                                                                        <thead>
                                                                            <tr>
                                                                                <th>رقم العملية</th>
                                                                                <th>{{trans('home.amount')}}</th>
                                                                                <th>{{trans('home.details')}}</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            @forelse($invoice->items as $item)
                                                                                <tr data-id="{{$item->id}}" data-type="{{$item->type}}" data-amount="{{$item->amount}}" data-invoice-url="">
                                                                                    <td><a href="{{ url('admin/crm/invoice/'.$invoice->id) }}">{{$item->invoice_code}}</a></td>
                                                                                    <td><a href="{{ url('admin/crm/invoice/'.$invoice->id) }}">{{$item->amount}}</a></td>
                                                                                    <td><a class="btn btn-primary " href="{{ url('admin/crm/invoice/'.$invoice->id) }}">{{trans('home.details')}}</a></td>
                                                                                   
                                                                                </tr>
                                                                            @empty
                                                                                <tr>
                                                                                    <td> -</td>
                                                                                    <td> -</td>
                                                                                    <td> -</td>
                                                                                </tr>
                                                                            @endforelse
                                                                        </tbody>
                                                                    </table>
                                                                    @can('crm-delete-invoice')
                                                                    <td>
                                                                        <a class="btn btn-primary btn_delete" href="{{ route('delete_invoice',$invoice->id) }}" data-id="{{ $invoice->id }}">
                                                                           حذف الفاتورة 
                                                                        </a>
                                                                    </td>
                                                                    @endcan
                                                                    @can('crm-discount-invoice')
                                                                    <td>
                                                                        <a class="btn btn-info" 
                                                                            data-bs-toggle="modal" 
                                                                            data-bs-target="#edit_discount"
                                                                            href="{{ route('delete_invoice',$invoice->id) }}" data-id="{{ $invoice->id }}">
                                                                           تعديل الخصم
                                                                        </a>
                                                                        <a class="btn btn-success" 
                                                                            href="{{ url('admin/crm/invoice/'.$invoice->id) }}" >
                                                                                {{trans('home.generate_invoice')}}
                                                                        </a>
                                                                        
                                                                                 <!--modal add-meeting-result app-->
                                                                        <div class="modal fade" id="edit_discount" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                          <div class="modal-dialog" role="document">
                                                                            <form method="post" action="{{route('edit_discount',$invoice->id) }}" >
                                                                                @csrf
                                                                                <div class="modal-content">
                                                                                    <div class="modal-header">
                                                                                        <h5 class="modal-title" id="exampleModalLabel"> تعديل الخصم  </h5>
                                                                                        <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                                                                                          <span aria-hidden="true">&times;</span>
                                                                                        </button>
                                                                                    </div>
                                                                                    <div class="modal-body">
                                                                                        <div class="form-group col-lg-8 m-auto">
                                                                                            <label for="discount" class="col-form-label">@lang('home.discount'):</label>
                                                                                            <input class="form-control" type="text" value="{{$invoice->discount}}"  name="discount"  required>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="modal-footer">
                                                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">@lang('home.cancel')</button>
                                                                                        <button type="submit" class="btn btn-primary">@lang('home.save') </button>
                                                                                    </div>
                                                                                </div>
                                                                            </form>
                                                                          </div>
                                                                        </div>
                                                                    </td>
                                                                    @endcan
                                                                    
                                                                     <!--add_invoice_item -->
                                                                    <div class="modal fade" id="paymentModal" tabindex="-1" aria-labelledby="paymentModalLabel" aria-hidden="true">
                                                                        <div class="modal-dialog">
                                                                            <form  action="{{route('invoice_store')}}" method="POST" enctype="multipart/form-data">
                                                                                @csrf
                                                                                <input type="hidden" name="invoice_id" id="invoice_id" >
                                                                                <div class="modal-content">
                                                                                    <div class="modal-header">
                                                                                        <h5 class="modal-title">#رقم العملية</h5>
                                                                                        <h5 class="modal-title mx-2" id="paymentModalLabel"></h5>
                                                                                        <button type="button" class="btn-close me-auto ms-0" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                                    </div>
                                                                                    <div class="modal-body row">
                                                                                        <h3 class="mb-5">اضافة عملية جديدة</h3>
                                                                                        <div class="form-group col-lg-6 ">
                                                                                            <label for="invoice_number" class="col-form-label">رقم العملية:</label>
                                                                                            <input class="form-control" type="number"   name="invoice_number"  required>
                                                                                        </div>
                                                                                        <div class="form-group col-lg-6 ">
                                                                                            <label for="amount" class="col-form-label">@lang('home.amount'):</label>
                                                                                            <input class="form-control" type="text"   name="amount"  required>
                                                                                        </div>
                                                                                        <div class="form-group col-lg-6" id="invoice_file">
                                                                                            <label for="invoice_file" class="col-form-label">ملف الفاتورة:</label>
                                                                                            <input class="form-control" type="file" name="invoice_file" required>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="modal-footer">
                                                                                        <button type="submit" class="btn btn-primary" >{{ trans('home.save') }}</button>
                                                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ trans('home.close') }}</button>
                                                                                    </div>
                                                                                </div>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                            					</div>
                                                            </div>
                                                        </div>                       
                                                </div>
                                            @endforeach
                                        </div>
                                        
                                    </div>
                                    
                                    <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                                        
                                        
                                        <div class="row gap-2 justify-content-center mb-3">
                                        <a href="javascript:void(0)" data-bs-toggle="modal" 
                                                data-bs-target="#send_call_modal" class="send_call btn btn-primary text-white col-auto">
                                             <i class="fe fe-plus mx-2"></i>
                                             {{ trans('home.send_call') }}
                                        </a>
                                        {{--
                                        <a href="javascript:void(0)" data-bs-toggle="modal" 
                                                data-bs-target="#send_sms_modal" class="send_sms btn btn-primary text-white col-3">
                                             <i class="fe fe-plus mx-2"></i>
                                             {{ trans('home.send_sms') }}
                                        </a>
                                        <a href="javascript:void(0)"  data-bs-toggle="modal" 
                                                data-bs-target="#send_whatsapp_modal" class="btn btn-primary text-white col-3">
                                             <i class="fe fe-plus mx-2"></i>
                                             {{ trans('home.send_whatsapp') }}
                                        </a>
                                        --}}
                                        <a href="javascript:void(0)" data-bs-toggle="modal" 
                                                data-bs-target="#send_email_modal" class="btn btn-primary text-white col-auto">
                                             <i class="fe fe-plus mx-2"></i>
                                             {{ trans('home.send_email') }}
                                        </a>
                                        <a href="javascript:void(0)"  data-bs-toggle="modal" 
                                                data-bs-target="#add_meating_modal" class="btn btn-primary text-white col-4">
                                             <i class="fe fe-plus mx-2"></i>
                                             اضافة اجتماع
                                        </a>
                                        <a href="javascript:void(0)"   data-bs-toggle="modal" 
                                                data-bs-target="#add_task_modal"  class="btn btn-primary text-white col-4">
                                             <i class="fe fe-plus mx-2"></i>
                                             {{ trans('home.add_task') }}
                                        </a>
                                    </div>
                                        <div class="row justify-content-center m-2 overflow-auto" style="max-height: 350px;">
                                        @forelse($company->messages as $message)
                                        @if($message->type=="meeting")
                                            <div class="card custom-card mb-3">
                                                <div class="row g-0 p-3">
                                                    <!-- Left column: Message and Sent To -->
                                                    <div class="row col-md-7 align-items-center justify-content-center card card-body m-2">
                                                        <span class=" px-2 py-1">{{$message->meeting->title}}</span>
                                                        <p>{{__('home.note').' : '.$message->meeting->note}}</p>
                                                        
                                                        <div class="row gap-2 m-2 align-items-center">
                                                            <span class="border border-secondary px-3 py-1 ">
                                                                {{Carbon\Carbon::parse($message->meeting->date)->translatedFormat('d F Y ', $lang)}}
                                                            </span>
                                                            <span class="border border-secondary px-3 py-1 ">
                                                               {{  date('h:i A', strtotime($message->meeting->start_date)) .' : '. date('h:i A', strtotime($message->meeting->end_date)) }}
                                                            </span>
                                                            @if($message->meeting->result)
                                                                <span class="border border-secondary px-3 py-1 ">
                                                                    <span class="row">
                                                                        <span class="bg-secondary text-white rounded py-1">@lang('home.meeting_result')</span>
                                                                       <span>
                                                                        {{  $message->meeting->result }}
                                                                       </span>
                                                                    </span>
                                                                </span>
                                                            @endif
                                                            
                                                        </div>
                                                        
                                                        @if($message->meeting->meeting_type=="client_site")
                                                            <a target="_blank" href="{{$message->meeting->location}}" class="mt-2">
                                                                <span class="bg-secondary rounded text-white px-2 py-1 mb-2">{{__('home.'.$message->meeting->meeting_type)}}</span>
                                                            </a>
                                                            <span class="bg-secondary rounded text-white px-2 py-1 mt-2">
                                                                {{$message->meeting->address}}
                                                            </span>
                                                        @elseif($message->meeting->meeting_type=="online")
                                                            <a target="_blank" href="{{$message->meeting->zoom_link}}" class="mt-2">
                                                                <span class="bg-secondary rounded text-white px-2 py-1 mb-2">{{__('home.'.$message->meeting->meeting_type)}}</span>
                                                            </a>
                                                             <span class="border border-secondary px-3 py-1  mt-2">
                                                                {{$message->meeting->zoom_link}}
                                                            </span>
                                                        @endif
                                                    
                                                    </div>
                                        
                                                    <!-- Right column: Type, Date, Sender -->
                                                    <div class="col-md-4 text-left">
                                                        <h6 class="mt-3">
                                                            <span class="border border-secondary text-dark rounded px-3">{{__('home.meeting')}}</span>
                                                        </h6>
                                                        <h6 class="border border-secondary mt-3  rounded p-1">
                                                            <span>{{$message->created_at->translatedFormat('d F Y ', $lang)}}</span>
                                                            <span class="px-3">{{$message->created_at->format('h:i A')}}</span>
                                                        </h6>
                                                        <h6 class="mt-3">
                                                            <span class="border border-secondary text-dark rounded px-3">{{$message->sent=="sent"?__('home.sent'):__('home.saved')}}</span>
                                                        </h6>
                                                        <a href="javascript:void(0)" data-id="{{$message->id}}"  class="btn btn-danger text-white delete-btn">
                                                             {{ trans('home.delete') }}
                                                             <i class="fas fa-trash" aria-hidden="true"></i>
                                                        </a>
                                                        @if(!$message->meeting->result)
                                                            <a href="javascript:void(0)" data-meeting_id="{{$message->meeting->id}}"
                                                                data-bs-toggle="modal" 
                                                                data-bs-target="#add_meeting_result"
                                                                class="btn btn-success text-white add-meeting-result">
                                                                @lang('home.add_new_result')
                                                            </a>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        @elseif($message->type=="task")
                                          <div class="card custom-card mb-3">
                                                    <div class="row g-0 p-3">
                                                        <!-- Left column: Message and Sent To -->
                                                        <div class="row col-md-7 align-items-center card card-body m-2">
                                                            <p>{{$message->task->note}}</p>
                                                            <span class="bg-secondary rounded text-white px-2 py-1">{{$message->task->task_type}}</span>
                                                        </div>
                                                        
                                                        <!-- Right column: Type, Date, Sender -->
                                                        <div class="col-md-4 text-left">
                                                            <h6 class="text-white mt-3">
                                                                <span class="border border-secondary text-dark rounded px-3">{{__('home.task_type').': '.__('home.'.$message->type)}}</span>
                                                            </h6>
                                                            <h6 class="border border-secondary mt-3  rounded p-1">
                                                                <span>{{$message->created_at->translatedFormat('d F Y ', $lang)}}</span>
                                                                <span class="px-3">{{$message->created_at->format('h:i A')}}</span>
                                                            </h6>
                                                            <h6 class="text-white mt-3">
                                                                <span class="border border-secondary text-dark rounded px-3">{{__('home.'.$message->task->priority)}}</span>
                                                            </h6>
                                                            <a href="javascript:void(0)" data-id={{$message->id}}  class="btn btn-danger text-white delete-btn">
                                                                 {{ trans('home.delete') }}
                                                                 <i class="fas fa-trash" aria-hidden="true"></i>
                                                            </a>
                                                        </div>
                                                        
                                                    </div>
                                                </div>
                                        @elseif($message->type=="call")
                                            <div class="card custom-card mb-3">
                                                    <div class="row g-0 p-3">
                                                        <!-- Left column: Message and Sent To -->
                                                        <div class="row col-md-7 align-items-center card card-body m-2">
                                                            <p>{{$message->message}}</p>
                                                            <span class="bg-secondary rounded text-white px-2 py-1">
                                                                {{$message->call_object}}
                                                            </span>
                                                            <span class="border border-secondary rounded  px-2 py-1">
                                                                {{$message->result}}
                                                            </span>
                                                        </div>
                                            
                                                        <!-- Right column: Type, Date, Sender -->
                                                        <div class="col-md-4 text-left">
                                                            <h6 class="text-white mt-3">
                                                                <span class="border border-secondary text-dark rounded px-3">{{__('home.'.$message->type)}}</span>
                                                            </h6>
                                                            <h6 class="border border-secondary mt-3  rounded p-1">
                                                                <span>{{$message->created_at->translatedFormat('d F Y ', $lang)}}</span>
                                                                <span class="px-3">{{$message->created_at->format('h:i A')}}</span>
                                                            </h6>
                                                            
                                                            @if($message->type!="call")
                                                                <h6 class="text-white mt-3">
                                                                    <span class="border border-secondary text-dark rounded px-3">{{$message->sent=="sent"?__('home.sent'):__('home.saved')}}</span>
                                                                </h6>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                        @else
                                            <div class="card custom-card mb-3">
                                                    <div class="row g-0 p-3">
                                                        <!-- Left column: Message and Sent To -->
                                                        <div class="row col-md-7 align-items-center card card-body m-2">
                                                            <p>{{$message->message}}</p>
                                                            @if($message->type=="email")
                                                                <span class="bg-secondary rounded text-white px-2 py-1">{{$company->email}}</span>
                                                            @else
                                                                <span class="bg-secondary rounded text-white px-2 py-1">{{$message->sent_to}}</span>
                                                            @endif
                                                        </div>
                                            
                                                        <!-- Right column: Type, Date, Sender -->
                                                        <div class="col-md-4 text-left">
                                                            <h6 class="text-white mt-3">
                                                                <span class="border border-secondary text-dark rounded px-3">{{__('home.'.$message->type)}}</span>
                                                            </h6>
                                                            <h6 class="border border-secondary mt-3  rounded p-1">
                                                                <span>{{$message->created_at->translatedFormat('d F Y ', $lang)}}</span>
                                                                <span class="px-3">{{$message->created_at->format('h:i A')}}</span>
                                                            </h6>
                                                            
                                                            @if($message->type!="call")
                                                                <h6 class="text-white mt-3">
                                                                    <span class="border border-secondary text-dark rounded px-3">{{$message->sent=="sent"?__('home.sent'):__('home.saved')}}</span>
                                                                </h6>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                        @endif
                                        
                                        @empty
                                        <div class="card custom-card text-center">
                                            <div class="card-body">
                                                <p>0 @lang('home.messages')</p>
                                            </div>
                                        </div>
                                        @endforelse
                                    </div>
                                        
                                        
                                    </div>
                                    
                                </div>
                                    
                            </div>
                        </div>
                                
                                
                            </div>
                            
                           
                      
                            
                            
                            
                        </div>                                
              
            </div>
        </div>
    </div>
    
    
    
    
    
    
<!--//////////////////////////////-->
<!--//////////////////////////////-->
         <!--  modals  -->
<!--//////////////////////////////-->
<!--//////////////////////////////-->

      <!--modal sms app-->
    <div class="modal fade" id="send_sms_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <form method="post" action="{{url('admin/crm/clients/'.$company->id.'/send_sms') }}" >
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('home.send_sms')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body">
                    <div class="form-group">
                        <label for="message-text" class="col-form-label">@lang('home.message'):</label>
                        <textarea class="form-control" rows="4" name="message" id="message-text" required></textarea>
                    </div>
                    <input type="hidden" name="type" value="sms">
                   <div class="form-group col-md-6 m-auto">
                        <label for="parent">{{trans('home.phone')}}</label>
                        <select class="form-control select2" name="phone">
                            <option value="{{$company->phone}}">{{$company->phone }}</option>
                            @if($company->phone2)<option value="{{$company->phone2}}">{{$company->phone2 }}</option>@endif
                        </select>
                    </div>
        
                   <div class="form-group col-md-12 mt-3 d-flex justify-content-center">
                           <div class="form-check">
                              <input class="form-check-input" type="radio" name="send_to_client" value="1" id="sendToClient" required>
                              <label class="form-check-label mr-4" for="sendToClient">
                                {{trans('home.send_to_client')}}
                              </label>
                            </div>
                            
                            <div class="form-check">
                              <input class="form-check-input" type="radio" name="send_to_client" value="0" id="notSendToClient" required>
                              <label class="form-check-label mr-4" for="notSendToClient">
                                {{trans('home.save_only')}}
                              </label>
                            </div>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                </div>
            </div>
        </form>
      </div>
    </div>
    <!--modal whats app-->
     <div class="modal fade" id="send_whatsapp_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <form method="post" action="{{url('admin/crm/clients/'.$company->id.'/send_sms') }}" >
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('home.send_whatsapp')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body">
                      <input type="hidden" name="type" value="whatsapp">
                      <div class="form-group">
                            <label for="message-text" class="col-form-label">@lang('home.message'):</label>
                            <textarea class="form-control" rows="4" name="message" id="message-text" required></textarea>
                      </div>
                       <div class="form-group col-md-6 m-auto">
                            <label for="parent">{{trans('home.whatsapp')}}</label>
                            <select class="form-control select2" name="phone">
                                <option value="{{$company->whatsapp}}" selected>{{$company->whatsapp }}</option>
                            </select>
                        </div>
            
                       <div class="form-group col-md-12 mt-3 d-flex justify-content-center">
                           <div class="form-check">
                              <input class="form-check-input" type="radio" name="send_to_client" value="1" id="sendToClient" required>
                              <label class="form-check-label mr-4" for="sendToClient">
                                {{trans('home.send_to_client')}}
                              </label>
                            </div>
                            
                            <div class="form-check">
                              <input class="form-check-input" type="radio" name="send_to_client" value="0" id="notSendToClient" required>
                              <label class="form-check-label mr-4" for="notSendToClient">
                                {{trans('home.save_only')}}
                              </label>
                            </div>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                </div>
            </div>
        </form>
      </div>
    </div>
    <!--modal mail-->
     <div class="modal fade" id="send_email_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <form method="post" action="{{url('admin/crm/clients/'.$company->id.'/send_sms') }}" >
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('home.send_email')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body">
                    <input type="hidden" name="type" value="email">
                    <div class="form-group">
                        <label for="message-text" class="col-form-label">@lang('home.message'):</label>
                        <textarea class="form-control" rows="4" name="message" id="message-text" required></textarea>
                    </div>
                    <div class="form-group col-md-12 mt-3 d-flex justify-content-center">
                       <div class="form-check">
                          <input class="form-check-input" type="radio" name="send_to_client" value="1" id="sendToClient" required>
                          <label class="form-check-label mr-4" for="sendToClient">
                            {{trans('home.send_to_client')}}
                          </label>
                        </div>
                        
                        <div class="form-check">
                          <input class="form-check-input" type="radio" name="send_to_client" value="0" id="notSendToClient" required>
                          <label class="form-check-label mr-4" for="notSendToClient">
                            {{trans('home.save_only')}}
                          </label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                </div>
            </div>
        </form>
      </div>
    </div>
     <!--modal meeting-->
     <div class="modal fade" id="add_meating_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-xl" role="document">
        <form method="post" action="{{url('admin/crm/clients/'.$company->id.'/send_sms') }}" >
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">اضافة اجتماع</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body row">
                    <input type="hidden" name="type" value="meeting">
                    
                    <div class="form-group col-md-4 ">
                        <label for="parent">{{trans('home.team')}}</label>
                        <select class="form-control select2" name="team[]" multiple>
                            <option value="{{auth()->user()->id}}" selected>{{auth()->user()->name() }}</option>
                             @foreach($crm_employees as $crm_employee)
                                <option value="{{$crm_employee->id}}">{{$crm_employee->name() }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-4">
                        <label for="title" class="col-form-label">موضوع الاجتماع:</label>
                        <select class="form-control select2" name="title" >
                            <option value="اجتماع تعريفى" >اجتماع تعريفى</option>
                            <option value="اجتماع تفصيلى" >اجتماع تفصيلى</option>
                            <option value=">اجتماع جدول الاعمال" >اجتماع جدول الاعمال</option>
                            <option value="اجتماع متابعة التدريب" >اجتماع متابعة التدريب</option>
                        </select>
                        
                    </div>
                    <div class="form-group col-4 ">
                        <label for="date" class="col-form-label">@lang('home.date'):</label>
                        <input class="form-control" type="date"  name="date" id="date" min="{{ date('Y-m-d') }}" required></input>
                    </div>
                    <div class="form-group col-4 ">
                        <label for="start_at" class="col-form-label">@lang('home.start_at'):</label>
                        <input class="form-control" type="time"  name="start_date" id="start_at"  ></input>
                    </div>
                    <div class="form-group col-4 ">
                        <label for="end_at" class="col-form-label">@lang('home.end_at'):</label>
                        <input class="form-control" type="time"  name="end_date" id="end_at"  ></input>
                    </div>
                    
                    <div class="form-group col-md-4 m-auto">
                        <label for="parent">الية الاجتماع</label>
                        <select class="form-control select2" name="meeting_type" required>
                            <option value="company_site">{{trans('home.company_site')}}</option>
                            <option value="client_site">مقر العميل</option>
                            <option value="online">{{trans('home.online')}}</option>
                        </select>
                    </div>
                    <div id="meeting_details" class="row mt-3">
                        
                    </div>
                    
                    <div class="form-group col-6">
                        <label for="result" class="col-form-label">نتيجة الاجتماع :</label>
                         <select class="form-control select2" name="result" required>
                            <option value= "مؤهل">مؤهل</option>
                            <option value= "غير مؤهل">غير مؤهل</option>
                            <option value= "اتفاق">اتفاق</option>
                            <option value= "قيد النقاش">قيد النقاش</option>
                        </select>
                    </div>
                    
                    <div class="form-group col-6">
                        <label for="message-text" class="col-form-label">@lang('home.note')-@lang('home.team') :</label>
                        <textarea class="form-control" rows="2" name="note" id="message-text" ></textarea>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">@lang('home.cancel')</button>
                    <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                </div>
            </div>
        </form>
      </div>
    </div>
    <!--modal task-->
    <div class="modal fade" id="add_task_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <form method="post" action="{{url('admin/crm/clients/'.$company->id.'/send_sms') }}" >
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('home.add_task')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body row">
                    <input type="hidden" name="type" value="task">
                    
                    <div class="form-group col-md-6 ">
                        <label for="parent">{{trans('home.task_type')}}</label>
                        <select class="form-control select2" name="task_type" >
                            <option value="call">  {{ trans('home.call') }}</option>
                            <option value="sms">  {{ trans('home.send_sms') }}</option>
                            <option value="whatsapp">  {{ trans('home.send_whatsapp') }}</option>
                            <option value="email">  {{ trans('home.send_email') }}</option>
                        </select>
                    </div>
                    <div class="form-group col-md-6 ">
                        <label for="parent">{{trans('home.priority')}}</label>
                        <select class="form-control select2" name="priority" >
                            <option value="very_important">  {{ trans('home.very_important') }}</option>
                            <option value="important">  {{ trans('home.important') }}</option>
                            <option value="not_important">  {{ trans('home.not_important') }}</option>
                        </select>
                    </div>
                    
                    <div class="form-group col-lg-6 ">
                        <label for="date" class="col-form-label">@lang('home.date'):</label>
                        <input class="form-control" type="date"  name="date" id="date" min="{{ date('Y-m-d') }}" required></input>
                    </div>
                    <div class="form-group col-lg-6 ">
                        <label for="time" class="col-form-label">@lang('home.time'):</label>
                        <input class="form-control" type="time"  name="time" id="time"  ></input>
                    </div>
                    
                    <div class="form-group col-lg-6 ">
                        <label for="notify_date" class="col-form-label">@lang('home.notify_date'):</label>
                        <input class="form-control" type="date"  name="notify_date" id="notify_date" min="{{ date('Y-m-d') }}" required></input>
                    </div>
                    <div class="form-group col-lg-6 ">
                        <label for="notify_time" class="col-form-label">@lang('home.notify_time'):</label>
                        <input class="form-control" type="time"  name="notify_time" id="notify_time"  ></input>
                    </div>
                    <div class="form-group">
                        <label for="parent">{{trans('home.responsible_employee')}}</label>
                        <select class="form-control select2" name="employee[]" multiple required>
                            <option value="{{auth()->user()->id}}" selected>{{auth()->user()->name() }}</option>
                            @if(auth()->user()->type=="admin")
                                @foreach($crm_employees_task->where('id') as $crm_employee)
                                    <option value="{{$crm_employee->id}}">{{$crm_employee->name() }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="message-text" class="col-form-label">@lang('home.note')  :</label>
                        <textarea class="form-control" rows="2" name="note" id="message-text" required></textarea>
                    </div>
                    
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">@lang('home.cancel')</button>
                    <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                </div>
            </div>
        </form>
      </div>
    </div>
       <!--modal add_new_payment-->
    <div class="modal fade" id="add_new_payment_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-xl" role="document">
        <form method="post" action="{{route('save_payment',$company->id) }}" enctype="multipart/form-data">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('home.add_new_payment')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body row">
                    <input type="hidden" id="company_id" name="company_id" value="{{$company->id}}">
                    
                    <div class="form-group col-lg-4 ">
                        <label for="n_clients" class="col-form-label">@lang('home.n_clients'):</label>
                        <input class="form-control" type="number"   name="n_clients" id="n_clients" >
                    </div>
                    
                    <div class="form-group col-lg-4 ">
                        <label for="n_trainings" class="col-form-label">@lang('home.n_trainings'):</label>
                        <input class="form-control" type="number" name="n_trainings" id="n_trainings" >
                    </div>
                    
                    <div class="form-group col-lg-4 ">
                        <label for="invoice_value" class="col-form-label">@lang('home.invoice_value'):</label>
                        <input class="form-control" type="number" name="invoice_value" id="invoice_value" >
                    </div>
                    <div class="form-group col-lg-4 ">
                        <label for="training_cost" class="col-form-label">@lang('home.training_cost'):</label>
                        <input class="form-control" type="number" name="training_cost" id="training_cost" >
                    </div>
                    
                    <div class="form-group col-lg-4 ">
                        <label for="training_loaction" class="col-form-label">@lang('home.training_loaction'):</label>
                        <input class="form-control" type="text" name="training_loaction" id="training_loaction	" >
                    </div>
                    
                    <div class="form-group col-lg-4 ">
                        <label for="duration_days" class="col-form-label">@lang('home.duration_days'):</label>
                        <input class="form-control" type="number" name="duration_days" id="duration_days" >
                    </div>
                    
                    <div class="form-group col-lg-4 ">
                        <label for="duration_weeks" class="col-form-label">@lang('home.duration_weeks'):</label>
                        <input class="form-control" type="number" name="duration_weeks" id="duration_weeks" >
                    </div>
                    
                    <div class="form-group col-lg-4 ">
                        <label for="duration_hours" class="col-form-label">@lang('home.duration_hours'):</label>
                        <input class="form-control" type="number" name="duration_hours" id="duration_hours" >
                    </div>
                   
                    <div class="form-group col-md-6 ">
                        <label for="parent">{{trans('home.invoice_status')}}</label>
                        <select class="form-control select2" name="invoice_status" id="invoice_status" >
                            <option value="in_training">  {{ trans('home.in_training') }}</option>
                            <option value="invoicing">  {{ trans('home.invoicing') }}</option>
                            <option value="collected">  {{ trans('home.collected') }}</option>
                        </select>
                    </div>
                    
                    <div class="form-group col-lg-4 d-none" id="invoice_file">
                        <label for="invoice_file" class="col-form-label">ملف الفاتورة:</label>
                        <input class="form-control" type="file" name="invoice_file" >
                    </div>
                   
                    
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">@lang('home.cancel')</button>
                    <button type="submit" class="btn btn-primary">@lang('home.save') </button>
                </div>
            </div>
        </form>
      </div>
    </div>
         <!--modal sms app-->
    <div class="modal fade" id="send_call_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <form method="post" action="{{url('admin/crm/clients/'.$company->id.'/send_sms') }}" >
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('home.send_call')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body row">
                    <div class="form-group col-6">
                        <label for="result" class="col-form-label">عنوان المكالمة :</label>
                       
                          <select class="form-control select2" name="call_object" required>
                            <option value= "تعريفية"> تعريفية</option>
                            <option value= "متابعة"> متابعة </option>
                        </select>
                    </div>
                    <div class="form-group col-6">
                        <label for="result" class="col-form-label">نتيجة المكالمة :</label>
                           <select class="form-control select2" name="result" required>
                            <option value= "مهتم">مهتم</option>
                            <option value= "غير مهتم">غير مهتم</option>
                            <option value= "تحديد موعد اخر">تحديد موعد اخر</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="message-text" class="col-form-label">@lang('home.message'):</label>
                        <textarea class="form-control" rows="4" name="message" id="message-text" required></textarea>
                    </div>
                    <input type="hidden" name="type" value="call">
                    {{--
                    <div class="form-group col-md-6 m-auto">
                        <label for="parent">{{trans('home.phone')}}</label>
                        <select class="form-control select2" name="phone">
                            <option value="{{$company->phone}}">{{$company->phone }}</option>
                        </select>
                    </div>
                    --}}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                </div>
            </div>
        </form>
      </div>
    </div>
    
          <!--modal add-meeting-result app-->
    <div class="modal fade" id="add_meeting_result" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <form method="post" action="{{route('save_meeting_result') }}" >
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"> اضافة نتيجة الاجتماع </h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="message-text" class="col-form-label">@lang('home.meeting_result'):</label>
                        <textarea class="form-control" rows="4" name="result" id="message-text" required></textarea>
                    </div>
                    <input type="hidden" id="meeting_id" name="meeting_id" value="">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                </div>
            </div>
        </form>
      </div>
    </div>
    
    
    
    
@endsection
@section('script')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        $('.add-meeting-result').on('click',function () {
            var meeting_id = $(this).data('meeting_id'); 
            $('#meeting_id').val(meeting_id);
        });
    </script>

    <script>
        $('.modal').on('shown.bs.modal', function () {
            // Initialize Select2 with the 'tags' option enabled
            $('.select2').select2({
                width: '100%', // Ensures proper width inside modal
                dropdownParent: $(this) // Ensures dropdown stays within the modal
            });
            // $('.select2').on('select2:unselecting', function(e) {
            //     var id = e.params.args.data.id; // Get the ID of the option being unselected
            //     var $option = $(this).find('option[value="' + id + '"]');
                
            //     if ($option.is('[disabled]')) {
            //         e.preventDefault(); // Prevent the unselect event
            //     }
            // });
        });

    </script>
    <script>
        $(document).ready(function() {
            // Function to update meeting details based on selected meeting type
            function updateMeetingDetails() {
                var meetingType = $('select[name="meeting_type"]').val();
                var meetingDetails = $('#meeting_details');
        
                // Clear previous details
                meetingDetails.empty();
        
                // Add fields based on selected meeting type
                if (meetingType === 'client_site') {
                    meetingDetails.append(
                        '<div class="form-group col-lg-6">' +
                        '    <label for="location">{{trans("home.location")}}</label>' +
                        '    <input type="text" class="form-control" name="location" required>' +
                        '</div>' +
                        '<div class="form-group col-lg-6">' +
                        '    <label for="address">{{trans("home.address_meeting")}}</label>' +
                        '    <input type="text" class="form-control" name="address" required>' +
                        '</div>'
                    );
                } else if (meetingType === 'online') {
                    meetingDetails.append(
                        '<div class="form-group">' +
                        '    <label for="zoom_link">{{trans("home.zoom_link")}}</label>' +
                        '    <input type="text" class="form-control" name="zoom_link" required>' +
                        '</div>'
                    );
                }
            }
        
            // Initialize the Select2 plugin
            $('.select2').select2();
        
            // Update meeting details when the meeting type changes
            $('select[name="meeting_type"]').on('change', function() {
                updateMeetingDetails();
            });
        
            // Trigger update on page load to show details for the initial selection
            updateMeetingDetails();
        });

    </script>
    <script>
        // Handle delete button click event
        $(document).on('click', '.delete-btn', function (e) {
            e.preventDefault();
    
            var messageId = $(this).data('id'); // Get the data-id from the clicked button
    
            // Show SweetAlert confirmation
            Swal.fire({
                title: '{{__('home.Are you sure you want to delete that ?')}}',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '{{__('home.delete')}}',
                cancelButtonText: '{{__('home.cancel')}}'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
    
                    $.ajax({
                        url: "{{route('delete_crm_sms') }}" ,
                        type: 'POST',
                        data: {id: messageId},
                        success: function () {
                            location.reload();
                        }
                    }); 
                }
            });
        });
        
    </script>
    
    <!--payments-->
    <script>
        $('#invoice_status').on('change',function () {
            let invoice_status = $(this).val(); 
            if(invoice_status=="collected"){
                $('#invoice_file').removeClass('d-none'); 
            }else{
                $('#invoice_file').addClass('d-none'); 
            }
        });
    
        $('.add_invoice_item').on('click',function () {
            let invoice_id = $(this).data('invoice_id');
            let invoice_number = $(this).data('invoice_number');
    
            // Populate modal with data
            $('#invoice_id').val(invoice_id);
            $('#paymentModalLabel').html(invoice_number);
            $('#paymentModal').modal('show');
        });
    </script>
    
     <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
   <script>
        $(document).on('click', '.btn_delete', function(e) {
        e.preventDefault();
        
        var itemId = $(this).data('id'); // Get the item ID from the data attribute
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: "btn btn-success",
                cancelButton: "btn btn-danger"
            },
            buttonsStyling: false
        });
        
        swalWithBootstrapButtons.fire({
            title: "{{ __('home.are you sure') }}",
            text: "{{ __('home.to delete this item?') }}",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "{{ __('home.yes') }}, {{ __('home.delete') }}!",
            cancelButtonText: "{{ __('home.no') }}, {{ __('home.cancel') }}!",
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ route('delete_invoice', '') }}/" + itemId,
                    type: 'GET',
                    data: {
                        _token: '{{ csrf_token() }}', // Include CSRF token
                        id: itemId
                    },
                    success: function(response) {
                        swalWithBootstrapButtons.fire({
                            title: "{{ __('home.deleted') }}!",
                            text: "{{ __('home.the item has been deleted') }}.",
                            icon: "success"
                        });
                        location.reload()
                        
                    },
                    error: function(response) {
                        swalWithBootstrapButtons.fire({
                            title: "{{ __('home.error') }}!",
                            text: "{{ __('home.something went wrong') }}.",
                            icon: "error"
                        });
                    }
                });
            }
        });
    });
   </script>
@endsection



