@extends('layouts.admin')
<title>{{trans('home.add_client')}}</title>
@section('content')
    <div class="container-fluid">
          <!-- Page Header -->
        <div class="page-header row">
            <div>
            </div>
        </div>


           <!-- End Page Header -->
    <form method="post" action="{{route('store_company_Client')}}" id="client_form">
        @csrf
   
        <!-- Row-->
        <div class="row">
            <input type="hidden" name="company_id" value="{{$company->id}}">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">اضافة متدرب جديد | {{$company->name}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.name')}}</label>
                                <input class="form-control" name="name" type="text" placeholder="{{trans('home.name')}}" required>
                            </div>

                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.email')}}</label>
                                <input class="form-control" name="email" type="email" placeholder="{{trans('home.email')}}" required>
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.phone')}}</label>
                                <input class="form-control" name="phone" type="text" placeholder="{{trans('home.phone')}}">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.phone')}}2</label>
                                <input class="form-control" name="phone2" type="text" placeholder="{{trans('home.phone')}}2">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.whatsapp')}}</label>
                                <input class="form-control" name="whatsapp" type="text" placeholder="{{trans('home.whatsapp')}}">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.ssn')}}</label>
                                <input class="form-control" name="ssn" type="text" placeholder="{{trans('home.ssn')}}" required>
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.nationality')}}</label>
                                <input class="form-control" name="nationality" type="text" placeholder="{{trans('home.nationality')}}" >
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.qualification')}}</label>
                                <input class="form-control" name="qualification" type="text" placeholder="{{trans('home.qualification')}}" >
                            </div>
                            {{--
                            <div class="form-group col-md-3">
                                <label for="parent">{{trans('home.training')}}</label>
                                <select class="form-control select2" name="training_id[]" multiple>
                                    @foreach($trainings as $training)
                                        <option value="{{$training->id}}">{{$training->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            --}}
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.country')}}</label>
                                <select class="form-control select2 country"  name="country_id">
                                        <option disabled selected>{{__('home.country')}}</option>
                                    @foreach($countries as $country)
                                        <option value="{{$country->id}}">{{$country->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.area')}}</label>
                                <select class="form-control select2 region"  name="area_id">
                                    <option disabled selected>{{__('home.area')}}</option>
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.region')}}</label>
                                <select class="form-control select2 area"  name="region_id">
                                    <option disabled selected>{{__('home.region')}}</option>
                                </select>
                            </div>

                        </div>                                
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->



        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class=" btn btn-success text-white">
                                    <i class="icon-note"></i> {{ trans('home.save') }}
                                </button>
                                <a href="{{ url('/admin/crm/clients') }}">
                                    <button type="button" class="btn btn-danger mr-1">
                                        <i class="icon-trash"></i> {{ trans('home.cancel') }}
                                    </button>
                                </a>
                            </div>
                        </div>                                
                    </div>
                </div>
            </div>
        </div>
    </form>
    </div>
@endsection

@section('script')
       
    <!--areas and regions-->
     <script>
        $('.country').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('getAreas')  }}',
                data: {id: id},
                success: function (data) {
                    var html = '';
                    html += '<option></option>'
                    for (var i = 0; i < data.length; i++) {
                        html += '<option  value="' + data[i].id + '">@if(\App::getLocale() == 'en')' + data[i].name_en + ' @else ' + data[i].name_ar + ' @endif</option>';
                    }
                    region.html(html);
                    $('#select_country').html('');
                }
            });
        });

        $('.region').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('getRegions')  }}',
                data: {id: id},
                success: function (data) {
                    var html = '';
                    html += '<option></option>'
                    for (var i = 0; i < data.length; i++) {
                        html += '<option  value="' + data[i].id + '">@if(\App::getLocale() == 'en')' + data[i].name_en + ' @else ' + data[i].name_ar + ' @endif</option>';
                    }
                    area.html(html);
                    $('.shipping_total').html("{{ __('home.select your area first')}}");
                    $('#select_region').html('');
                    
                }
            });
        });

    </script>

@endsection
