@extends('layouts.admin')
<title>{{trans('home.crm')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm')}}</h2>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.new_clients')}}</h2>
            </div>
            
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="d-flex btn btn-list gap-3 m-3">
                        <a href="javascript:void(0)" class="filter_type" data-type="company">
                            <button class="btn ripple btn-primary"><i class="fas fa-filter"></i> {{trans('home.companies')}}</button>
                        </a>
                        <a href="javascript:void(0)" class="filter_type" data-type="client">
                            <button class="btn ripple btn-primary"><i class="fas fa-filter"></i> {{trans('home.clients')}}</button>
                        </a>
                        <a href="javascript:void(0)" class="filter_type d-none" id="clear" data-type="clear">
                            <button class="btn ripple btn-primary"><i class="fas fa-times"></i> {{trans('home.show all')}}</button>
                        </a>
                    </div>
                    <div class="card-body">
                        <!-- all -->
                        <div class="table-responsive type_all  clientrecord">
                            <table class="table exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" id="checkAll"/></th>
                                        <th>{{trans('home.id')}}</th>
                                        <th class="wd-20p">{{trans('home.name')}}</th>
                                        <th class="wd-25p">{{trans('home.phone')}}</th>
                                        <th class="wd-25p">{{trans('home.ssn')}}</th>
                                        <th class="wd-25p">{{trans('home.email')}}</th>
                                        <th class="wd-15p">البرنامج</th>
                                        <th class="wd-15p">{{trans('home.responsible_employee')}}</th>
                                        <th class="wd-15p">{{trans('home.client_status')}}</th>
                                        <th class="wd-25p">{{trans('home.nationality')}}</th>
                                        <th class="wd-25p">{{trans('home.qualification')}}</th>
                                        <th class="wd-25p">{{trans('home.region')}}</th>
                                        <th class="wd-25p">{{trans('home.area')}}</th>
                                        <th class="wd-15p">{{trans('home.start_date')}}</th>
                                        <th class="wd-15p">{{trans('home.end_date')}}</th>
                                        <th class="wd-15p">{{trans('home.come_from')}}</th>
                                        <th class="wd-15p">{{trans('home.payment_status')}}</th>
                                        <th class="wd-15p">{{trans('home.company')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($clients as $client)
                                        <tr id="{{$client->id}}">
                                            <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$client->id}}" /> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->id}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->name}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->phone}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->ssn}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->email}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> 
                                                        {!! $client->companyTraining?->map(function($training) use($lang) {
                                                        return "<span class='badge badge-primary m-1'>" . $training->training->{'name_' . $lang} . "</span>";
                                                    })->implode(' ') !!}
                                                </a> 
                                            </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->responsible_employee?->user?->name() }}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->status?->{'name_'.$lang} }}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->nationality}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->qualification}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->area?->{'name_'.$lang} }}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->region?->{'name_'.$lang} }}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->training?->training->start_date }}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->training?->training->end_date }}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->source?->{'name_'.$lang} }} </a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> 
                                            @if($client->training)
                                                @if($client->training->payment_status=="paid")
                                                    <span class='badge badge-success m-1'>
                                                        {{__('home.paid') }}
                                                    </span>
                                                @else
                                                    <span class='badge badge-danger m-1'>
                                                        {{__('home.un_paid') }}
                                                    </span>
                                                @endif
                                            @endif
                                            </a> </td>
                                            <td><a href="{{url('admin/crm/client/'.$client->id)}}"> {{$client->company?$client->company->name: __('home.no_company') }}</a> </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
    					</div>
    					<!-- client -->
    					<div class="table-responsive type_client clientrecord d-none">
                            <table class="table exportexample" >
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" id="checkAll"/></th>
                                        <th>{{trans('home.id')}}</th>
                                        <th class="wd-20p">{{trans('home.name')}}</th>
                                        <th class="wd-25p">{{trans('home.phone')}}</th>
                                        <th class="wd-25p">{{trans('home.whatsapp')}}</th>
                                        <th class="wd-25p">{{trans('home.ssn')}}</th>
                                        <th class="wd-25p">{{trans('home.email')}}</th>
                                        <th class="wd-25p">{{trans('home.nationality')}}</th>
                                        <th class="wd-25p">{{trans('home.qualification')}}</th>
                                        <th class="wd-25p">{{trans('home.region')}}</th>
                                        <th class="wd-25p">{{trans('home.area')}}</th>
                                        <th class="wd-15p">{{trans('home.training')}}</th>
                                        <th class="wd-15p">{{trans('home.start_date')}}</th>
                                        <th class="wd-15p">{{trans('home.end_date')}}</th>
                                        <th class="wd-15p">{{trans('home.come_from')}}</th>
                                        <th class="wd-15p">{{trans('home.client_status')}}</th>
                                        <th class="wd-15p">{{trans('home.responsible_employee')}}</th>
                                        <th class="wd-15p">{{trans('home.payment_status')}}</th>
                                        <th class="wd-15p">{{trans('home.company')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($clients->where('type','client') as $client)
                                    
                                        <tr id="{{$client->id}}">
                                            <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$client->id}}" /> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->id}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->name}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->phone}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->whatsapp}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->ssn}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->email}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->nationality}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->qualification}}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->area?->{'name_'.$lang} }}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->region?->{'name_'.$lang} }}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> 
                                                        {!! $client->companyTraining?->map(function($training) use($lang) {
                                                        return "<span class='badge badge-primary m-1'>" . $training->training->{'name_' . $lang} . "</span>";
                                                    })->implode(' ') !!}
                                                </a> 
                                            </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->training?->training->start_date }}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->training?->training->end_date }}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->source?->{'name_'.$lang} }} </a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->status?->{'name_'.$lang} }}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->responsible_employee?->user?->name() }}</a> </td>
                                            <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> 
                                            @if($client->training)
                                                @if($client->training->payment_status=="paid")
                                                    <span class='badge badge-success m-1'>
                                                        {{__('home.paid') }}
                                                    </span>
                                                @else
                                                    <span class='badge badge-danger m-1'>
                                                        {{__('home.un_paid') }}
                                                    </span>
                                                @endif
                                            @endif
                                            </a> </td>
                                            <td><a href="{{url('admin/crm/client/'.$client->id)}}"> {{$client->company?$client->company->name: __('home.no_company') }}</a> </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
    					</div>
    					<!-- company -->
    					<div class="table-responsive type_company clientrecord d-none">
                            <table class="table exportexample" >
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" id="checkAll"/></th>
                                        <th>{{trans('home.id')}}</th>
                                        <th class="wd-20p">{{trans('home.name')}}</th>
                                        <th class="wd-25p">{{trans('home.field')}}</th>
                                        <th class="wd-25p">{{trans('home.region')}}</th>
                                        <th class="wd-25p">{{trans('home.area')}}</th>
                                        <th class="wd-15p">{{trans('home.client_status')}}</th>
                                        <th class="wd-15p">{{trans('home.come_from')}}</th>
                                        <th class="wd-15p">{{trans('home.responsible_contact_person')}}</th>
                                        <th class="wd-15p">{{trans('home.responsible_employee')}}</th>
                                        <th class="wd-15p">{{trans('home.clients')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($clients->where('type','company') as $client)
                                        <tr id="{{$client->id}}">
                                            <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$client->id}}" /> </td>
                                            <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->id}}</a> </td>
                                            <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->name}}</a> </td>
                                            <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->company_data->field->{'name_'.$lang} }}</a> </td>
                                            <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->company_data->area?->{'name_'.$lang} }}</a> </td>
                                            <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->company_data->region?->{'name_'.$lang} }}</a> </td>
                                            <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->status?->{'name_'.$lang} }}</a> </td>
                                            <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->source?->{'name_'.$lang} }} </a> </td>
                                            <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client?->company_data->responsible_contact_person }} </a> </td>
                                            <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client?->responsible_employee?->user->name() }} </a> </td>
                                            <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> 
                                                {!! $client->clients?->map(function($company_client) use($lang) {
                                                        return "<span class='badge badge-primary m-1'>" . $company_client->name . "</span>";
                                                    })->implode(' ') !!}
                                                    </a> 
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
    					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
@section('script')
    <script>
        $('.filter_type').click(function(){
            var type = $(this).data('type');
            $('.filter_type button').removeClass('btn-info').addClass('btn-primary');
            $(this).find('button').removeClass('btn-primary').addClass('btn-info');
            
            if(type == "client"){
                $('.clientrecord').addClass('d-none'); 
                $('.type_client').removeClass('d-none'); 
                $('#clear').removeClass('d-none'); 
                
            } 
            else if(type == "company"){
                $('.clientrecord').addClass('d-none'); 
                $('.type_company').removeClass('d-none'); 
                $('#clear').removeClass('d-none'); 
            }
            else if(type == "clear"){
                $('.clientrecord').addClass('d-none');  
                $('.type_all').removeClass('d-none'); 
                $('#clear').addClass('d-none'); 
            }
        });
    </script>
    
    <script>
        
        if( (userType == 'admin' && role_id ==5)||(userType == 'super_admin' && role_id ==1) || perm2 ){
                if(lang == "ar"){
                        var table = $('.exportexample').DataTable( {
                    		lengthChange: false,
                    		//responsive: 1,
                    		dom: 'Bfrtip',
                    		"bPaginate" : true,
                    		"pageLength": 50,
                    		 buttons: buttons,
                    		 "columnDefs": [
                                { "orderable": false, "targets": 0 }  
                            ],
                    		language: {
                                url: '//cdn.datatables.net/plug-ins/1.13.3/i18n/ar.json',
                            },
                    	} );
                }else {
                        var table = $('.exportexample').DataTable( {
                    		lengthChange: false,
                    		//responsive: 1,
                    		dom: 'Bfrtip',
                    		"pageLength": 50,
                    		"columnDefs": [
                                { "orderable": false, "targets": 0 }  
                            ],
                    		buttons: [ 'copy', 'excel', 'colvis','pageLength' ],
                    	} );
                    }
        
        }else{
                if(lang == "ar"){
                    var table = $('.exportexample').DataTable( {
                		lengthChange: false,
                		//responsive: 1,
                		dom: 'Bfrtip',
                		"pageLength": 50,
                		buttons: [  ],
                		"columnDefs": [
                            { "orderable": false, "targets": 0 }  
                        ],
                		language: {
                            url: '//cdn.datatables.net/plug-ins/1.13.3/i18n/ar.json',
                        },
                	} );
                }else{
                    var table = $('.exportexample').DataTable( {
                		lengthChange: false,
                		//responsive: 1,
                		dom: 'Bfrtip',
                		"pageLength": 50,
                		"columnDefs": [
                            { "orderable": false, "targets": 0 }  
                        ],
                		buttons: [ ],
                	} );
                }
        }
    </script>
@endsection

