@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.details').' | '.$client->name}}</title>
@endsection
@section('style')
    <style>
        .select2-container {
            z-index: 1050 !important; /* Make sure it's higher than the modal (default is 1050) */
        }
        
        .select2-dropdown {
            z-index: 1051 !important; /* Ensure the dropdown appears above the modal */
        }
    </style>
@endsection
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.details').' | '.$client->name}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('admin/crm/clients')}}">{{trans('home.clients')}}</a></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        


        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                
               
                <div class="row">
                    <div class="col-lg-12 mb-3">
                        <div class='card custom-card'>
                            <div class="card-body">
                                
                                
                                <h3 class='mb-3'>  {{$client->name}}</h3>
                                
                                @if($client->ssn)
                                    <p>{{trans('home.ssn')}} : {{$client->ssn}}</p>
                                @endif
                                
                                <p>{{trans('home.training')}} : {!! $client->companyTraining?->map(function($training) use($lang) {
                                                return "<span class='badge badge-primary m-1'>" . $training->training->{'name_' . $lang} . "</span>";
                                            })->implode(' ') !!}
                                </p>
                                
                                @if($client->source)
                                    <p>{{trans('home.come_from')}} :{{$client->source?->{'name_'.$lang} }}</p>
                                @endif
                                  
                                @if($client->company)   
                                    <p>{{trans('home.company')}} : {{$client->company?$client->company->name: __('home.no_company') }}</p>
                                @endif
                                
                                <p>{{trans('home.responsible_employee')}} : {{$client->responsible_employee? $client->responsible_employee?->user?->name() :'-' }}</p>
                                 
                                <a href="{{url('admin/crm/clients/'.$client->id.'/edit')}}" class="btn btn-primary crmEditBtn text-white" title='{{ trans('home.edit') }}'>
                                     
                                     <i class="fal fa-edit"></i>
                                </a>
                                
                                <div class='d-flex justify-content-end gap-2'>
                                    
                                    <a href="{{url('admin/crm/add-client/single')}}" class="btn btn-primary crmAddBtn text-white">
                                         {{ trans('home.add_client') }}
                                    </a>
                                    <a href="javascript:void(0)" data-bs-toggle="modal" 
                                            data-bs-target="#add_new_training"  class="btn btn-primary crmAddBtn text-white">
                                         {{ trans('home.add_new_training') }}
                                    </a>
                                    
                                </div>
                                
                            </div>
                        </div>
                       
                    </div>
                 
                    <div class='col-lg-12'>
                        
                        <ul class="nav nav-tabs d-flex justify-content-center crmTabs mb-3" id="myTab" role="tablist">
                                  <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="contact-tab" data-bs-toggle="tab" data-bs-target="#contact" type="button" role="tab" aria-controls="contact" aria-selected="true">
                                        @lang('home.details') 
                                    </button>
                                  </li>
                                  <li class="nav-item" role="presentation">
                                    <button class="nav-link " id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="false">
                                        @lang('home.financial')
                                        </button>
                                  </li>
                                  <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">
                                        @lang('home.activity')
                                    </button>
                                  </li>
                                
                                </ul>
                                
                        <div class='card custom-card'>
                            <div class='card-body'>
                                
                                <div class="tab-content" id="myTabContent">
                                    
                                    <div class="tab-pane fade show active" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                                             
                                         <div class=''>
                                             
                                            <p>{{trans('home.phone')}} : {{$client->phone}}</p>
                                            
                                            @if($client->phone)
                                            <p>{{trans('home.phone')}}2 : {{$client->phone2}}</p>
                                            @endif
                                            
                                            <p>{{trans('home.whatsapp')}} : {{$client->whatsapp}}</p>
                                            
                                            <p>{{trans('home.status')}} : {{$client->status?->{'name_'.$lang} }}</p>
                                            
                                         </div>
                                             
                                    </div>
                                      
                                    <div class="tab-pane fade " id="home" role="tabpanel" aria-labelledby="home-tab">
                                            
                                        <div class="row gap-2 justify-content-center">
                                                    @foreach($client->companyTraining as $client_training)
                                                        
                                                  
                                                        <div class="card mb-4">
                                                            <div class="d-flex flex-column gap-3">
                                                                {{__('home.training').' : '.$client_training->training->{'name_' . $lang} }}
                                                                <span class="d-block">
                                                                    {{__('home.invoice_number').' : '.$client_training->invoice->invoice_number }}
                                                                </span>
                                                                <span class="d-block">
                                                                    {{__('home.invoice_status').' : '.__('home.'.$client_training->invoice->invoice_status)}}
                                                                </span>
                                                            </div>
                                                            <div class='mt-3'>
                                                                 
                                                                <span class="border border-secondary rounded px-2">@lang('home.payments')</span>
                                                                <span class="border border-secondary rounded px-2">{{__('home.price').' : '.$client_training->invoice->invoice_value.' '.__('home.SAR')}}</span>
                                                                <div class="mt-3">
                                                                    <span class="border border-secondary rounded px-2">
                                                                        {{ __('home.collected') . ' : ' . $client_training->invoice->items->sum('amount') . ' ' . __('home.SAR') }}
                                                                    </span>
                                                                </div>
                                                             
                                                                @if($client_training->invoice->invoice_status!="collected")
                                                                <div class='w-100 text-center mt-3'>
                                                                    
                                                                    <a href="javascript:void(0)" data-invoice_id="{{$client_training->invoice->id}}" 
                                                                    data-invoice_number="{{$client_training->invoice->invoice_number}}"
                                                                        class="add_invoice_item btn btn-primary text-white">
                                                                         {{ trans('home.add_new_payment') }}
                                                                    </a>
                                                                </div>
                                                                @endif
                                                                <table class="table mt-4">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>رقم العملية</th>
                                                                            <th>{{trans('home.amount')}}</th>
                                                                            <th>{{trans('home.details')}}</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        @forelse($client_training->invoice->items as $item)
                                                                            <tr data-id="{{$item->id}}" data-type="{{$item->type}}" data-amount="{{$item->amount}}" data-invoice-url="">
                                                                                <td><a href="{{ url('admin/crm/invoice/'.$client_training->invoice->id) }}">{{$item->invoice_code}}</a></td>
                                                                                <td><a href="{{ url('admin/crm/invoice/'.$client_training->invoice->id) }}">{{$item->amount}}</a></td>
                                                                                <td><a class="btn btn-primary " href="{{ url('admin/crm/invoice/'.$client_training->invoice->id) }}">{{trans('home.details')}}</a></td>
                                                                            </tr>
                                                                        @empty
                                                                            <tr>
                                                                                <td> -</td>
                                                                                <td> -</td>
                                                                                <td> -</td>
                                                                            </tr>
                                                                        @endforelse
                                                                    </tbody>
                                                                </table>
                                                                @can('crm-delete-invoice')
                                                                <td>
                                                                    <a class="btn btn-primary delete-training" data-id="{{$client_training->id}}" href="{{ route('delete_training',$client_training->id) }}">
                                                                       حذف الفاتورة 
                                                                    </a>
                                                                    <a class="btn btn-success" 
                                                                        href="{{ url('admin/crm/invoice/'.$client_training->invoice->id) }}" >
                                                                            {{trans('home.generate_invoice')}}
                                                                    </a>
                                                                </td>
                                                                @endcan
                                                                
                                                                
                                        					</div>
                                                        </div>
                                                                           
                                                      
                                                    @endforeach
                                                </div>
                                           
                                    </div>
                                  
                                  
                                    <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                                      
                                        <div class="d-flex flex-wrap gap-2 justify-content-center mb-5">
                                            <a href="javascript:void(0)" data-bs-toggle="modal" 
                                                    data-bs-target="#send_call_modal" class="send_call btn btn-primary text-white">
                                                 <i class="fe fe-plus mx-2"></i>
                                                 {{ trans('home.send_call') }}
                                            </a>
                                            <a href="javascript:void(0)" data-bs-toggle="modal" 
                                                    data-bs-target="#send_sms_modal" class="send_sms btn btn-primary text-white">
                                                 <i class="fe fe-plus mx-2"></i>
                                                 {{ trans('home.send_sms') }}
                                            </a>
                                            {{--
                                            <a href="javascript:void(0)"  data-bs-toggle="modal" 
                                                    data-bs-target="#send_whatsapp_modal" class="btn btn-primary text-white">
                                                 <i class="fe fe-plus mx-2"></i>
                                                 {{ trans('home.send_whatsapp') }}
                                            </a>
                                            --}}
                                            <a href="javascript:void(0)" data-bs-toggle="modal" 
                                                    data-bs-target="#send_email_modal" class="btn btn-primary text-white">
                                                 <i class="fe fe-plus mx-2"></i>
                                                 {{ trans('home.send_email') }}
                                            </a>
                                            <a href="javascript:void(0)"  data-bs-toggle="modal" 
                                                    data-bs-target="#add_meating_modal" class="btn btn-primary text-white">
                                                 <i class="fe fe-plus mx-2"></i>
                                                 {{ trans('home.add_meating') }}
                                            </a>
                                            <a href="javascript:void(0)"   data-bs-toggle="modal" 
                                                    data-bs-target="#add_task_modal"  class="btn btn-primary text-white">
                                                 <i class="fe fe-plus mx-2"></i>
                                                 {{ trans('home.add_task') }}
                                            </a>
                                        </div>
                                        <div class="row">
                                                    @forelse($client->messages as $message)
                                                    @if($message->type=="meeting")
                                                        <div class="mb-3 col-lg-4 col-md-6">
                                                            <div class="d-flex gab-3 timeCrm">
                                                                <span>{{$message->created_at->translatedFormat('d F Y ', $lang)}}</span>
                                                                <span>{{$message->created_at->format('h:i A')}}</span>
                                                            </div>
                                                             
                                                            <!-- Left column: Message and Sent To -->
                                                            <div class="crmCard">
                                                                <span class="">{{$message->meeting->title}}</span>
                                                                <p>{{__('home.note').' : '.$message->meeting->note}}</p>
                                                                
                                                                <div class="d-flex gap-2 m-2 align-items-center">
                                                                    <span class="border border-secondary px-3 py-1 ">
                                                                        {{Carbon\Carbon::parse($message->meeting->date)->translatedFormat('d F Y ', $lang)}}
                                                                    </span>
                                                                    <span class="border border-secondary px-3 py-1 ">
                                                                       {{  date('h:i A', strtotime($message->meeting->start_date)) .' : '. date('h:i A', strtotime($message->meeting->end_date)) }}
                                                                    </span>
                                                                </div>
                                                                
                                                                @if($message->meeting->meeting_type=="client_site")
                                                                    <a target="_blank" href="{{$message->meeting->location}}" class="mt-2">
                                                                        <span class="bg-secondary rounded text-white px-2 py-1 mb-2">{{__('home.'.$message->meeting->meeting_type)}}</span>
                                                                    </a>
                                                                    <span class="bg-secondary rounded text-white px-2 py-1 mt-2">
                                                                        {{$message->meeting->address}}
                                                                    </span>
                                                                @elseif($message->meeting->meeting_type=="online")
                                                                    <a target="_blank" href="{{$message->meeting->zoom_link}}" class="mt-2">
                                                                        <span class="bg-secondary rounded text-white px-2 py-1 mb-2">{{__('home.'.$message->meeting->meeting_type)}}</span>
                                                                    </a>
                                                                     <span class="border border-secondary px-3 py-1  mt-2">
                                                                        {{$message->meeting->zoom_link}}
                                                                    </span>
                                                                @endif
                                                            
                                                           
                                                                <h6 class="mt-3">
                                                                    <span class="border border-secondary text-dark rounded px-3">{{__('home.meeting')}}</span>
                                                                </h6>
                                                                
                                                                <h6 class="mt-3">
                                                                    <span class="border border-secondary text-dark rounded px-3">{{$message->sent=="sent"?__('home.sent'):__('home.saved')}}</span>
                                                                </h6>
                                                                <a title='{{ trans('home.delete') }}' href="javascript:void(0)" data-id='{{$message->id}}'   class="btn text-danger delete-btn">
                                                                     <i class="fal fa-trash"></i>
                                                                </a>
                                                            </div>
                                                             
                                                        </div>
                                                    @elseif($message->type=="task")
                                                      <div class="mb-3 col-lg-4 col-md-6">
                                                                <div class="d-flex gab-3 timeCrm">
                                                                    <span>{{$message->created_at->translatedFormat('d F Y ', $lang)}}</span>
                                                                    <span>{{$message->created_at->format('h:i A')}}</span>
                                                                </div>
                                                                 
                                                                <!-- Left column: Message and Sent To -->
                                                                <div class="crmCard">
                                                                    <span class="fw-bold">{{$message->task->task_type}}</span>
                                                                    <p>{{$message->task->note}}</p>
                                                                
                                                                    <h6 class="text-white mt-3">
                                                                        <span class="border border-secondary text-dark rounded px-3">{{__('home.task_type').': '.__('home.'.$message->type)}}</span>
                                                                    </h6>
                                                                    
                                                                    <h6 class="text-white mt-3">
                                                                        <span class="border border-secondary text-dark rounded px-3">{{__('home.'.$message->task->priority)}}</span>
                                                                    </h6>
                                                                    <a href="javascript:void(0)" data-id={{$message->id}}  class="btn btn-danger text-white delete-btn">
                                                                         {{ trans('home.delete') }}
                                                                         <i class="fas fa-trash" aria-hidden="true"></i>
                                                                    </a>
                                                                </div>
                                                                    
                                                               
                                                            </div>
                                                    @else
                                                        <div class="mb-3 col-lg-4 col-md-6">
                                                                <div class="d-flex gab-3 timeCrm">
                                                                    <span>{{$message->created_at->translatedFormat('d F Y ', $lang)}}</span>
                                                                    <span>{{$message->created_at->format('h:i A')}}</span>
                                                                </div>
                                                                
                                                                <!-- Left column: Message and Sent To -->
                                                                <div class="crmCard">
                                                                    @if($message->type=="email")
                                                                        <span class="fw-bold">{{$client->email}}</span>
                                                                    @else
                                                                        <span class="fw-bold">{{$message->sent_to}}</span>
                                                                    @endif
                                                                    <p>{{$message->message}}</p>
                                                                
                                                                    <h6 class="text-white mt-3">
                                                                        <span class="border border-secondary text-dark rounded px-3">{{__('home.'.$message->type)}}</span>
                                                                    </h6>
                                                                    
                                                                    <h6 class="text-white mt-3">
                                                                        <span class="border border-secondary text-dark rounded px-3">{{__('home.'.$message->sent)}}</span>
                                                                    </h6>
                                                                </div>
                                                                 
                                                            </div>
                                                    @endif
                                                    @empty
                                                    <div class="card custom-card text-center">
                                                        <div class="card-body">
                                                            <p>0 @lang('home.messages')</p>
                                                        </div>
                                                    </div>
                                                    @endforelse
                                        </div>
                
                                    </div>
                                  
                                  
                                </div>
                                
                            </div>
                        </div>
                
                    </div>
                    
                </div>                                
             
         
            </div>
        </div>
    </div>
    <div class="modal fade" id="paymentModal" tabindex="-1" aria-labelledby="paymentModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form  action="{{route('invoice_store')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="invoice_id" id="invoice_id" >
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">#رقم العملية</h5>
                        <h5 class="modal-title mx-2" id="paymentModalLabel"></h5>
                        <button type="button" class="btn-close me-auto ms-0" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body row">
                        <h3 class="mb-5">اضافة عملية جديدة</h3>
                        <div class="form-group col-lg-12 ">
                            <label for="invoice_number" class="col-form-label">رقم العملية:</label>
                            <input class="form-control" type="number"   name="invoice_number"  required>
                        </div>
                        <div class="form-group col-lg-12 ">
                            <label for="amount" class="col-form-label">@lang('home.amount'):</label>
                            <input class="form-control" type="text"   name="amount"  required>
                        </div>
                        <div class="form-group col-lg-12" id="invoice_file">
                            <label for="invoice_file" class="col-form-label">ملف الفاتورة:</label>
                            <input class="form-control" type="file" name="invoice_file" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" >{{ trans('home.save') }}</button>
                        <button type="button" class="btn" data-bs-dismiss="modal">{{ trans('home.close') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
      <!--modal send_call-->
    <div class="modal fade" id="send_call_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <form method="post" action="{{url('admin/crm/clients/'.$client->id.'/send_sms') }}" >
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('home.send_call')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body">
                    <div class="form-group">
                        <label for="message-text" class="col-form-label">@lang('home.details'):</label>
                        <textarea class="form-control" rows="4" name="message" id="message-text" required></textarea>
                    </div>
                    <input type="hidden" name="type" value="call">
                   <div class="form-group mb-3">
                        <label for="parent">{{trans('home.phone')}}</label>
                        <select class="form-control select2" name="phone">
                            <option value="{{$client->phone}}">{{$client->phone }}</option>
                            @if($client->phone2)<option value="{{$client->phone2}}">{{$client->phone2 }}</option>@endif
                        </select>
                    </div>
        
                   <div class="form-group mb-3">
                        <div class="form-check">
                          <input class="form-check-input" type="radio" name="send_to_client" value="answered" id="sendToClient" required>
                          <label class="form-check-label mr-4" for="sendToClient">
                            {{trans('home.answered')}}
                          </label>
                        </div>
                            
                        <div class="form-check">
                          <input class="form-check-input" type="radio" name="send_to_client" value="not_answered" id="notSendToClient" required>
                          <label class="form-check-label mr-4" for="notSendToClient">
                            {{trans('home.didnt_answered')}}
                          </label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                    <button type="button" class="btn" data-bs-dismiss="modal">@lang('home.close')</button>
                </div>
            </div>
        </form>
      </div>
    </div>
      <!--modal sms app-->
    <div class="modal fade" id="send_sms_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <form method="post" action="{{url('admin/crm/clients/'.$client->id.'/send_sms') }}" >
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('home.send_sms')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label for="message-text" class="col-form-label">@lang('home.message'):</label>
                        <textarea class="form-control" rows="4" name="message" id="message-text" required></textarea>
                    </div>
                    <input type="hidden" name="type" value="sms">
                   <div class="form-group mb-3">
                        <label for="parent">{{trans('home.phone')}}</label>
                        <select class="form-control select2" name="phone">
                            <option value="{{$client->phone}}">{{$client->phone }}</option>
                            @if($client->phone2)<option value="{{$client->phone2}}">{{$client->phone2 }}</option>@endif
                        </select>
                    </div>
        
                   <div class="form-group mb-3">
                           <div class="form-check">
                              <input class="form-check-input" type="radio" name="send_to_client" value="sent" id="sendToClient" required>
                              <label class="form-check-label mr-4" for="sendToClient">
                                {{trans('home.send_to_client')}}
                              </label>
                            </div>
                            
                            <div class="form-check">
                              <input class="form-check-input" type="radio" name="send_to_client" value="saved" id="notSendToClient" required>
                              <label class="form-check-label mr-4" for="notSendToClient">
                                {{trans('home.save_only')}}
                              </label>
                            </div>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                    <button type="button" class="btn" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </form>
      </div>
    </div>
    <!--modal whats app-->
     <div class="modal fade" id="send_whatsapp_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <form method="post" action="{{url('admin/crm/clients/'.$client->id.'/send_sms') }}" >
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('home.send_whatsapp')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body">
                      <input type="hidden" name="type" value="whatsapp">
                      <div class="form-group mb-3">
                            <label for="message-text" class="col-form-label">@lang('home.message'):</label>
                            <textarea class="form-control" rows="4" name="message" id="message-text" required></textarea>
                      </div>
                       <div class="form-group mb-3">
                            <label for="parent">{{trans('home.whatsapp')}}</label>
                            <select class="form-control select2" name="phone">
                                <option value="{{$client->whatsapp}}" selected>{{$client->whatsapp }}</option>
                            </select>
                        </div>
            
                       <div class="form-group mb-3">
                           <div class="form-check">
                              <input class="form-check-input" type="radio" name="send_to_client" value="sent" id="sendToClient" required>
                              <label class="form-check-label mr-4" for="sendToClient">
                                {{trans('home.send_to_client')}}
                              </label>
                            </div>
                            
                            <div class="form-check">
                              <input class="form-check-input" type="radio" name="send_to_client" value="saved" id="notSendToClient" required>
                              <label class="form-check-label mr-4" for="notSendToClient">
                                {{trans('home.save_only')}}
                              </label>
                            </div>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                    <button type="button" class="btn" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </form>
      </div>
    </div>
    <!--modal mail-->
     <div class="modal fade" id="send_email_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <form method="post" action="{{url('admin/crm/clients/'.$client->id.'/send_sms') }}" >
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('home.send_email')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body">
                    <input type="hidden" name="type" value="email">
                    <div class="form-group">
                        <label for="message-text" class="col-form-label">@lang('home.message'):</label>
                        <textarea class="form-control" rows="4" name="message" id="message-text" required></textarea>
                    </div>
                    <div class="form-group mb-3">
                       <div class="form-check">
                          <input class="form-check-input" type="radio" name="send_to_client" value="sent" id="sendToClient" required>
                          <label class="form-check-label mr-4" for="sendToClient">
                            {{trans('home.send_to_client')}}
                          </label>
                        </div>
                        
                        <div class="form-check">
                          <input class="form-check-input" type="radio" name="send_to_client" value="saved" id="notSendToClient" required>
                          <label class="form-check-label mr-4" for="notSendToClient">
                            {{trans('home.save_only')}}
                          </label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                    <button type="button" class="btn" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </form>
      </div>
    </div>
     <!--modal meeting-->
     <div class="modal fade" id="add_meating_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-xl" role="document">
        <form method="post" action="{{url('admin/crm/clients/'.$client->id.'/send_sms') }}" >
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('home.add_meating')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body row">
                    <input type="hidden" name="type" value="meeting">
                    
                    <div class="form-group col-md-4 ">
                        <label for="parent">{{trans('home.team')}}</label>
                        <select class="form-control select2" name="team[]" multiple>
                            <option value="{{auth()->user()->id}}" selected>{{auth()->user()->name() }}</option>
                             @foreach($crm_employees as $crm_employee)
                                <option value="{{$crm_employee->id}}">{{$crm_employee->name() }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-4">
                        <label for="title" class="col-form-label">@lang('home.title'):</label>
                        <input class="form-control"  name="title" id="title" placeholder="@lang('home.title')" required></input>
                    </div>
                    <div class="form-group col-4 ">
                        <label for="date" class="col-form-label">@lang('home.date'):</label>
                        <input class="form-control" type="date"  name="date" id="date" min="{{ date('Y-m-d') }}" required></input>
                    </div>
                    <div class="form-group col-4 ">
                        <label for="start_at" class="col-form-label">@lang('home.start_at'):</label>
                        <input class="form-control" type="time"  name="start_date" id="start_at"  ></input>
                    </div>
                    <div class="form-group col-4 ">
                        <label for="end_at" class="col-form-label">@lang('home.end_at'):</label>
                        <input class="form-control" type="time"  name="end_date" id="end_at"  ></input>
                    </div>
                    
                    <div class="form-group col-md-4 m-auto">
                        <label for="parent">{{trans('home.meeting_type')}}</label>
                        <select class="form-control select2" name="meeting_type" required>
                            <option value="company_site">{{trans('home.company_site')}}</option>
                            <option value="client_site">{{trans('home.client_site')}}</option>
                            <option value="online">{{trans('home.online')}}</option>
                        </select>
                    </div>
                    <div id="meeting_details" class="row mt-3">
                        
                    </div>
                    
                    
                    <div class="form-group">
                        <label for="message-text" class="col-form-label">@lang('home.note')-@lang('home.team') :</label>
                        <textarea class="form-control" rows="2" name="note" id="message-text" ></textarea>
                    </div>
                    <div class="form-group mb-3">
                       <div class="form-check">
                          <input class="form-check-input" type="radio" name="send_to_client" value="sent" id="sendToClient" required>
                          <label class="form-check-label mr-4" for="sendToClient">
                            {{trans('home.send_to_client')}}
                          </label>
                        </div>
                        
                        <div class="form-check">
                          <input class="form-check-input" type="radio" name="send_to_client" value="saved" id="notSendToClient" required>
                          <label class="form-check-label mr-4" for="notSendToClient">
                            {{trans('home.save_only')}}
                          </label>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                    <button type="button" class="btn" data-bs-dismiss="modal">@lang('home.cancel')</button>
                </div>
            </div>
        </form>
      </div>
    </div>
    <!--modal task-->
    <div class="modal fade" id="add_task_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <form method="post" action="{{url('admin/crm/clients/'.$client->id.'/send_sms') }}" >
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('home.add_task')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body row">
                    <input type="hidden" name="type" value="task">
                    
                    <div class="form-group col-md-6 ">
                        <label for="parent">{{trans('home.task_type')}}</label>
                        <select class="form-control select2" name="task_type" >
                            <option value="call">  {{ trans('home.call') }}</option>
                            <option value="sms">  {{ trans('home.send_sms') }}</option>
                            <option value="whatsapp">  {{ trans('home.send_whatsapp') }}</option>
                            <option value="email">  {{ trans('home.send_email') }}</option>
                        </select>
                    </div>
                    <div class="form-group col-md-6 ">
                        <label for="parent">{{trans('home.priority')}}</label>
                        <select class="form-control select2" name="priority" >
                            <option value="very_important">  {{ trans('home.very_important') }}</option>
                            <option value="important">  {{ trans('home.important') }}</option>
                            <option value="not_important">  {{ trans('home.not_important') }}</option>
                        </select>
                    </div>
                    
                    <div class="form-group col-lg-12 ">
                        <label for="date" class="col-form-label">@lang('home.date'):</label>
                        <input class="form-control" type="date"  name="date" id="date" min="{{ date('Y-m-d') }}" required></input>
                    </div>
                    <div class="form-group col-lg-12 ">
                        <label for="time" class="col-form-label">@lang('home.time'):</label>
                        <input class="form-control" type="time"  name="time" id="time"  ></input>
                    </div>
                    
                    <div class="form-group col-lg-12 ">
                        <label for="notify_date" class="col-form-label">@lang('home.notify_date'):</label>
                        <input class="form-control" type="date"  name="notify_date" id="notify_date" min="{{ date('Y-m-d') }}" required></input>
                    </div>
                    <div class="form-group col-lg-12 ">
                        <label for="notify_time" class="col-form-label">@lang('home.notify_time'):</label>
                        <input class="form-control" type="time"  name="notify_time" id="notify_time"  ></input>
                    </div>
                    <div class="form-group">
                        <label for="parent">{{trans('home.responsible_employee')}}</label>
                        <select class="form-control select2" name="employee[]" multiple required>
                            <option value="{{auth()->user()->id}}" selected>{{auth()->user()->name() }}</option>
                            @if(auth()->user()->type=="admin")
                                @foreach($crm_employees_task->where('id') as $crm_employee)
                                    <option value="{{$crm_employee->id}}">{{$crm_employee->name() }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="message-text" class="col-form-label">@lang('home.note')  :</label>
                        <textarea class="form-control" rows="2" name="note" id="message-text" required></textarea>
                    </div>
                    
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                    <button type="button" class="btn" data-bs-dismiss="modal">@lang('home.cancel')</button>
                </div>
            </div>
        </form>
      </div>
    </div>
       <!--modal add_new_payment-->
    <div class="modal fade" id="add_new_training" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <form method="post" action="{{route('save_payment',$client->id) }}" enctype="multipart/form-data">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('home.add_new_training')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    
                <div class="modal-body row">
                    <input type="hidden" id="client_id" name="client_id" value="{{$client->id}}">
                    <div class="form-group mb-3">
                        <label for="parent">{{trans('home.training')}}</label>
                        <select class="form-control select2" name="training_id">
                            @foreach($trainings as $training)
                                <option value="{{$training->id}}">{{$training->{'name_'.$lang} }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">@lang('home.save') </button>
                    <button type="button" class="btn" data-bs-dismiss="modal">@lang('home.cancel')</button>
                </div>
            </div>
        </form>
      </div>
    </div>
    
@endsection
@section('script')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


    <script>
        $(document).on('click', '.delete-training', function(e) {
            e.preventDefault();
            
            var itemId = $(this).data('id'); // Get the item ID from the data attribute
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: "btn btn-success",
                    cancelButton: "btn btn-danger"
                },
                buttonsStyling: false
            });
            
            swalWithBootstrapButtons.fire({
                title: "{{ __('home.are you sure') }}",
                text: "{{ __('home.to delete this item?') }}",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "{{ __('home.yes') }}, {{ __('home.delete') }}!",
                cancelButtonText: "{{ __('home.no') }}, {{ __('home.cancel') }}!",
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ url('admin/crm/client-training', '') }}/" + itemId + "/delete",
                        type: 'GET',
                        data: {
                            _token: '{{ csrf_token() }}', // Include CSRF token
                            id: itemId
                        },
                        success: function(response) {
                            swalWithBootstrapButtons.fire({
                                title: "{{ __('home.deleted') }}!",
                                text: "{{ __('home.the item has been deleted') }}.",
                                icon: "success"
                            });
                            location.reload()
                            
                        },
                        error: function(response) {
                            swalWithBootstrapButtons.fire({
                                title: "{{ __('home.error') }}!",
                                text: "{{ __('home.something went wrong') }}.",
                                icon: "error"
                            });
                        }
                    });
                }
            });
        });
    </script>
    <script>
        $('.add_invoice_item').on('click',function () {
            let invoice_id = $(this).data('invoice_id');
            let invoice_number = $(this).data('invoice_number');
    
            // Populate modal with data
            $('#invoice_id').val(invoice_id);
            $('#paymentModalLabel').html(invoice_number);
            $('#paymentModal').modal('show');
        });
    </script>

    <script>
        $('.modal').on('shown.bs.modal', function () {
            // Initialize Select2 with the 'tags' option enabled
            $('.select2').select2({
                width: '100%', // Ensures proper width inside modal
                dropdownParent: $(this) // Ensures dropdown stays within the modal
            });
            // $('.select2').on('select2:unselecting', function(e) {
            //     var id = e.params.args.data.id; // Get the ID of the option being unselected
            //     var $option = $(this).find('option[value="' + id + '"]');
                
            //     if ($option.is('[disabled]')) {
            //         e.preventDefault(); // Prevent the unselect event
            //     }
            // });
        });

    </script>
    <script>
        $(document).ready(function() {
            // Function to update meeting details based on selected meeting type
            function updateMeetingDetails() {
                var meetingType = $('select[name="meeting_type"]').val();
                var meetingDetails = $('#meeting_details');
        
                // Clear previous details
                meetingDetails.empty();
        
                // Add fields based on selected meeting type
                if (meetingType === 'client_site') {
                    meetingDetails.append(
                        '<div class="form-group col-lg-6">' +
                        '    <label for="location">{{trans("home.location")}}</label>' +
                        '    <input type="text" class="form-control" name="location" required>' +
                        '</div>' +
                        '<div class="form-group col-lg-6">' +
                        '    <label for="address">{{trans("home.address_meeting")}}</label>' +
                        '    <input type="text" class="form-control" name="address" required>' +
                        '</div>'
                    );
                } else if (meetingType === 'online') {
                    meetingDetails.append(
                        '<div class="form-group">' +
                        '    <label for="zoom_link">{{trans("home.zoom_link")}}</label>' +
                        '    <input type="text" class="form-control" name="zoom_link" required>' +
                        '</div>'
                    );
                }
            }
        
            // Initialize the Select2 plugin
            $('.select2').select2();
        
            // Update meeting details when the meeting type changes
            $('select[name="meeting_type"]').on('change', function() {
                updateMeetingDetails();
            });
        
            // Trigger update on page load to show details for the initial selection
            updateMeetingDetails();
        });

    </script>
    <script>
        // Handle delete button click event
        $(document).on('click', '.delete-btn', function (e) {
            e.preventDefault();
    
            var messageId = $(this).data('id'); // Get the data-id from the clicked button
    
            // Show SweetAlert confirmation
            Swal.fire({
                title: '{{__('home.Are you sure you want to delete that ?')}}',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '{{__('home.delete')}}',
                cancelButtonText: '{{__('home.cancel')}}'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
    
                    $.ajax({
                        url: "{{route('delete_crm_sms') }}" ,
                        type: 'POST',
                        data: {id: messageId},
                        success: function () {
                            location.reload();
                        }
                    }); 
                }
            });
        });
        
    </script>
    <script>
        // $('.payment-show').on('click',function () {
        //     let paymentId = $(this).data('id');
        //     let paymentType = $(this).data('type');
        //     let paymentAmount = $(this).data('amount');
        //     let invoiceUrl = $(this).data('invoice-url');
        //     let invoice = $(this).data('invoice');
        //     let invoiceNumber = $(this).data('invoice_number');
        //     let baseUrl = "{{ url('uploads/invoices/source/')}}"; 
        //     let invoiceUrlWithNumber = baseUrl +'/'+ invoice;
        //     var client_training_id = $(this).data('client_training_id'); 
        //     $('#client_training_id').val(client_training_id);
    
        //     // Populate modal with data
        //     $('#payment-id').text(paymentId);
        //     $('#payment-type').text(paymentType);
        //     $('#payment-amount').text(paymentAmount);
        //     $('#invoice_number').text(invoiceNumber);
        //     $('#paymentModalLabel').text(invoiceNumber);
        //     $('#invoice').text(invoice);
        //     $('#download-invoice').attr('href', invoiceUrlWithNumber).attr('download', invoiceNumber + '.pdf'); ;
    
        //     // Show modal
        //     $('#paymentModal').modal('show');
        // });
    </script>
@endsection



