@extends('layouts.admin')
<title>{{trans('home.add_client')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header row">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.add_client')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('admin/crm/clients')}}">{{trans('home.clients')}}</a></li>
                </ol>
            </div>
            <form class="row" action="{{ route('crm_client.upload') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="custom-file col-md-6 mb-3">
                    <input type="file" class="file" id="inputGroupFile01" name="clients_file">
                    <label class="custom-file-label" for="inputGroupFile01">{{trans('home.add_client_excel')}}</label>
                </div>
                <div class="col-md-6 mb-3">
                    <button type="submit" class="btn ripple btn-primary mb-2"><i class="fas fa-plus-circle"></i>
                        {{trans('home.add_client_excel')}}
                    </button> 
                    <a href="{{Helper::uploadedImagesPath('templates','crm_client.xlsx')}}" 
                        class="btn ripple btn-primary text-white mb-2"><i class="fe fe-arrow-down"></i>
                        {{trans('home.download_template')}}
                    </a> 
                </div>
             </form>

        </div>
        <!-- End Page Header -->

        @if(session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        
           <!-- End Page Header -->
    <form method="post" action="{{route('store_single_Client')}}" id="client_form">
        @csrf
   
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.add_client')}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="form-group col-xl-4 col-md-6">
                                <label class="">{{trans('home.name')}}</label>
                                <input class="form-control" name="name" type="text" placeholder="{{trans('home.name')}}" required>
                            </div>

                            
                            <div class="form-group col-xl-4 col-md-6">
                                <label class="">{{trans('home.email')}}</label>
                                <input class="form-control" name="email" type="email" placeholder="{{trans('home.email')}}" required>
                            </div>
                            <div class="form-group col-xl-4 col-md-6">
                                <label class="">{{trans('home.phone')}}</label>
                                <input class="form-control" name="phone" type="text" placeholder="{{trans('home.phone')}}">
                            </div>
                            {{--
                            <div class="form-group col-xl-4 col-md-6">
                                <label class="">{{trans('home.phone')}}2</label>
                                <input class="form-control" name="phone2" type="text" placeholder="{{trans('home.phone')}}2">
                            </div>
                            --}}
                            <div class="form-group col-xl-4 col-md-6">
                                <label class="">{{trans('home.whatsapp')}}</label>
                                <input class="form-control" name="whatsapp" type="text" placeholder="{{trans('home.whatsapp')}}">
                            </div>
                            <div class="form-group col-xl-4 col-md-6">
                                <label class="">{{trans('home.ssn')}}/ الاقامة</label>
                                <input class="form-control" name="ssn" type="text" placeholder="{{trans('home.ssn')}}">
                            </div>
                            <div class="form-group col-xl-4 col-md-6">
                                <label class="">{{trans('home.nationality')}}</label>
                                <input class="form-control" name="nationality" type="text" placeholder="{{trans('home.nationality')}}" >
                            </div>
                            <div class="form-group col-xl-4 col-md-6">
                                <label class="">{{trans('home.qualification')}}</label>
                                 <select class="form-control select2" name="qualification">
                                    <option value= "متوسط">متوسط</option>
                                    <option value="ثانوى">ثانوى</option>
                                    <option value="دبلوم">دبلوم</option>
                                    <option value="دبلوم عالى">دبلوم عالى</option>
                                    <option value="جامعى">جامعى</option>
                                    <option value="ماجستير">ماجستير</option>
                                    <option value="دكتوراه">دكتوراه</option>
                                </select>
                            </div>
                            <div class="form-group col-xl-4 col-md-6">
                                <label class="">المسمى الوظيفى</label>
                                <input class="form-control" name="job" type="text" placeholder="المسمى الوظيفى" >
                            </div>
                            <div class="form-group col-xl-4 col-md-6">
                                <label for="parent">{{trans('home.client_status')}}</label>
                                <select class="form-control select2" name="status_id">
                                    @foreach($statuses as $status)
                                        <option value="{{$status->id}}">{{$status->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            <div class="form-group col-xl-4 col-md-6">
                                <label for="parent">{{trans('home.training')}}</label>
                                <select class="form-control select2" name="training_id[]" multiple>
                                    @foreach($trainings as $training)
                                        <option value="{{$training->id}}">{{$training->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            {{--
                            <div class="form-group col-xl-4 col-md-6">
                                <label for="parent">{{trans('home.company')}}</label>
                                <select class="form-control select2" name="company_id">
                                        <option value="">@lang('home.no_company')</option>
                                    @foreach($companies as $company)
                                        <option value="{{$company->id}}">{{$company->name }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            --}}
                            <div class="form-group col-xl-4 col-md-6">
                                <label for="parent">{{trans('home.come_from')}}</label>
                                <select class="form-control select2" name="come_from">
                                    @foreach($sources as $source)
                                    <option value="{{$source->id}}">{{$source->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            @if(auth()->user()->type=="admin")
                                <div class="form-group col-xl-4 col-md-6">
                                    <label for="parent">{{trans('home.responsible_employee')}}</label>
                                    <select class="form-control select2 "  name="responsible_employee">
                                            <option  selected>{{ auth()->user()->name()}}</option>
                                        @foreach($crm_employees as $crm_employee)
                                            <option value="{{$crm_employee->id}}">{{$crm_employee->name() }}</option>
                                        @endforeach    
                                    </select>
                                </div>
                            @else
                                <div class="form-group col-xl-4 col-md-6">
                                    <label for="parent">{{trans('home.responsible_employee')}}</label>
                                    <select class="form-control "  name="responsible_employee" readonly>
                                        <option  value="{{auth()->user()->id}}" selected >{{ auth()->user()->name()}}</option>
                                    </select>
                                </div>
                            @endif
                            <div class="form-group col-xl-4 col-md-6">
                                <label for="parent">{{trans('home.country')}}</label>
                                <select class="form-control select2 country"  name="country_id">
                                        <option disabled selected>{{__('home.country')}}</option>
                                    @foreach($countries as $country)
                                        <option value="{{$country->id}}">{{$country->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            
                            <div class="form-group col-xl-4 col-md-6">
                                <label for="parent">{{trans('home.area')}}</label>
                                <select class="form-control select2 region"  name="area_id">
                                    <option disabled selected>{{__('home.area')}}</option>
                                </select>
                            </div>
                            <div class="form-group col-xl-4 col-md-6">
                                <label for="parent">{{trans('home.region')}}</label>
                                <select class="form-control select2 area"  name="region_id">
                                    <option disabled selected>{{__('home.region')}}</option>
                                </select>
                            </div>

                        </div>           
                        <!-- Row-->
                        <div class="w-100 mt-4 text-center">
                            <a data-reset="save" class="save btn btn-primary  text-white">
                                <i class="icon-note"></i> {{ trans('home.save') }}
                            </a>
                            <a data-reset="save_and_another" class="save btn btn-success text-white">
                                <i class="icon-note"></i> {{ trans('home.save_and_another') }}
                            </a>
                            <a href="{{ url('/admin/crm/clients') }}">
                                <button type="button" class="btn  mr-1">
                                    <i class="icon-trash"></i> {{ trans('home.cancel') }}
                                </button>
                            </a>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->



        
    </form>
    </div>
@endsection

@section('script')
    <script>
        $('.save').click(function(event) {
            event.preventDefault(); 
            var formData = $('#client_form').serialize();
            var reset = $(this).data('reset');
    
            $.ajax({
                type: 'POST',
                url: "{{ route('store_single_Client') }}",
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}' // Include CSRF token for security
                },
                success: function(response) {
                    console.log(response);
                    if (response.status === 'error') {
                        Swal.fire({
                            icon: 'error',
                            title: '{{ trans("home.error") }}',
                            text: response.message
                        });
                    } else if (response.status === 'success') {
                        Swal.fire({
                            icon: 'success',
                            title: '{{ trans("home.registeration_success") }}',
                            text: response.message
                        }).then(() => {
                            if(reset==="save_and_another"){
                                window.location.reload(); // Reload the page after successful submission
                            }else{
                             window.location.replace("{{ url('admin/crm/clients') }}");
                            }
                        });
                    }
                },
                error: function(xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.statusText;
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: errorMessage // Display a user-friendly error message
                    });
                }
            });
        });
    </script>
       
    <!--areas and regions-->
     <script>
        $('.country').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('getAreas')  }}',
                data: {id: id},
                success: function (data) {
                    var html = '';
                    html += '<option></option>'
                    for (var i = 0; i < data.length; i++) {
                        html += '<option  value="' + data[i].id + '">@if(\App::getLocale() == 'en')' + data[i].name_en + ' @else ' + data[i].name_ar + ' @endif</option>';
                    }
                    region.html(html);
                    $('#select_country').html('');
                }
            });
        });

        $('.region').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('getRegions')  }}',
                data: {id: id},
                success: function (data) {
                    var html = '';
                    html += '<option></option>'
                    for (var i = 0; i < data.length; i++) {
                        html += '<option  value="' + data[i].id + '">@if(\App::getLocale() == 'en')' + data[i].name_en + ' @else ' + data[i].name_ar + ' @endif</option>';
                    }
                    area.html(html);
                    $('.shipping_total').html("{{ __('home.select your area first')}}");
                    $('#select_region').html('');
                    
                }
            });
        });

    </script>

@endsection
