@extends('layouts.admin')
<title>{{trans('home.my_tasks')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm')}}</h2>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.my_tasks')}}</h2>
            </div>
            <div class="row btn btn-list gap-3 mx-3">
                <a href="{{url('admin/crm/add-employee-task')}}"><button class="btn ripple btn-primary">
                    <i class="fas fa-plus-circle"></i> {{trans('home.add_employee_task')}}</button> 
                </a>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th>{{trans('home.crm_employee')}}</th>
                                    <th>{{trans('home.task_status')}}</th>
                                    <th>{{trans('home.priority')}}</th>
                                    <th>{{trans('home.date')}}</th>
                                    <th>{{trans('home.time')}}</th>
                                    <th>{{trans('home.task_type')}}</th>
                                    <th>{{trans('home.client')}}</th>
                                    <th>{{trans('home.phone')}}</th>
                                    <th>{{trans('home.email')}}</th>
                                    <th>{{trans('home.note')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($tasks as $my_task)
                                    <tr id="{{$my_task->id}}">
                                        <td>@foreach($my_task->employees() as $employee)
                                            <span class=" badge px-3 py-1 rounded badge-success">
                                                {{ $employee->name() }}
                                            </span>
                                            
                                            @endforeach
                                        </td>
                                        <td>
                                            <span class=" badge px-3 py-1 rounded
                                            {{$my_task->status === 'current'?'badge-warning ':($my_task->status === 'delayed'?'badge-danger':'badge-success')}}">
                                                {{ __('home.'.$my_task->status) }}
                                            </span>
                                        </td>
                                        <td> {{__('home.'.$my_task->priority)}}</td>
                                        <td> {{$my_task->date}}</td>
                                        <td>{{$my_task->time? \Carbon\Carbon::createFromFormat('H:i', $my_task->time)->format('h:i A') :''}}</td>
                                        <td> {{$my_task->task_type}}</td>
                                        <td> {{$my_task->crm_sms->client?->name}}</td>
                                        <td> {{$my_task->crm_sms->client->phone??$my_task->crm_sms->client?->phone2}}</td>
                                        <td> {{$my_task->crm_sms->client?->email}}</td>
                                        <td> {{$my_task->note}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection