@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_employee_task')}}</title>
@endsection
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.add_employee_task')}}</h2>
            </div>
        </div>
        <!-- End Page Header -->
        


        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <form method="post" action="{{route('store_employee_task') }}" >
                    @csrf
                        <div class="card-body">
                            <div class="row">
                                <input type="hidden" name="type" value="task">
                        
                                <div class="form-group col-md-6 ">
                                    <label for="parent">{{trans('home.task_type')}}</label>
                                    <select class="form-control select2" name="task_type" >
                                        <option value="call">  {{ trans('home.call') }}</option>
                                        <option value="sms">  {{ trans('home.send_sms') }}</option>
                                        <option value="whatsapp">  {{ trans('home.send_whatsapp') }}</option>
                                        <option value="email">  {{ trans('home.send_email') }}</option>
                                    </select>
                                </div>
                                <div class="form-group col-md-6 ">
                                    <label for="parent">{{trans('home.priority')}}</label>
                                    <select class="form-control select2" name="priority" >
                                        <option value="very_important">  {{ trans('home.very_important') }}</option>
                                        <option value="important">  {{ trans('home.important') }}</option>
                                        <option value="not_important">  {{ trans('home.not_important') }}</option>
                                    </select>
                                </div>
                                
                                <div class="form-group col-lg-6 ">
                                    <label for="date" class="col-form-label">@lang('home.date'):</label>
                                    <input class="form-control" type="date"  name="date" id="date" min="{{ date('Y-m-d') }}" required></input>
                                </div>
                                <div class="form-group col-lg-6 ">
                                    <label for="time" class="col-form-label">@lang('home.time'):</label>
                                    <input class="form-control" type="time"  name="time" id="time"  ></input>
                                </div>
                                
                                <div class="form-group col-lg-6 ">
                                    <label for="notify_date" class="col-form-label">@lang('home.notify_date'):</label>
                                    <input class="form-control" type="date"  name="notify_date" id="notify_date" min="{{ date('Y-m-d') }}" required></input>
                                </div>
                                <div class="form-group col-lg-6 ">
                                    <label for="notify_time" class="col-form-label">@lang('home.notify_time'):</label>
                                    <input class="form-control" type="time"  name="notify_time" id="notify_time"  ></input>
                                </div>
                                <div class="form-group">
                                    <label for="parent">{{trans('home.responsible_employee')}}</label>
                                    <select class="form-control select2" name="employee[]" multiple required>
                                            @foreach($crm_employees as $crm_employee)
                                                <option value="{{$crm_employee->id}}">{{$crm_employee->name() }}</option>
                                            @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="message-text" class="col-form-label">@lang('home.note')  :</label>
                                    <textarea class="form-control" rows="2" name="note" id="message-text" required></textarea>
                                </div>
                            </div>    
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">@lang('home.cancel')</button>
                                <button type="submit" class="btn btn-primary">@lang('home.send') </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
@endsection



