@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.course-features')}}</title>
@endsection
@section('content')

<div class="container-fluid">
            <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.course-features')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/course-features')}}">{{trans('home.course-features')}}</a></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
    @if(session()->has('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session()->pull('success') }} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open(['method'=>'PATCH','url' => 'admin/course-features', 'data-toggle'=>'validator']) !!}
                                    <div class="row">
                                        <div class="tab-pane mb-3 col-12" id="values">
                                            <div class="col-md-12 mb-3 text-center row justify-content-between ">
                                                <h6 class="badge-soft-primary col-md-8 p-2 rounded">{{trans('home.learn points')}}</h6>
                                            <a href="javascript:void(0);" class="add_button btn-primary btn col-auto" title="Add field"><i class="fas fa-plus-square"></i></a>								

                                            </div>  
                                            <div class="field_wrapper">
                                                @if(count($points) > 0)
                                                    @foreach($points as $key=>$point)
                                                        <div class="row">
                                                            <div  class="col-md-5 mb-3"> 
                                                                <label for="point">{{trans('home.point_en')}}</label>
                                                                <input type="text"  class="form-control" placeholder="{{trans('home.point_en')}}" readonly value="{{$point->text_en}}">
                                                            </div>
                                                            <div  class="col-md-5 mb-3"> 
                                                                <label for="point">{{trans('home.point_ar')}}</label>
                                                                <input type="text"  class="form-control" placeholder="{{trans('home.point_ar')}}" readonly value="{{$point->text_ar}}">
                                                            </div>

                                                            <div class="form-group col-md-2">
                                                                <button type="button" style="margin-top: 28px;" class="btn" data-bs-toggle="modal" data-bs-target="#pointModel_{{$key}}"><i class="fas fa-edit"></i></button>
                                                                <button type="button" style="margin-top: 28px;" class="btn rmv" data-type="point" data-id="{{$point->id}}" id="type-error"><i class="fas fa-trash-alt"></i></button>
                                                            </div>
                                                        </div>
                                                    @endforeach  
                                                @else
                                                    <div class="row">
                                                        <div class="col-md-6 mb-3"> 
                                                            <label for="point_en">{{trans('home.point_en')}}</label>
                                                            <input type="text" required  class="form-control" placeholder="{{trans('home.point_en')}}" name="point_en[]">
                                                        </div>

                                                        <div class="col-md-6 mb-3">
                                                            <label for="point_ar">{{trans('home.point_ar')}}</label>
                                                            <input type="text" required class="form-control" placeholder="{{trans('home.point_ar')}}" name="point_ar[]">
                                                        </div> 
                                                    </div>
                                                @endif
                                            </div>       
                                        </div>
                                        
                                        <div class="tab-pane mb-3 col-12" id="values">
                                            <div class="col-md-12 mb-3 text-center row justify-content-between ">
                                                <hr>
                                                <h6 class="badge-soft-primary col-md-8 p-2 rounded">{{trans('home.Include material')}}</h6>
                                                <a href="javascript:void(0);" class="add_button_material btn-primary col-auto btn" title="Add field"><i class="fas fa-plus-square"></i></a>								

                                            </div> 
                                            <div class="field_wrapper_material">
                                                @if(count($materials) > 0)
                                                    @foreach($materials as $key=>$material)
                                                        <div class="row">
                                                            <div  class="col-md-5 mb-3"> 
                                                                <label for="material">{{trans('home.material_en')}}</label>
                                                                <input type="text"  class="form-control" placeholder="{{trans('home.material_en')}}" readonly value="{{$material->text_en}}">
                                                            </div>
                                                            <div  class="col-md-5 mb-3"> 
                                                                <label for="material">{{trans('home.material_ar')}}</label>
                                                                <input type="text"  class="form-control" placeholder="{{trans('home.material_ar')}}" readonly value="{{$material->text_ar}}">
                                                            </div>

                                                            <div class="form-group col-md-2">
                                                                <button type="button" style="margin-top: 28px;" class="btn" data-bs-toggle="modal" data-bs-target="#materialModel_{{$key}}"><i class="fas fa-edit"></i></button>
                                                                <button type="button" style="margin-top: 28px;" class="btn rmv" data-type="material" data-id="{{$material->id}}" id="type-error"><i class="fas fa-trash-alt"></i></button>
                                                            </div>
                                                        </div>
                                                    @endforeach  
                                                @else
                                                    <div class="row">
                                                        <div class="col-md-6 mb-3"> 
                                                            <label for="material_en">{{trans('home.material_en')}}</label>
                                                            <input type="text" required class="form-control" placeholder="{{trans('home.material_en')}}" name="material_en[]">
                                                        </div>

                                                        <div class="col-md-6 mb-3">
                                                            <label for="material_ar">{{trans('home.material_ar')}}</label>
                                                            <input type="text" required class="form-control" placeholder="{{trans('home.material_ar')}}" name="material_ar[]">
                                                        </div> 
                                                    </div>  
                                                @endif
                                            </div>       
                                        </div>

                                        <div class="col-md-12 mb-3 " id="values">
                                            <div class="col-md-12 mb-3 text-center row justify-content-between ">
                                                <hr>
                                                <h6 class="badge-soft-primary col-md-8 p-2 rounded">{{trans('home.requirments')}}</h6>
                                                <a href="javascript:void(0);" class="add_button_require btn-primary col-auto btn" title="Add field"><i class="fas fa-plus-square"></i></a>								

                                            </div> 
                                            <div class="field_wrapper_require">
                                                @if(count($requirments) > 0)
                                                    @foreach($requirments as $key=>$require)
                                                        <div class="row">
                                                            <div  class="col-md-5 mb-3"> 
                                                                <label for="require">{{trans('home.require_en')}}</label>
                                                                <input type="text"  class="form-control" placeholder="{{trans('home.require_en')}}" readonly value="{{$require->text_en}}">
                                                            </div>
                                                            <div  class="col-md-5 mb-3"> 
                                                                <label for="require">{{trans('home.require_ar')}}</label>
                                                                <input type="text"  class="form-control" placeholder="{{trans('home.require_ar')}}" readonly value="{{$require->text_ar}}">
                                                            </div>

                                                            <div class="form-group col-md-2">
                                                                <button type="button" style="margin-top: 28px;" class="btn" data-bs-toggle="modal" data-bs-target="#requireModel_{{$key}}"><i class="fas fa-edit"></i></button>
                                                                <button type="button" style="margin-top: 28px;" class="btn rmv" data-type="require" data-id="{{$require->id}}" ><i class="fas fa-trash-alt"></i></button>
                                                            </div>
                                                        </div>
                                                    @endforeach  
                                                @else
                                                    <div class="row">
                                                        <div class="col-md-6 mb-3"> 
                                                            <label for="require_en">{{trans('home.require_en')}}</label>
                                                            <input type="text" required class="form-control" placeholder="{{trans('home.require_en')}}" name="require_en[]">
                                                        </div>
    
                                                        <div class="col-md-6 mb-3">
                                                            <label for="require_ar">{{trans('home.require_ar')}}</label>
                                                            <input type="text" required class="form-control" placeholder="{{trans('home.require_ar')}}" name="require_ar[]">
                                                        </div> 
                                                    </div>  
                                                @endif
                                            </div>       
                                        </div>                                                                         
                                    </div>
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                        <a href="{{url('/admin')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                    </div>


                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>


    {{-- points models --}}
    @foreach($points as $key=>$point)
        <div class="modal fade text-left" id="pointModel_{{$key}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title" id="myModalLabel34">{{trans('home.edit')}}</h3>
                        <a type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <h5 class="modal-title" id="myModalLabel34">X</h5>
                        </a>
                    </div>
                    <form action="{{route('updateCourseFeatureItem')}}" method="post">
                        @csrf
                        <div class="modal-body">
                            <div class="row">
                                <div class="form-group col-md-6"> 
                                    <label for="text_en">{{trans('home.text_en')}}</label>
                                    <input type="text"  class="form-control" placeholder="{{trans('home.text_en')}}" name="text_en" value="{{$point->text_en}}">
                                </div>
                                <div class="form-group col-md-6"> 
                                    <label for="text_ar">{{trans('home.text_ar')}}</label>
                                    <input type="text"  class="form-control" placeholder="{{trans('home.text_ar')}}" name="text_ar" value="{{$point->text_ar}}">
                                </div>

                                <input type="hidden" name="item_id" value="{{$point->id}}"/>
                                <input type="hidden" name="type" value="point"/>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}} </button>
                                </div>
                            </div>                             
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach

    {{-- materials models --}}
    @foreach($materials as $key=>$material_model)
        <div class="modal fade text-left" id="materialModel_{{$key}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title" id="myModalLabel34">{{trans('home.edit')}}</h3>
                        <a type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <h5 class="modal-title" id="myModalLabel34">X</h5>
                        </a>
                    </div>
                    <form action="{{route('updateCourseFeatureItem')}}" method="post">
                        @csrf
                        <div class="modal-body">
                            <div class="row">
                                <div class="form-group col-md-6"> 
                                    <label for="text_en">{{trans('home.text_en')}}</label>
                                    <input type="text"  class="form-control" placeholder="{{trans('home.text_en')}}" name="text_en" value="{{$material_model->text_en}}">
                                </div>
                                <div class="form-group col-md-6"> 
                                    <label for="text_ar">{{trans('home.text_ar')}}</label>
                                    <input type="text"  class="form-control" placeholder="{{trans('home.text_ar')}}" name="text_ar" value="{{$material_model->text_ar}}">
                                </div>

                                <input type="hidden" name="item_id" value="{{$material_model->id}}"/>
                                <input type="hidden" name="type" value="material"/>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}} </button>
                                </div>
                            </div>                             
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach


       {{-- materials models --}}
    @foreach($requirments as $key=>$requireModel)
       <div class="modal fade text-left" id="requireModel_{{$key}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
           <div class="modal-dialog" role="document">
               <div class="modal-content">
                   <div class="modal-header">
                       <h3 class="modal-title" id="myModalLabel34">{{trans('home.edit')}}</h3>
                       <a type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                           <h5 class="modal-title" id="myModalLabel34">X</h5>
                       </a>
                   </div>
                   <form action="{{route('updateCourseFeatureItem')}}" method="post">
                       @csrf
                       <div class="modal-body">
                           <div class="row">
                               <div class="form-group col-md-6"> 
                                   <label for="text_en">{{trans('home.text_en')}}</label>
                                   <input type="text"  class="form-control" placeholder="{{trans('home.text_en')}}" name="text_en" value="{{$requireModel->text_en}}">
                               </div>
                               <div class="form-group col-md-6"> 
                                   <label for="text_ar">{{trans('home.text_ar')}}</label>
                                   <input type="text"  class="form-control" placeholder="{{trans('home.text_ar')}}" name="text_ar" value="{{$requireModel->text_ar}}">
                               </div>

                               <input type="hidden" name="item_id" value="{{$requireModel->id}}"/>
                               <input type="hidden" name="type" value="require"/>

                               <div class="form-group col-md-12">
                                   <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}} </button>
                               </div>
                           </div>                             
                       </div>
                   </form>
               </div>
           </div>
       </div>
   @endforeach
    
@endsection

@section('script')
    <script>

        $(document).ready(function(){
            var maxField = 100; //Input fields increment limitation
            var addButton = $('.add_button'); //Add button selector
            var wrapper = $('.field_wrapper'); //Input field wrapper
            var fieldHTML ='<div class="row mb-2"><div class="col-md-5 mb-3"><label for="point_en">{{trans('home.point_en')}}</label><input required type="text"  class="form-control" placeholder="{{trans('home.point_en')}}" name="point_en[]"></div>';
            fieldHTML +='<div class="col-md-5 mb-3"><label for="point_ar">{{trans('home.point_ar')}}</label><input type="text" required  class="form-control" placeholder="{{trans('home.point_ar')}}" name="point_ar[]"></div>';
            fieldHTML +='<div class="form-group col-md-2"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

            var x = 1; //Initial field counter is 1

            //Once add button is clicked
            $(addButton).click(function(){
                //Check maximum number of input fields
                if(x < maxField){
                    x++; //Increment field counter
                    $(wrapper).append(fieldHTML); //Add field html
                }
            });

            //Once remove button is clicked
            $(wrapper).on('click', '.remove_button', function(e){
                e.preventDefault();
                $(this).parent().parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });

             //-------------------------- Add Materials Points-------------------------------------------
            var addButton_material = $('.add_button_material'); //Add button selector
            var wrapper_material = $('.field_wrapper_material'); //Input field wrapper
            var fieldHTML_material ='<div class="row mb-2"><div class="col-md-5 mb-3"><label for="material_en">{{trans('home.material_en')}}</label><input type="text"  class="form-control" placeholder="{{trans('home.material_en')}}" name="material_en[]"></div>';
            fieldHTML_material +='<div class="col-md-5 mb-3"><label for="material_ar">{{trans('home.material_ar')}}</label><input type="text"  class="form-control" placeholder="{{trans('home.material_ar')}}" name="material_ar[]"></div>';
            fieldHTML_material +='<div class="form-group col-md-2"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

            var x = 1; //Initial field counter is 1

            //Once add button is clicked
            $(addButton_material).click(function(){
                //Check maximum number of input fields
                if(x < maxField){
                    x++; //Increment field counter
                    $(wrapper_material).append(fieldHTML_material); //Add field html
                }
            });

            //Once remove button is clicked
            $(wrapper_material).on('click', '.remove_button', function(e){
                e.preventDefault();
                $(this).parent().parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });



             //-------------------------- Add Requirements -------------------------------------------
            var addButton_require = $('.add_button_require'); //Add button selector
            var wrapper_require = $('.field_wrapper_require'); //Input field wrapper
            var fieldHTML_require ='<div class="row mb-2"><div class="col-md-5 mb-3"><label for="require_en">{{trans('home.require_en')}}</label><input type="text"  class="form-control" placeholder="{{trans('home.require_en')}}" name="require_en[]"></div>';
            fieldHTML_require +='<div class="col-md-5 mb-3"><label for="require_ar">{{trans('home.require_ar')}}</label><input type="text"  class="form-control" placeholder="{{trans('home.require_ar')}}" name="require_ar[]"></div>';
            fieldHTML_require +='<div class="form-group col-md-2"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

            var x = 1; //Initial field counter is 1

            //Once add button is clicked
            $(addButton_require).click(function(){
                //Check maximum number of input fields
                if(x < maxField){
                    x++; //Increment field counter
                    $(wrapper_require).append(fieldHTML_require); //Add field html
                }
            });

            //Once remove button is clicked
            $(wrapper_require).on('click', '.remove_button', function(e){
                e.preventDefault();
                $(this).parent().parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });
        });
  
        $('.rmv').click(function () {
            var id = $(this).data('id');
            var type = $(this).data('type');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:"{{route('removeCourseFeature')}}",
                method:'POST',
                data: {id:id,type:type},
                success:function(data) {
                    location.reload();
                }
            });
        });
    </script>
@endsection