@extends('layouts.admin')
<title>{{trans('home.courses')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.courses')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.courses')}}</li>
                </ol>
            </div>
            @can('operations')
            <div class="btn btn-list">
                <a href="{{route('courses.create')}}"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{trans('home.add')}}</button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> {{trans('home.publish/unpublish')}}</button></a>
                <a class="mr-2" id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
            </div>
            @endcan
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.courses')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                            <hr>
                        </div>
                        
                        <div class="table-responsive">
                        <table class="table text-center" id="exportexample">
                        <thead>
                            <tr>
                                <th><input type="checkbox" class="form-check-input" id="checkAll" /></th>
                                <th>{{ trans('home.id') }}</th>
                                <th>{{ trans('home.name') }}</th>
                                <th>{{ trans('home.view_all') . ' ' . __('home.chapters') }}</th>
                                <th>{{ __('home.publish/unpublish') }}</th>
                                <th>{{ __('home.edit') }}</th>
                                <th>{{ __('home.delete') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($courses as $course)
                                <tr id="{{ $course->id }}">
                                    <td> <input type="checkbox" name="checkbox" class="tableChecked form-check-input"
                                            value="{{ $course->id }}" /> </td>
                                    <td><a href="{{ route('courses.edit', $course->id) }}">{{ $course->id }}</a></td>
                                    <td>{{ $course->{'name_' . $lang} }}</td>
                                    <td><a href="{{ url('admin/courses/' . $course->id . '/chapters') }}"
                                            class="btn btn-info waves-effect waves-light ">{{ '( ' . count($course->chapters) . ' ) ' . __('home.chapters') }}</a>
                                    </td>
                                    <td>
                                        <input class="btn_active" data-id="{{ $course->id }}" type="checkbox"
                                            id="switch-{{ $course->id }}" switch="success"
                                            {{ $course->status == 1 ? 'checked' : '' }} />
                                        <label for="switch-{{ $course->id }}" data-on-label="{{ trans('home.yes') }}"
                                            data-off-label="{{ trans('home.no') }}"></label>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-info waves-effect waves-light "
                                            href="{{ route('courses.edit', $course->id) }}">{{ __('home.edit') }}</a>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-danger waves-effect waves-light btn_delete" href="{{ route('courses.destroy', $course->id) }}"
                                            >{{ __('home.delete') }}</a>
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection

