@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_center')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.centers')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{route('centers.index')}}">{{trans('home.centers')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_center')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    {!! Form::open(['route' => 'centers.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1">{{trans('home.add_center')}}</h6>
                        <hr>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.name_en')}}</label>
                            <input class="form-control @error('name_en') is-invalid @enderror" name="name_en" type="text" value="{{ old('name_en') }}" placeholder="{{trans('home.name_en')}}">
                            @error('name_en')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.name_ar')}}<span style="color: red;padding: 0 3px">*</span></label>
                            <input class="form-control @error('name_ar') is-invalid @enderror" name="name_ar" type="text" value="{{ old('name_ar') }}" placeholder="{{trans('home.name_ar')}}" required>
                            @error('name_ar')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="col-md-4">
                            <label>{{ trans('home.logo') }}<span style="color: red;padding: 0 3px">*</span></label>
                            <div class="input-group mb-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                </div>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" name="logo" required>
                                    <label class="custom-file-label"
                                        for="inputGroupFile01">{{ trans('home.choose_logo') }}</label>
                                </div>
                                @error('logo')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.country')}}<span style="color: red;padding: 0 3px">*</span></label>
                            <select class="form-control select2 country @error('country_id') is-invalid @enderror" name="country_id" id="" required>
                                <option value="">{{ __('home.choose_country') }}</option>
                                @foreach($countries as $country)
                                    <option value="{{$country->id}}">{{(app()->getLocale() == 'en')?$country->name_en:$country->name_ar}}</option>
                                @endforeach
                            </select>
                            @error('country_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.area')}}<span style="color: red;padding: 0 3px">*</span></label>
                            <select class="form-control select2 area @error('area_id') is-invalid @enderror" name="area_id" required>
                                <option value="">{{ __('home.choose_area') }}</option>
                            </select>
                            @error('area_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.region')}}<span style="color: red;padding: 0 3px">*</span></label>
                            <select class="form-control select2 region @error('region_id') is-invalid @enderror" name="region_id" required>
                                <option value="">{{ __('home.choose_region') }}</option>
                            </select>
                            @error('region_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="partner_start_date">{{trans('home.partner_start_date')}}<span style="color: red;padding: 0 3px">*</span></label>
                            <div class="input-group">
                                <input type='text' class="form-control datepicker" required name="partner_start_date" placeholder="{{trans('home.partner_start_date')}}"  value="{{old('partner_start_date')}}" readonly/>
                                <div class="input-group-append">
                                    <span class="input-group-text">
                                        <i class="fas fa-calendar"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group col-md-8">
                            <label class="">{{trans('home.map_url')}} <span style="color: red;padding: 0 3px">*</span></label>
                            <textarea class="form-control @error('map_url') is-invalid @enderror" name="map_url" required type="text" placeholder="{{trans('home.map_url')}}">{{ old('map_url') }}</textarea>
                            @error('map_url')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        
                        
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.responsible_of_contact')}}<span style="color: red;padding: 0 3px">*</span></label>
                            <select class="form-control select2 responsible_of_contact @error('responsible_of_contact') is-invalid @enderror" required name="responsible_of_contact" id="">
                                <option value="">{{ __('home.choose_responsible_of_contact') }}</option>
                                @foreach($responsibles as $responsible)
                                    <option value="{{$responsible->id}}">{{(app()->getLocale() == 'en')?$responsible->f_name:$responsible->f_name}}</option>
                                @endforeach
                            </select>
                            @error('responsible_of_contact')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label for="identity_attachment">{{trans('home.commericalRegister/identity')}}<span style="color: red;padding: 0 3px">*</span></label>
                            <input class="form-control @error('identity_attachment') is-invalid @enderror" type="file" required id="identity_attachment" name="identity_attachment" accept=".pdf,.ppt,.pptx,.doc,.docx,.zip,.jpg,.jpeg,.png">
                            @error('identity_attachment')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label for="national_address">{{trans('home.national_address')}}<span style="color: red;padding: 0 3px">*</span></label>
                            <input class="form-control @error('national_address') is-invalid @enderror" type="file" required id="national_address" name="national_address" accept=".pdf,.ppt,.pptx,.doc,.docx,.zip,.jpg,.jpeg,.png">
                            @error('national_address')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label for="profile_attachment">{{trans('home.profile_attachment')}}<span style="color: red;padding: 0 3px">*</span></label>
                            <input class="form-control @error('profile_attachment') is-invalid @enderror" type="file" required id="profile_attachment" name="profile_attachment" accept=".pdf,.ppt,.pptx,.doc,.docx,.zip,.jpg,.jpeg,.png">
                            @error('profile_attachment')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        
                        <div class="form-group col-md-6">
                            <label class="">{{trans('home.desc_en')}}</label>
                            <textarea class="form-control area1 @error('text_en') is-invalid @enderror" name="text_en" type="text" placeholder="{{trans('home.desc_en')}}">{{ old('text_en') }}</textarea>
                            @error('text_en')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-6">
                            <label class="">{{trans('home.desc_ar')}}</label>
                            <textarea class="form-control area1 @error('text_ar') is-invalid @enderror" name="text_ar" type="text" placeholder="{{trans('home.desc_ar')}}">{{ old('text_ar') }}</textarea>
                            @error('text_ar')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        @can('status_or_publish_field')
                            <div class="form-group col-md-12">
                                <p class="mt-4 mb-2">{{trans('home.status')}}</p>
                                <label class="custom-switch @error('status') is-invalid @enderror">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input"/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish')}}</span>
                                </label>
                                @error('status')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        @endcan
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
    
    <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div>
                                <h6 class="card-title mb-1">{{trans('home.responsible_informations')}}</h6>
                                <hr>
                            </div>

                            <div class="field_wrapper">
                                
                                <div class="row">
                        
                                    <div class="form-group col-md-2">
                                        <label class="">{{trans('home.responsible_name')}}<span style="color: red;padding: 0 3px">*</span></label>
                                        <input class="form-control @error('responsible_name') is-invalid @enderror" name="responsible_name[]" required type="text" placeholder="{{trans('home.responsible_name')}}">
                                        @error('responsible_name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-2">
                                        <label class="">{{trans('home.responsible_job')}}<span style="color: red;padding: 0 3px">*</span></label>
                                        <input class="form-control @error('responsible_job') is-invalid @enderror" name="responsible_job[]" required type="text" placeholder="{{trans('home.responsible_job')}}">
                                        @error('responsible_job')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-3">
                                        <label class="">{{trans('home.responsible_email')}}<span style="color: red;padding: 0 3px">*</span></label>
                                        <input class="form-control @error('responsible_email') is-invalid @enderror" name="responsible_email[]" required type="email" placeholder="{{trans('home.responsible_email')}}">
                                        @error('responsible_email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-2">
                                        <label class="">{{trans('home.responsible_phone')}}<span style="color: red;padding: 0 3px">*</span></label>
                                        <input class="form-control @error('responsible_phone') is-invalid @enderror" name="responsible_phone[]" required type="number" min="0" placeholder="{{trans('home.responsible_phone')}}">
                                        @error('responsible_phone')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-2">
                                        <label class="">{{trans('home.responsible_whatsapp')}}<span style="color: red;padding: 0 3px">*</span></label>
                                        <input class="form-control @error('responsible_whatsapp') is-invalid @enderror" name="responsible_whatsapp[]" required type="number" min="0" placeholder="{{trans('home.responsible_whatsapp')}}">
                                        @error('responsible_whatsapp')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>  
                            </div>       
                            <a href="javascript:void(0);" class="add_button btn" title="Add field"><i class="fas fa-plus-square"></i></a>								
                        </div>
                    </div>
                </div>
            </div>
    
    
    <!-- Row-->
    
    {{--<div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    
                     <div>
                        <h6 class="card-title mb-1">{{trans('home.responsible_informations')}}</h6>
                        <hr>
                    </div>
                    
                    <div class="row">
                        
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.responsible_name1')}}</label>
                            <input class="form-control @error('responsible_name1') is-invalid @enderror" name="responsible_name1" value="{{ old('responsible_name1') }}" type="text" placeholder="{{trans('home.responsible_name1')}}">
                            @error('responsible_name1')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_job1')}}</label>
                            <input class="form-control @error('responsible_job1') is-invalid @enderror" name="responsible_job1" value="{{ old('responsible_job1') }}" type="text" placeholder="{{trans('home.responsible_job1')}}">
                            @error('responsible_job1')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.responsible_email1')}}</label>
                            <input class="form-control @error('responsible_email1') is-invalid @enderror" name="responsible_email1" value="{{ old('responsible_email1') }}" type="email" placeholder="{{trans('home.responsible_email1')}}">
                            @error('responsible_email1')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_phone1')}}</label>
                            <input class="form-control @error('responsible_phone1') is-invalid @enderror" name="responsible_phone1" value="{{ old('responsible_phone1') }}" type="number" min="0" placeholder="{{trans('home.responsible_phone1')}}">
                            @error('responsible_phone1')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_whatsapp1')}}</label>
                            <input class="form-control @error('responsible_whatsapp1') is-invalid @enderror" name="responsible_whatsapp1" value="{{ old('responsible_whatsapp1') }}" type="number" min="0" placeholder="{{trans('home.responsible_whatsapp1')}}">
                            @error('responsible_whatsapp1')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="row">
                        
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.responsible_name2')}}</label>
                            <input class="form-control @error('responsible_name2') is-invalid @enderror" name="responsible_name2" value="{{ old('responsible_name2') }}" type="text" placeholder="{{trans('home.responsible_name2')}}">
                            @error('responsible_name2')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_job2')}}</label>
                            <input class="form-control @error('responsible_job2') is-invalid @enderror" name="responsible_job2" value="{{ old('responsible_job2') }}" type="text" placeholder="{{trans('home.responsible_job2')}}">
                            @error('responsible_job2')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.responsible_email2')}}</label>
                            <input class="form-control @error('responsible_email2') is-invalid @enderror" name="responsible_email2" value="{{ old('responsible_email2') }}" type="email" placeholder="{{trans('home.responsible_email2')}}">
                            @error('responsible_email2')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_phone2')}}</label>
                            <input class="form-control @error('responsible_phone2') is-invalid @enderror" name="responsible_phone2" value="{{ old('responsible_phone2') }}" type="number" min="0" placeholder="{{trans('home.responsible_phone2')}}">
                            @error('responsible_phone2')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_whatsapp2')}}</label>
                            <input class="form-control @error('responsible_whatsapp2') is-invalid @enderror" name="responsible_whatsapp2" value="{{ old('responsible_whatsapp2') }}" type="number" min="0" placeholder="{{trans('home.responsible_whatsapp2')}}">
                            @error('responsible_whatsapp2')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="row">
                        
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.responsible_name3')}}</label>
                            <input class="form-control @error('responsible_name3') is-invalid @enderror" name="responsible_name3" value="{{ old('responsible_name3') }}" type="text" placeholder="{{trans('home.responsible_name3')}}">
                            @error('responsible_name3')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_job3')}}</label>
                            <input class="form-control @error('responsible_job3') is-invalid @enderror" name="responsible_job3" value="{{ old('responsible_job3') }}" type="text" placeholder="{{trans('home.responsible_job3')}}">
                            @error('responsible_job3')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.responsible_email3')}}</label>
                            <input class="form-control @error('responsible_email3') is-invalid @enderror" name="responsible_email3" value="{{ old('responsible_email3') }}" type="email" placeholder="{{trans('home.responsible_email3')}}">
                            @error('responsible_email3')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_phone3')}}</label>
                            <input class="form-control @error('responsible_phone3') is-invalid @enderror" name="responsible_phone3" value="{{ old('responsible_phone3') }}" type="number" min="0" placeholder="{{trans('home.responsible_phone3')}}">
                            @error('responsible_phone3')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_whatsapp3')}}</label>
                            <input class="form-control @error('responsible_whatsapp3') is-invalid @enderror" name="responsible_whatsapp3" value="{{ old('responsible_whatsapp3') }}" type="number" min="0" placeholder="{{trans('home.responsible_whatsapp3')}}">
                            @error('responsible_whatsapp3')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="row">
                        
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.responsible_name4')}}</label>
                            <input class="form-control @error('responsible_name4') is-invalid @enderror" name="responsible_name4" value="{{ old('responsible_name4') }}" type="text" placeholder="{{trans('home.responsible_name4')}}">
                            @error('responsible_name4')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_job4')}}</label>
                            <input class="form-control @error('responsible_job4') is-invalid @enderror" name="responsible_job4" value="{{ old('responsible_job4') }}" type="text" placeholder="{{trans('home.responsible_job4')}}">
                            @error('responsible_job4')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.responsible_email4')}}</label>
                            <input class="form-control @error('responsible_email4') is-invalid @enderror" name="responsible_email4" value="{{ old('responsible_email4') }}" type="email" placeholder="{{trans('home.responsible_email4')}}">
                            @error('responsible_email4')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_phone4')}}</label>
                            <input class="form-control @error('responsible_phone4') is-invalid @enderror" name="responsible_phone4" value="{{ old('responsible_phone4') }}" type="number" min="0" placeholder="{{trans('home.responsible_phone4')}}">
                            @error('responsible_phone4')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_whatsapp4')}}</label>
                            <input class="form-control @error('responsible_whatsapp4') is-invalid @enderror" name="responsible_whatsapp4" value="{{ old('responsible_whatsapp4') }}" type="number" min="0" placeholder="{{trans('home.responsible_whatsapp4')}}">
                            @error('responsible_whatsapp4')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="row">
                        
                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.responsible_of_contact')}}</label>
                            <select class="form-control select2 responsible_of_contact @error('responsible_of_contact') is-invalid @enderror" name="responsible_of_contact" id="">
                                <option value="">{{ __('home.choose_responsible_of_contact') }}</option>
                                @foreach($responsibles as $responsible)
                                    <option value="{{$responsible->id}}">{{(app()->getLocale() == 'en')?$responsible->f_name:$responsible->f_name}}</option>
                                @endforeach
                            </select>
                            @error('responsible_of_contact')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    </div> --}}
    <!-- End Row -->
    
    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div class="row">
                        <div class="form-group col-md-12">
                            <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                            <a href="{{route('centers.index')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

    {!! Form::close() !!}
</div>

@endsection


@section('script')
    <script>
        $('.country').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getAreas')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    area.html(html);
                }
            });
        });

        $('.area').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getRegions')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    region.html(html);
                }
            });
        });
    </script>
    
    
    <script>
    $(document).ready(function(){
        
        $( ".datepicker" ).datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd'
        });
        
        var maxField = 100; //Input fields increment limitation
        var addButton = $('.add_button'); //Add button selector
        var wrapper = $('.field_wrapper'); //Input field wrapper
        var fieldHTML ='<div class="row"><hr><div class="form-group col-md-2"> <label for="responsible_name">{{trans('home.responsible_name')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.responsible_name')}}" name="responsible_name[]"> </div>';
        fieldHTML +='<div class="form-group col-md-2"> <label for="responsible_job">{{trans('home.responsible_job')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.responsible_job')}}" name="responsible_job[]"> </div>';
        fieldHTML +='<div class="form-group col-md-3"> <label for="responsible_email">{{trans('home.responsible_email')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.responsible_email')}}" name="responsible_email[]"> </div>';
        fieldHTML +='<div class="form-group col-md-2"> <label for="responsible_phone">{{trans('home.responsible_phone')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.responsible_phone')}}" name="responsible_phone[]"> </div>';
        fieldHTML +='<div class="form-group col-md-2"> <label for="responsible_whatsapp">{{trans('home.responsible_whatsapp')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.responsible_whatsapp')}}" name="responsible_whatsapp[]"> </div>';
        fieldHTML +='<div class="form-group col-md-1"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

        var x = 1; //Initial field counter is 1

        //Once add button is clicked
        $(addButton).click(function(){
            //Check maximum number of input fields
            if(x < maxField){
                x++; //Increment field counter
                $(wrapper).append(fieldHTML); //Add field html
            }
            $('.select2').select2({
                'placeholder' : 'choose',
            });
        });
        
        

        //Once remove button is clicked
        $(wrapper).on('click', '.remove_button', function(e){
            e.preventDefault();
            $(this).parent().parent('div').remove(); //Remove field html
            x--; //Decrement field counter
        });
    });
    

</script>

@endsection



