@extends('layouts.admin')

@section('meta')
    <title>{{trans('home.edit_blog_item')}}</title>
@endsection

@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.blogItems')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/blog-items')}}">{{trans('home.blogItems')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_blog_item')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    
    @if(session()->has('success'))
        <div class="alert alert-success">
            {{ session()->pull('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    
    {!! Form::open(['method'=>'PATCH','url' => 'admin/blog-items/'.$blogItem->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title ">{{trans('home.edit_blog_category')}}</h6>
                        </div>
                        <div class="row">

                            <div class="form-group col-md-3">
                                <label for="name_en">{{trans('home.name_en')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.name_en')}}" name="name_en" value="{{$blogItem->name_en}}" required>
                            </div>

                            <div class="form-group col-md-3">
                                <label for="name_ar">{{trans('home.name_ar')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.name_ar')}}" name="name_ar" value="{{$blogItem->name_ar}}">
                            </div>
                            

                            <div class="form-group col-md-2">
                                <label for="parent">{{trans('home.blogCategory')}}</label>
                                <select class="form-control select2" name="blogcategory_id">
                                    @foreach($blogCategories as $blogCategory)
                                        <option value="{{$blogCategory->id}}" {{($blogCategory->id == $blogItem->blogcategory_id)?'selected':''}}>{{(app()->getLocale()=='en')? $blogCategory->name_en:$blogCategory->name_ar}}</option>
                                    @endforeach    
                                </select>
                            </div>
                            <div class="form-group col-md-2">
                                <label for="parent">{{trans('home.BlogCourseCategory')}}</label>
                                <select class="form-control select2" name="course_category_id">
                                    @foreach($blogCourseCategories as $blogCourseCategory)
                                        <option value="{{$blogCourseCategory->id}}" {{($blogCourseCategory->id == $blogItem->course_category_id)?'selected':''}}>{{(app()->getLocale()=='en')? $blogCourseCategory->name_en:$blogCourseCategory->name_ar}}</option>
                                    @endforeach    
                                </select>
                            </div>
                            <div class="form-group col-md-3"> 
                                <label for="type">{{trans('home.writers')}}</label>
                                <select class="form-control select2 type" name="writer_id">
                                    @foreach ($writers as $writer)
                                        <option value ="{{$writer->id}}">{{$writer->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-md-3">
                                <label for="code">{{trans('home.date')}}</label>
                                <div class="input-group">
                                    <input type='text' class="form-control" name="date" placeholder="{{trans('home.date')}}" id="datepicker" value="{{$blogItem->date}}"  required readonly/>
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="mobile">{{trans('home.mobile')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.mobile')}}" name="mobile" value="{{old('mobile',$blogItem->mobile)}}">
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="whatsapp">{{trans('home.whatsapp')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.whatsapp')}}" name="whatsapp" value="{{old('whatsapp',$blogItem->whatsapp)}}">
                            </div>
                            
                            <div class="col-md-2">
                                <label>{{trans('home.image')}}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-2">
                                <label for="alt_img">{{trans('home.alt_img')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.alt_img')}}" name="alt_img" value="{{$blogItem->alt_img}}">
                            </div>

                            @if($blogItem->image)
                                <div class="col-md-12">
                                    <img src="{{url('uploads/blogitems/'.$blogItem->image)}}" width="200" height="150">
                                </div>
                            @endif

                            <div class="form-group col-md-6 ">
                                <label for="text_en">{{trans('home.text_en')}}</label>
                                <textarea class="form-control area1" name="text_en" placeholder="{{trans('home.text_en')}}" >{!! $blogItem->text_en !!}</textarea>
                            </div>

                            <div class="form-group col-md-6 "> 
                                <label for="text_ar">{{trans('home.text_ar')}}</label>
                                <textarea class="form-control area1" name="text_ar" placeholder="{{trans('home.text_ar')}}" >{!! $blogItem->text_ar !!}</textarea>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <p class="mt-4 mb-2">{{trans('home.status')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input" {{($blogItem->status == 1)? 'checked':''}}/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish')}}</span>
                                </label>
                            </div>

                            <div class="form-group col-md-4">
                                <p class="mt-4 mb-2">{{trans('home.home')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="home" value="1" class="custom-switch-input" {{($blogItem->home == 1)? 'checked':''}}/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish_in_home')}}</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
       {{-- <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.faqs')}}</h6>
                        </div>
                        <div class="row">
                            @if(count($questions) > 0)
                                @foreach($questions as $key=>$question)
                                    <div class="form-group col-md-2"> 
                                        <label for="question_en">{{trans('home.question_en')}}</label>
                                        <textarea class="form-control" placeholder="{{trans('home.question_en')}}" readonly>{{$question->question_en}}</textarea>
                                    </div>

                                    <div class="form-group col-md-3">
                                        <label for="answer_en">{{trans('home.answer_en')}}</label>
                                        <textarea class="form-control" placeholder="{{trans('home.answer_en')}}" readonly>{{$question->answer_en}}</textarea>
                                    </div>
                                    
                                    
                                    <div class="form-group col-md-2"> 
                                        <label for="question_ar">{{trans('home.question_ar')}}</label>
                                        <textarea class="form-control" placeholder="{{trans('home.question_ar')}}" readonly>{{$question->question_ar}}</textarea>
                                    </div>

                                    <div class="form-group col-md-3">
                                        <label for="answer_ar">{{trans('home.answer_ar')}}</label>
                                        <textarea class="form-control" placeholder="{{trans('home.answer_ar')}}" readonly>{{$question->answer_ar}}</textarea>
                                    </div>

                                    <div class="form-group col-md-2">
                                        <button type="button" style="margin-top: 28px;" class="btn" data-toggle="modal" data-target="#iconForm_{{$key}}"><i class="fas fa-edit"></i></button>
                                        <button type="button" style="margin-top: 28px;" class="btn rmv" data-faq_id="{{$question->id}}" id="type-error"><i class="fas fa-trash-alt"></i></button>
                                    </div>
                                @endforeach   
                                <div class="form-group col-md-12 text-center">
                                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addfAQ"><i class="fas fa-plus-circle"></i> {{trans('home.add_faq')}} </button>
                                </div>
                            @else
                                <div class="form-group col-md-12 text-center">
                                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addfAQ"><i class="fas fa-plus-circle"></i> {{trans('home.add_faq')}} </button>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>    
            </div>
        </div> --}}
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title ">{{trans('home.seo_block')}}</h6>
                        </div>
                        
                        <div class="col-md-12 mb-3">
                            <label for="redirect_url">{{trans('home.redirect_url')}}</label>
                            <input type="text" class="form-control" value="{{ old('redirect_url',$blogItem->redirect_url) }}" placeholder="{{trans('home.redirect_url')}}" name="redirect_url">
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12">
                                <hr>
                                <span class="badge badge-success">{{trans('home.en')}}</span>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="link_en">{{trans('home.slug')}}</label>
                                <input type="text" class="form-control" placeholder="{{trans('home.slug')}}" name="link_en" value="{{$blogItem->link_en}}">
                            </div>
                    
                            <div class="form-group col-md-5">
                                <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                <textarea class="form-control" name="meta_title_en" placeholder="{{trans('home.meta_title')}}">{{$blogItem->meta_title_en}}</textarea>
                            </div>
                            
                            <div class="form-group col-md-5">
                                <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                <textarea class="form-control" name="meta_desc_en" placeholder="{{trans('home.meta_desc')}}">{{$blogItem->meta_desc_en}}</textarea>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <hr>
                                <span class="badge badge-success">{{trans('home.ar')}}</span>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="link_ar">{{trans('home.slug')}}</label>
                                <input type="text" class="form-control" placeholder="{{trans('home.slug')}}" name="link_ar" value="{{$blogItem->link_ar}}">
                            </div>
                            
                            <div class="form-group col-md-5">
                                <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                <textarea class="form-control" name="meta_title_ar" placeholder="{{trans('home.meta_title')}}">{{$blogItem->meta_title_ar}}</textarea>
                            </div>
                            
                            <div class="form-group col-md-5">
                                <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                <textarea class="form-control" name="meta_desc_ar" placeholder="{{trans('home.meta_desc')}}">{{$blogItem->meta_desc_ar}}</textarea>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <p class="mt-4 mb-2">{{trans('home.meta_robots')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="meta_robots" value="1" class="custom-switch-input" {{($blogItem->meta_robots == 1)? 'checked':''}}>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_index')}}</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="image-note"></i> {{trans('home.save')}} </button>
                                <a href="{{url('/admin/blog-items')}}"><button type="button" class="btn btn-danger mr-1"><i class="image-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    {!! Form::close() !!}
                       
                        
    <!-- add Modal --> 
    <div class="modal fade text-left" id="addfAQ" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="myModalLabel34">{{trans('home.add_faq')}}</h3>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{route('storeBlogFaq')}}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="form-group col-md-6"> 
                                <label for="question_en">{{trans('home.question_en')}}</label>
                                <textarea class="form-control" placeholder="{{trans('home.question_en')}}" name="question_en"></textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="answer_en">{{trans('home.answer_en')}}</label>
                                <textarea class="form-control" placeholder="{{trans('home.answer_en')}}" name="answer_en"></textarea>
                            </div>

                            <div class="form-group col-md-6"> 
                                <label for="question_ar">{{trans('home.question_ar')}}</label>
                                <textarea class="form-control" placeholder="{{trans('home.question_ar')}}" name="question_ar"></textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="answer_ar">{{trans('home.answer_ar')}}</label>
                                <textarea class="form-control" placeholder="{{trans('home.answer_ar')}}" name="answer_ar"></textarea>
                            </div>
                            
                            <input type="hidden" name="blog_item_id" value="{{$blogItem->id}}"/>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success">{{trans('home.save')}} </button>
                            </div>
                        </div>                             
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Modal -->
    @foreach($questions as $key=>$question)
        <div class="modal fade text-left" id="iconForm_{{$key}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title" id="myModalLabel34">{{trans('home.edit_faq')}}</h3>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{route('updateBlogFaq')}}" method="post">
                        @csrf
                        <div class="modal-body">
                            <div class="row">
                                <div class="form-group col-md-6"> 
                                    <label for="question_en">{{trans('home.question_en')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.question_en')}}" name="question_en">{{$question->question_en}}</textarea>
                                </div>
    
                                <div class="form-group col-md-6">
                                    <label for="answer_en">{{trans('home.answer_en')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.answer_en')}}" name="answer_en">{{$question->answer_en}}</textarea>
                                </div>
                                
                                
                                <div class="form-group col-md-6"> 
                                    <label for="question_ar">{{trans('home.question_ar')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.question_ar')}}" name="question_ar">{{$question->question_ar}}</textarea>
                                </div>
    
                                <div class="form-group col-md-6">
                                    <label for="answer_ar">{{trans('home.answer_ar')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.answer_ar')}}" name="answer_ar">{{$question->answer_ar}}</textarea>
                                </div> 

                                <input type="hidden" name="faq_id" value="{{$question->id}}"/>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success">{{trans('home.save')}} </button>
                                </div>
                            </div>                             
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach
</div>

@endsection


@section('script')
    <script>

        $( "#datepicker" ).datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd'
        });
        
        $(document).ready(function(){
            $('.rmv').click(function () {
                var faq_id = $(this).data('faq_id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"{{route('removeBlogFaq')}}",
                    method:'POST',
                    data: {faq_id:faq_id},
                    success:function(data) {
                        location.reload();
                    }
                });
            });
        });
        
        
        
    </script>
@endsection