<style>
    .rating-box {
        padding: 15px 28px;
        background-color: #f1f1f1;
        border-radius: 25px;
        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.08);
        text-align: center;
    }
    .rating-box h3 {
      font-size: 22px;
      font-weight: 600;
      margin-bottom: 20px;
    }
    .rating-box .stars {
        display: flex;
        align-items: center;
        gap: 8px;
    }
    .stars i {
      font-size: 20px;
      color: #b5b8b1;
      transition: all 0.2s;
      cursor: pointer;
    }
    .stars i.active {
      color: #ffb851;
      transform: scale(1.2);
    }
    
    @media (min-width: 992px) {
        .modal-lg, .modal-xl {
            max-width: 1120px;
        }
    }
</style>

<div class="modal fade bd-example-modal-lg" id="show_attachments_modal_{{$training->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    <div class="modal-content" style="border-radius: 35px;">
      <div class="modal-header">
        <h5 class="modal-title m-auto" id="exampleModalLongTitle">  {{$training->{'name_'.$lang} }}</h5>
        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
            <div class="table-responsive">
                <table class="table" id="exportexample"> 
                    <thead>
                        <tr>
                            <th>{{ trans('home.name') }}</th>
                            <th >{{ trans('home.attachment_type') }}</th>
                            <th >{{ trans('home.attendance_date') }}</th>
                            <th >{{ trans('home.created_at') }}</th>
                            <th >{{ trans('home.file') }}</th>
                            <th >{{ trans('home.delete') }}</th>
                            <th >{{ trans('home.rate') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($attendances as $attendance)
                            <tr id="{{$attendance->id}}">
                                <td> {{ $attendance->attachments }}  </td>
                                <td> {{ trans('home.'.$attendance->type) }}  </td>
                                <td> {{\Carbon\Carbon::parse($attendance->attendance_date)->format("d / m / Y")  }}</td>
                                <td> {{\Carbon\Carbon::parse($attendance->created_at)->format("d / m / Y")  }}</td>
                                <td><a href="{{url('uploads/trainings/attendance_attachments/'.$attendance->attachments )}}" 
                                    download="{{$attendance->attachments}}">
                                      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-file-text">
                                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                        <polyline points="14 2 14 8 20 8"></polyline>
                                        <line x1="16" y1="13" x2="8" y2="13"></line>
                                        <line x1="16" y1="17" x2="8" y2="17"></line>
                                        <polyline points="10 9 9 9 8 9"></polyline>
                                      </svg>
                                    </a>
                                </td>
                                <td>
                                    <a class="mr-2" attendance_id="{{$attendance->id}}" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                                        {{ trans('home.delete') }}</button></a>
                                </td>
                                <td>
                                    <div class="rating-box" >
                                      <div class="stars" id="star-custom{{$attendance->id}}" dataId='{{$attendance->id}}'>
                                        <i class="fa fa-star @if($attendance->rating >= 1) active @endif"></i>
                                        <i class="fa fa-star @if($attendance->rating >= 2) active @endif"></i>
                                        <i class="fa fa-star @if($attendance->rating >= 3) active @endif"></i>
                                        <i class="fa fa-star @if($attendance->rating >= 4) active @endif"></i>
                                        <i class="fa fa-star @if($attendance->rating >= 5) active @endif"></i>
                                      </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
    
                    </tbody>
                </table>
    	    </div>
    	    {{--<div class="row d-flex justify-content-end">
    	        <div class="col-4"> 
    	            <select class="form-control select2" name="feedback[]" multiple>
    	                <option>222</option>
    	                <option>222</option>
    	                <option>222</option>
    	            </select>
    	        </div>
    	        <div class="col-4">
    	            <div class="text-center ">65%</div>
    	        </div>
    	    </div> --}}
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary m-auto" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>




<script>
    //// btn_delete ////
        $(document).ready(function(){
            $('#btn_delete').click(function(){
                var id = $('#btn_delete').attr('attendance_id');
                    $.confirm({
                        title: '{{__('home.Are you sure you want to delete that ?')}}',
                        content:'',
                        buttons: {
                            confirm: {
                                text: '{{__('home.delete')}}',
                                btnClass: 'btn-red any-other-class',
                                keys: ['enter', 'shift'],
                                action: function(){
                                     $.ajaxSetup({
                                        headers: {
                                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                        }
                                    });
                    
                                    $.ajax({
                                        url: "<?php echo url('admin/delete_attendance_attachments')?>/" + id,
                                        type: 'DELETE',
                                        data: {id: id},
                                        success: function () {
                                            $('tr#' + id).css('background-color', '#ccc').fadeOut('slow');
                                        }
                                    }); 
                                }
                            },
                            cancel: {
                                text: '{{__('home.cancel')}}',
                                action: function(){
                                    close();
                                }
                            }
                        }
                    });
            });
        });
</script>

<script>
    // ---- ---- Const ---- ---- //
   
     $(document).ready(function() {
        @foreach($attendances as $attendance)
            $('#star-custom{{$attendance->id}} .fa-star').each(function(index) {
                $(this).on('click', function() {
                    var stars = $('#star-custom{{$attendance->id}} .fa-star');
                    stars.removeClass('active');
                    for (var i = 0; i <= index; i++) {
                        $(stars[i]).addClass('active');
                    }
                    
                    
                    var attachment_id = {{$attendance->id}};
                    var rate = index + 1;
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                         url:"{{ route('attachment_change_rate') }}",
                        method: 'Post',
                        data: {
                            attachment_id:attachment_id,rate:rate
                        },
                        success: function (data) {
                            // $('body').append(data.view);
                            // // $('#status_'+partner_request_id).html(fieldHTML);
                            // $(modalId).modal('show');
                        },
                    });
                    
                    
                    
                });
            });
        @endforeach
    });
    
</script>


