<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class HyperPayService
{
    protected $baseUrl;
    protected $entityId;
    protected $bearerToken;
    protected $currency;

    public function __construct()
    {
        $this->baseUrl = config('services.hyperpay.base_url');
        $this->entityId = config('services.hyperpay.entity_id');
        $this->bearerToken = config('services.hyperpay.bearer_token');
        $this->currency = config('services.hyperpay.currency');
    }

    public function createCheckout($amount, $merchantTransactionId, $customerEmail, $billingStreet1, $billingCity, $billingCountry = 'SA')
    {
        $url = $this->baseUrl . '/v1/checkouts';
        
        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->bearerToken,
        ])->asForm()->post($url, [
            'entityId' => $this->entityId,
            'amount' => number_format($amount, 2, '.', ''),
            'currency' => $this->currency,
            'merchantTransactionId' => $merchantTransactionId,
            'customer.email' => $customerEmail,
            'billing.street1' => $billingStreet1,
            'billing.city' => $billingCity,
            'billing.country' => $billingCountry,
            'paymentType' => 'DB',
        ]);

        return $response->json();
    }

    public function getPaymentStatus($checkoutId)
    {
        $url = $this->baseUrl . '/v1/checkouts/' . $checkoutId . '/payment';
        $url .= '?entityId=' . $this->entityId;

        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->bearerToken,
        ])->get($url);

        return $response->json();
    }
}