<?php

namespace App\Providers;

use App\Models\About;
use App\Models\AboutStruc;
use App\Models\Career;
use App\Models\Project;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use App;
use stdClass;
use View;
use App\Models\Service;
use App\Models\Training;
use App\Models\Cart;
use App\Models\CartCourse;
use App\Models\HomeSlider;
use App\Models\GuestCart;
use App\Models\Wishlist;
use App\Models\GuestWishlist;
use App\Models\GuestCartCourse;
use App\Models\User;
use App\Observers\UserObserver;

use App\Models\Setting;
use App\Models\Configration;
use App\Models\MenuItem;
use App\Models\Page;
use Auth;
use App\Models\Category;
use App\Models\TrainingField;
use App\Models\Level;
use App\Models\GalleryImage;
use App\Models\Address;
use App\Models\SeoAssistant;
use App\Models\BlogCategory;
use App\Models\ServiceCategory;
use App\Models\Writer;
use App\Models\Region;
use App\Models\Brand;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Session;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //
        Schema::defaultStringLength(191);
        \URL::forceScheme('https');
        User::observe(UserObserver::class);
        view()->composer('*', function($view)
        {
            $setting = Setting::first();
            $seo = SeoAssistant::first();
            $writers = Writer::where('status',1)->get();
            $lang = LaravelLocalization::getCurrentLocale();
            app()->setLocale($lang);
            
            $menuTrainingFields = TrainingField::where('menu',1)->where('status',1)->get();
            $trainingFields = TrainingField::where('status',1)->get();
            // dd($menuTrainingFields);
            $blogCategories= BlogCategory::orderBy('id','desc')->get();
            $servicesHeader= Service::orderBy('id','asc')->get();
            $serviceCategoriesHeader= ServiceCategory::with('services')->orderBy('id','desc')->get();
            $configration = Configration::where('lang',$lang)->first();
            $menus = MenuItem::where('menu_id',1)->where('status',1)->where('parent_id',0)->orderBy('order','ASC')->get();
            $footerMenus = MenuItem::where('menu_id',2)->where('status',1)->where('parent_id',0)->orderBy('order','ASC')->get();
            $pages = Page::where('status',1)->get();
            $menuServices = Level::get();

            $menuCategories = Category::where('menu',1)->where('status',1)->get();
            $professional_certificates = Category::where(function ($query) {
                $query->where('name_en', 'Professional Certificates')
                      ->orWhere('name_ar', 'الشهادات المهنية');
            })->first();
            if($professional_certificates)
            {
                $professional_courses = Training::where('category_id',$professional_certificates->id)->where('status',1)->get();
            }           
            $brands = Brand::where('status',1)->get();
            $home_slider = HomeSlider::where('status',1)->where('lang',$lang)->first();

            $addresses = Address::where('status',1)->get();
            $statements = Career::where('status',1)->where('type','header')->get();
            $custom_products = Project::where('status',1)->where('recommended',1)->get();
            $aboutStrucs  = AboutStruc::where('status',1)->where('lang',$lang)->get();
            $about = About::first();
            $coursesPrices=[];
            $cartCount = 0;
            $wishlist_count = 0;
            $cart = new stdClass(); // Default empty cart object
            $cart->cart_courses = collect([]);
            $cart->total_price = 0;

            if(Auth::check()){
                $user_id = auth()->user()->id;
                $cart=Cart::where('user_id',$user_id)->first();
                if($cart){
                    $cartCourses = CartCourse::where('cart_id',$cart->id)->get();
                    $cartCount = $cartCourses->count();
    
                    foreach($cartCourses as $cartCourse){
                        array_push($coursesPrices,$cartCourse->price);
                    }
                    $totalPrice =array_sum($coursesPrices);
                }else{
                    $cart = new stdClass(); // Default empty cart object
                    $cart->cart_courses = collect([]);
                    $cart->total_price = 0;
                }
                $wishlist_count = Wishlist::where('user_id',$user_id)->count();
            }else{
                if(Session::has('session_id')){
                    $cart=GuestCart::where('session_id',Session::get('session_id'))->first();
                    $cart->cart_courses = collect([]);
                    if($cart){
                        $cartCourses=GuestCartCourse::where('guest_cart_id',$cart->id)->get();
                        $cartCount = $cartCourses->count();
                        foreach($cartCourses as $cartCourse){
                            array_push($coursesPrices,$cartCourse->price);
                        }
                        $totalPrice =array_sum($coursesPrices);
                    }   

                    $wishlist_count = GuestWishlist::where('session_id',Session::get('session_id'))->count();
                } 
            }

            App::setlocale($lang);
            View::share('language', $lang);
            View::share('setting', $setting);
            View::share('configration', $configration);
            View::share('menus', $menus);
            View::share('pages', $pages);
            View::share('lang', $lang);
            View::share('blogCategories', $blogCategories);
            View::share('serviceCategoriesHeader', $serviceCategoriesHeader);
            View::share('servicesHeader', $servicesHeader);
            View::share('professional_certificates', $professional_certificates);
            View::share('addresses', $addresses);
            View::share('writers', $writers);
            View::share('seo', $seo);
            View::share('footerMenus', $footerMenus);
            View::share('menuCategories', $menuCategories);
            View::share('menuTrainingFields', $menuTrainingFields);
            View::share('trainingFields', $trainingFields);
            View::share('brands', $brands);
            View::share('home_slider', $home_slider);
            View::share('statements', $statements);
            View::share('custom_products', $custom_products);
            View::share('menuServices', $menuServices);
            View::share('aboutStrucs', $aboutStrucs);
            View::share('about', $about);
            View::share('cart', $cart);
            View::share('cartCount', $cartCount);
            View::share('wishlist_count', $wishlist_count);
            if($professional_certificates)
            {
                View::share('professional_courses', $professional_courses);
            }

        });
    }
}
