<?php

namespace App\Observers;

use App\Models\User;
use App\Models\AuditLog;
use Illuminate\Support\Facades\Auth;

class UserObserver
{
    public function created(User $user)
    {
        $this->logActivity($user, 'created');
    }

    public function updated(User $user)
    {
        // Log only changed attributes
        $changes = $user->getChanges();
        if ($changes) {
            $this->logActivity($user, 'updated', $changes);
        }
    }

    public function deleted(User $user)
    {
        $this->logActivity($user, 'deleted');
    }

    protected function logActivity(User $user, string $event, array $changes = null)
    {
        AuditLog::create([
            'user_id' => $user->id,
            'causer_id' => Auth::id(),
            'event' => $event,
            'changes' => $changes ? json_encode($changes) : null,
        ]);
    }
}
