<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Carbon\Carbon;
use Devinweb\LaravelHyperpay\Traits\ManageUserTransactions;


class User extends Authenticatable implements JWTSubject
{
    use ManageUserTransactions;
    use HasFactory,HasRoles;
    
    use Notifiable;

    protected $table='users';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = [
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }
    public function getJWTCustomClaims()
    {
        return [];
    }



    public function country(){
        return $this->belongsTo(Country::class,'country_id');
    }

    public function region(){
        return $this->belongsTo(Region::class,'region_id');
    }

    public function area(){
        return $this->belongsTo(Area::class,'area_id');
    }

    public function isAdmin(){
        return $this->is_admin;
    }
    
    public function student_info(){
        return $this->hasOne(StudentInfo::class,'user_id');
    }
    public function instructor_info(){
        return $this->hasOne(InstructorInfo::class,'user_id');
    }
    
    public function trainings(){
        return $this->hasMany(Student::class,'user_id');
    }

    public function name(){
        return $this->f_name .' '.$this->l_name;
    }
    public function getNameAttribute(){
        return $this->f_name .' '.$this->l_name;
    }

    public function cart(){
        return $this->hasOne(Cart::class)->with('cart_courses');
    }
    public function wishlist(){
        return $this->hasMany(Wishlist::class)->with('course');
    }

    public function my_courses(){
        // $order_ids = Order::where('user_id',$this->id)->pluck('id')->toArray();
        return $this->hasMany(OrderCourse::class,'user_id')->where('progress','!=', 100)->with('course');
    }
    public function my_quizes(){
        $course_ids = OrderCourse::where('user_id',$this->id)->pluck('course_id')->toArray();
        return Exame::with('course','questions','result')->whereIn('course_id',$course_ids)->orderBy('id','Desc')->where('status',1)->get();

    }
    public function my_completed_courses(){
        return $this->hasMany(OrderCourse::class)->where('progress', 100)->with('course');
    }
    public function notifications(){
        return $this->hasMany(NotificationUser::class);
    }

    public function certificates(){
        return $this->hasMany(Certificate::class)->where('status',1)->with('course');
    }
    public function webinars(){
        return $this->hasMany(WebinarReservation::class)->with('webinar');
    }
    public function target(){
        return $this->belongsTo(CrmTarget::class,'target_type');
    }
    public function invoices(){
        $invoices = CrmClientEmployees::with('invoices')->where('user_id', $this->id)->get()->pluck('invoices')->flatten();
        return $invoices;
    }



    
}
