<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TrainingSchadual extends Model
{
    protected $table = 'trainings_schaduals';
    protected $guarded =[];  
    public $timestamps = false;
    
    public function training(){
        return $this->belongsTo(Training::class);
    }
    public function center(){
        return $this->belongsTo(Center::class);
    }
    public function hall(){
        return $this->belongsTo(CenterHall::class);
    }
    
    public function instructor(){
        $training_course = TrainingCourse::where('training_id',$this->training_id)->first();
        if(isset($training_course->instructor_id)){
            $user = User::where('id',$training_course->instructor_id)->first();
            if($user) return $user->name();
        }
         return '';
    }

}
