<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\ExameQuestion;
use App\Models\TrainingSchadual;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use DateTime;
use DB;
use Carbon\Carbon;

class Training extends Model
{
    protected $table = 'trainings';
     protected $guarded =[];  
    public function students(){
        return $this->hasMany(Student::class,'training_id');
    }
    public function am_student(){
        return $this->hasOne(Student::class,'training_id')->where('user_id',auth()->user()->id);
    }
    
    // public function courses(){
    //     return $this->hasMany(TrainingCourse::class);
    // }
    public function trainings_schaduals(){
        return $this->hasOne(TrainingSchadual::class,'training_id');
    }
   
    public function region(){
        return $this->belongsTo(Region::class,'region_id');
    }
    
    public function PartnerTrainingRequest(){
        return $this->belongsTo(PartnerTrainingRequest::class,'request_id');
    }
    
    public function exame(){
        return $this->hasOne(TrainingExam::class);
    }
    public function trainingSurvey(){
        return $this->hasOne(TrainingSurvey::class);
    }
    public function instructor_info(){
        $TrainingCourse = $this->courses()->first();
        if ($TrainingCourse) {
            return InstructorInfo::with('user')->where('user_id',$TrainingCourse->instructor_id)->first();
            // return $this->hasOne(InstructorInfo::class, 'user_id', $TrainingCourse->instructor_id);
        }
        return null;
    }
    public function instructor(){
        return $this->belongsTo(User::class, 'instructor_id');
    }
    
    public function field(){
        return $this->belongsTo(TrainingField::class, 'training_field_id');
    }
    public function training_attendance(){
        return $this->hasMany(TrainingAttendance::class,'training_id')->where('user_id',auth()->user()->id);
    }
    public function training_attachments_count(){
        return $this->hasMany(TrainingAttendanceAttachments::class,'training_id')->count();
    }
    
    public function getTrainingStatusAttribute()
    {
        $now = new DateTime();
        $start_date =  isset($this->trainings_schaduals->start_date) ? new DateTime($this->trainings_schaduals->start_date) : null ;
        $end_date =  isset($this->trainings_schaduals->end_date) ? new DateTime($this->trainings_schaduals->end_date) : null ;
        if($end_date == null || $start_date == null){
            return -1;
        }
        if($start_date > $now){
            return  0;
        }
        else if($start_date <= $now && $now <= $end_date) {
            return 1;
        } else if($end_date < $now) {
            return 2;
        }
    }
    
    public function n_joined(){
        return count($this->students);
    }
    
    public function getRouteKeyName(): string
    {
        $locale = LaravelLocalization::getCurrentLocale();
        return 'link_' . $locale;
    }
    
    public function level(){
        return $this->belongsTo(Level::class,'course_id');
    }
    
    public function course(){
        return $this->belongsTo(Course::class,'course_id');
    }

    public function category(){
        return $this->belongsTo(Category::class,'category_id');
    }
    public function type(){
        return $this->belongsTo(Type::class,'type_id');
    }

    // public function chapters(){
    //     return $this->hasMany(Chapter::class,'course_id')->with('lessons','exame')->orderBy('order');
    // }
    public function countLessons(){
        return $this->hasMany(Lesson::class,'course_id')->count();
    }
    public function countHistoryLessons($user_id){
        return $this->hasMany(LessonHistory::class,'course_id')->where('user_id',$user_id)->count();
    }
    public function points(){
        if(json_decode($this->course_point_id)) {
           return $points = CoursePoint::whereIN('id',json_decode($this->course_point_id))->get();
        } else {
            return null;
        }
    }
    public function include_materials(){
        if(json_decode($this->course_material_id)) {
            $course_materials = CourseMaterial::whereIN('id',json_decode($this->course_material_id))->get();
            return $course_materials;
        } else {
            return null;
        }
    }
    public function course_requirments(){
        if(json_decode($this->course_requirment_id)) {
            $course_requirments = CourseRequirment::whereIN('id',json_decode($this->course_requirment_id))->get();
            return $course_requirments;
        } else {
            return null;
        }
    }
    public function teachers(){
        $teacher_ids = json_decode($this->teacher_id);
        if($teacher_ids) {
            return Teacher::whereIn('id',$teacher_ids)->get();
        } else {
            return null;
        }
    }

    public function discount(){
        $discount = $this->hasOne(CourseDiscount::class, 'course_id');
        if(isset($discount->first()->end_date)) {
            $discount->where(DB::raw('DATE(end_date)'), '>', Carbon::now()->toDateString());
        }
        return $discount ?? 0 ;
    }
    public function website_discount(){
        $discount = $this->hasOne(CourseDiscount::class, 'course_id');
        if(isset($discount->first()->end_date)) {
            $discount->where(DB::raw('DATE(end_date)'), '>', Carbon::now()->toDateString());
        }
        return $discount ?? 0 ;
    }

    public function last_price(){
        $discount = $this->website_discount;
        if($discount){
            return ($this->price - $discount->value);
        }else{
            return $this->price;
        }
    }

    public function reviews(){
        return $this->hasMany(CourseReview::class,'course_id');
    }

    public function my_certificate(){
        return $this->hasOne(Certificate::class,'course_id');
    }


    public function orders(){
        return $this->hasMany(OrderCourse::class,'course_id');
    }
   
    
     
}
