<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

use App\Models\SurvayResult;

class Survey extends Model
{
    protected $table = 'survays';
    
    public function surveyQuestions(){
        return $this->hasMany(SurveyQuestion::class,'survay_id');
    }
    
    public function survayResult(){
        return $this->hasMany(SurvayResult::class,'survay_id')->where('user_id',auth()->user()->id);
    }
    
    public function singleSurvayResult($survey_id,$user_id,$training_id){
        return SurvayResult::where('survay_id',$survey_id)->where('user_id',$user_id)->where('training_id',$training_id)->get();
    }
}
